/*
 * Decompiled with CFR 0.152.
 */
package dev.fixyl.componentviewer.control.component;

import dev.fixyl.componentviewer.annotation.NullPermitted;
import dev.fixyl.componentviewer.config.enums.TooltipComponents;
import dev.fixyl.componentviewer.control.component.MappedItemStackComponents;
import dev.fixyl.componentviewer.control.component.PatchedItemStackComponents;
import java.util.Comparator;
import java.util.List;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.core.component.TypedDataComponent;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;

public abstract sealed class ItemStackComponents
permits MappedItemStackComponents, PatchedItemStackComponents {
    protected static final Comparator<DataComponentType<?>> REGISTRY_ID_COMPARATOR = Comparator.comparing(dataComponentType -> {
        ResourceLocation resourceLocation = BuiltInRegistries.DATA_COMPONENT_TYPE.getKey(dataComponentType);
        return resourceLocation == null ? "" : resourceLocation.toString();
    });
    protected final ItemStack itemStack;
    protected final TooltipComponents componentContext;

    protected ItemStackComponents(ItemStack itemStack, TooltipComponents componentContext) {
        this.itemStack = itemStack;
        this.componentContext = componentContext;
    }

    public ItemStack getItemStack() {
        return this.itemStack;
    }

    public TooltipComponents getComponentContext() {
        return this.componentContext;
    }

    public abstract int size();

    public abstract boolean isEmpty();

    public abstract List<DataComponentType<?>> getComponentTypes();

    @NullPermitted
    public abstract <T> T getValue(DataComponentType<T> var1);

    @NullPermitted
    public <T> TypedDataComponent<T> getTypedComponent(DataComponentType<T> dataComponentType) {
        @NullPermitted T value = this.getValue(dataComponentType);
        return value == null ? null : new TypedDataComponent(dataComponentType, value);
    }

    public abstract <T> boolean wasRemoved(DataComponentType<T> var1);

    public <T> int indexOf(@NullPermitted DataComponentType<T> dataComponentType) {
        if (dataComponentType == null) {
            return -1;
        }
        return this.getComponentTypes().indexOf(dataComponentType);
    }

    public static ItemStackComponents getComponents(ItemStack itemStack) {
        return new MappedItemStackComponents(itemStack, () -> ((ItemStack)itemStack).getComponents(), TooltipComponents.ALL);
    }

    public static ItemStackComponents getPrototypeComponents(ItemStack itemStack) {
        return new MappedItemStackComponents(itemStack, () -> ((ItemStack)itemStack).getPrototype(), TooltipComponents.DEFAULT);
    }

    public static ItemStackComponents getPatchedComponents(ItemStack itemStack) {
        return new PatchedItemStackComponents(itemStack, () -> ((ItemStack)itemStack).getComponentsPatch(), TooltipComponents.CHANGES);
    }

    public static ItemStackComponents getComponentsBasedOnContext(ItemStack itemStack, TooltipComponents componentContext) {
        return switch (componentContext) {
            default -> throw new MatchException(null, null);
            case TooltipComponents.ALL -> ItemStackComponents.getComponents(itemStack);
            case TooltipComponents.DEFAULT -> ItemStackComponents.getPrototypeComponents(itemStack);
            case TooltipComponents.CHANGES -> ItemStackComponents.getPatchedComponents(itemStack);
        };
    }
}

