/*
 * Decompiled with CFR 0.152.
 */
package dev.fixyl.componentviewer.control.notification;

import dev.fixyl.componentviewer.annotation.NullPermitted;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.toasts.Toast;
import net.minecraft.client.gui.components.toasts.ToastComponent;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;

public class CopyToast
implements Toast {
    private static final ResourceLocation BACKGROUND_SPRITE = ResourceLocation.withDefaultNamespace((String)"toast/advancement");
    private static final long DURATION = 3000L;
    private static final int ITEM_LEFT_MARGIN = 8;
    private static final int ITEM_TOP_MARGIN = 8;
    private static final int TEXT_LEFT_MARGIN = 8;
    private static final int TEXT_LEFT_MARGIN_WITH_ITEM = 30;
    private static final int TEXT_FIRST_ROW = 7;
    private static final int TEXT_SECOND_ROW = 18;
    private static final int FIRST_ROW_COLOR_SUCCESS = ChatFormatting.DARK_GREEN.getColor();
    private static final int SECOND_ROW_COLOR_SUCCESS = ChatFormatting.GOLD.getColor();
    private static final int FIRST_ROW_COLOR_FAILURE = ChatFormatting.RED.getColor();
    private static final int SECOND_ROW_COLOR_FAILURE = ChatFormatting.DARK_AQUA.getColor();
    private final Type toastType;
    @NullPermitted
    private final ItemStack itemStack;
    private final String translationKey;
    private final int firstRowColor;
    private final int secondRowColor;
    private final int textLeftMargin;
    private Toast.Visibility visibility;

    public CopyToast(Type type, @NullPermitted ItemStack itemStack) {
        this.toastType = type;
        this.itemStack = itemStack;
        if (type.success) {
            this.translationKey = "componentviewer.notification.toast.copy.success";
            this.firstRowColor = FIRST_ROW_COLOR_SUCCESS;
            this.secondRowColor = SECOND_ROW_COLOR_SUCCESS;
        } else {
            this.translationKey = "componentviewer.notification.toast.copy.failure";
            this.firstRowColor = FIRST_ROW_COLOR_FAILURE;
            this.secondRowColor = SECOND_ROW_COLOR_FAILURE;
        }
        this.textLeftMargin = itemStack == null ? 8 : 30;
        this.visibility = Toast.Visibility.SHOW;
    }

    public CopyToast(Type type) {
        this(type, null);
    }

    public Toast.Visibility render(GuiGraphics guiGraphics, ToastComponent toastComponent, long timeSinceLastVisible) {
        guiGraphics.blitSprite(BACKGROUND_SPRITE, 0, 0, this.width(), this.height());
        if (this.itemStack != null) {
            guiGraphics.renderFakeItem(this.itemStack, 8, 8);
        }
        Font font = toastComponent.getMinecraft().font;
        guiGraphics.drawString(font, (Component)Component.translatable((String)this.translationKey), this.textLeftMargin, 7, this.firstRowColor, false);
        guiGraphics.drawString(font, (Component)Component.translatable((String)this.toastType.translationKey), this.textLeftMargin, 18, this.secondRowColor, false);
        this.updateVisibility(toastComponent, timeSinceLastVisible);
        return this.visibility;
    }

    public Type getToken() {
        return this.toastType;
    }

    private void updateVisibility(ToastComponent toastComponent, long timeSinceLastVisible) {
        double actualDuration = 3000.0 * toastComponent.getNotificationDisplayTimeMultiplier();
        this.visibility = (double)timeSinceLastVisible < actualDuration ? Toast.Visibility.SHOW : Toast.Visibility.HIDE;
    }

    public static CopyToast dispatch(Type type, @NullPermitted ItemStack itemStack) {
        CopyToast toast = new CopyToast(type, itemStack);
        Minecraft.getInstance().getToasts().addToast((Toast)toast);
        return toast;
    }

    public static CopyToast dispatch(Type type) {
        return CopyToast.dispatch(type, null);
    }

    public static enum Type {
        COMPONENT_VALUE("componentviewer.notification.toast.copy.type.component_value", true),
        ITEM_STACK("componentviewer.notification.toast.copy.type.item_stack", true),
        GIVE_COMMAND("componentviewer.notification.toast.copy.type.give_command", true),
        FORMATTING_EXCEPTION("componentviewer.notification.toast.copy.type.formatting_exception", false);

        private final String translationKey;
        private final boolean success;

        private Type(String translationKey, boolean success) {
            this.translationKey = translationKey;
            this.success = success;
        }
    }
}

