/*
 * Decompiled with CFR 0.152.
 */
package dev.fixyl.componentviewer;

import dev.fixyl.componentviewer.DisablableMod;
import dev.fixyl.componentviewer.config.Configs;
import dev.fixyl.componentviewer.config.enums.DisableMod;
import dev.fixyl.componentviewer.event.EventDispatcher;
import java.nio.file.Path;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.function.Function;
import net.minecraft.class_1132;
import net.minecraft.class_1934;
import net.minecraft.class_310;
import net.minecraft.class_746;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class ComponentViewer
implements DisablableMod {
    public static final String MOD_ID = "componentviewer";
    private static ComponentViewer instance;
    public final Logger logger;
    public final EventDispatcher eventDispatcher;
    public final Configs configs;

    protected ComponentViewer(EventDispatcher eventDispatcher, Path configDir) {
        ComponentViewer.setInstance(this);
        this.logger = LoggerFactory.getLogger(this.getClass());
        this.eventDispatcher = eventDispatcher;
        this.configs = new Configs(configDir, this.logger);
    }

    @Override
    public boolean isModDisabled() {
        return switch ((DisableMod)((Object)this.configs.disableMod.getValue())) {
            default -> throw new MatchException(null, null);
            case DisableMod.NEVER -> false;
            case DisableMod.IN_SURVIVAL -> this.currentlyInSurvival();
            case DisableMod.ON_SERVER -> this.currentlyOnServer();
            case DisableMod.BOTH -> this.currentlyInSurvival() && this.currentlyOnServer();
        };
    }

    public static void dispatchEventSafely(Consumer<EventDispatcher> consumer) {
        if (instance != null) {
            consumer.accept(ComponentViewer.instance.eventDispatcher);
        }
    }

    public static <R> Optional<R> dispatchEventWithResultSafely(Function<EventDispatcher, R> function) {
        if (instance != null) {
            return Optional.ofNullable(function.apply(ComponentViewer.instance.eventDispatcher));
        }
        return Optional.empty();
    }

    public static ComponentViewer getInstance() {
        if (instance == null) {
            throw new IllegalStateException(String.format("'%s' hasn't been instantiated yet!", ComponentViewer.class.getName()));
        }
        return instance;
    }

    private static void setInstance(ComponentViewer instance) {
        if (ComponentViewer.instance != null) {
            throw new IllegalStateException(String.format("Cannot instantiate '%s' twice!", ComponentViewer.class.getName()));
        }
        ComponentViewer.instance = instance;
    }

    protected static class_310 getMinecraftClient() {
        class_310 minecraftClient = class_310.method_1551();
        if (minecraftClient == null) {
            throw new IllegalStateException("Minecraft hasn't been initialized yet, although it should!");
        }
        return minecraftClient;
    }

    private boolean currentlyInSurvival() {
        class_746 player = ComponentViewer.getMinecraftClient().field_1724;
        if (player == null) {
            return false;
        }
        class_1934 gameMode = player.method_68876();
        return gameMode != null && gameMode.method_8388();
    }

    private boolean currentlyOnServer() {
        class_310 minecraftClient = ComponentViewer.getMinecraftClient();
        class_1132 integratedServer = minecraftClient.method_1576();
        return minecraftClient.method_1558() != null || integratedServer != null && integratedServer.method_3860();
    }
}

