/*
 * Decompiled with CFR 0.152.
 */
package dev.fixyl.componentviewer.control;

import dev.fixyl.componentviewer.annotation.NullPermitted;
import dev.fixyl.componentviewer.config.Configs;
import dev.fixyl.componentviewer.config.enums.TooltipComponents;
import dev.fixyl.componentviewer.control.Selection;
import dev.fixyl.componentviewer.control.component.ItemStackComponents;
import java.util.Optional;
import net.minecraft.class_1799;
import net.minecraft.class_9331;
import net.minecraft.class_9336;

public class HoveredItemStack {
    private final class_1799 itemStack;
    private final Configs configs;
    private ItemStackComponents components;
    @NullPermitted
    private Selection componentSelection;

    public HoveredItemStack(class_1799 itemStack, Configs configs) {
        this.itemStack = itemStack;
        this.configs = configs;
    }

    public class_1799 getItemStack() {
        return this.itemStack;
    }

    public ItemStackComponents getComponents() {
        TooltipComponents componentContextFromConfig = (TooltipComponents)((Object)this.configs.tooltipComponents.getValue());
        if (this.components == null || this.components.getComponentContext() != componentContextFromConfig) {
            this.components = ItemStackComponents.getComponentsBasedOnContext(this.itemStack, componentContextFromConfig);
        }
        return this.components;
    }

    public Optional<Selection> getComponentSelection() {
        int amountOfComponents = this.getComponents().size();
        if (amountOfComponents <= 0) {
            this.componentSelection = null;
        } else if (this.componentSelection == null) {
            this.componentSelection = new Selection(amountOfComponents);
        } else if (amountOfComponents != this.componentSelection.getAmount()) {
            this.componentSelection.setAmount(amountOfComponents);
        }
        return Optional.ofNullable(this.componentSelection);
    }

    public Optional<class_9336<?>> getSelectedComponent() {
        Optional<Selection> optionalComponentSelection = this.getComponentSelection();
        if (optionalComponentSelection.isEmpty()) {
            return Optional.empty();
        }
        ItemStackComponents currentComponents = this.getComponents();
        int selectedIndex = optionalComponentSelection.orElseThrow().getSelectedIndex();
        class_9331<?> selectedType = currentComponents.getComponentTypes().get(selectedIndex);
        return Optional.of(currentComponents.getTypedComponent(selectedType));
    }
}

