/*
 * Decompiled with CFR 0.152.
 */
package dev.fixyl.componentviewer.control.component;

import dev.fixyl.componentviewer.annotation.NullPermitted;
import dev.fixyl.componentviewer.config.enums.TooltipComponents;
import dev.fixyl.componentviewer.control.component.MappedItemStackComponents;
import dev.fixyl.componentviewer.control.component.PatchedItemStackComponents;
import java.util.Comparator;
import java.util.List;
import net.minecraft.class_1799;
import net.minecraft.class_2960;
import net.minecraft.class_7923;
import net.minecraft.class_9331;
import net.minecraft.class_9336;

public abstract sealed class ItemStackComponents
permits MappedItemStackComponents, PatchedItemStackComponents {
    protected static final Comparator<class_9331<?>> REGISTRY_ID_COMPARATOR = Comparator.comparing(dataComponentType -> {
        class_2960 resourceLocation = class_7923.field_49658.method_10221(dataComponentType);
        return resourceLocation == null ? "" : resourceLocation.toString();
    });
    protected final class_1799 itemStack;
    protected final TooltipComponents componentContext;

    protected ItemStackComponents(class_1799 itemStack, TooltipComponents componentContext) {
        this.itemStack = itemStack;
        this.componentContext = componentContext;
    }

    public class_1799 getItemStack() {
        return this.itemStack;
    }

    public TooltipComponents getComponentContext() {
        return this.componentContext;
    }

    public abstract int size();

    public abstract boolean isEmpty();

    public abstract List<class_9331<?>> getComponentTypes();

    @NullPermitted
    public abstract <T> T getValue(class_9331<T> var1);

    @NullPermitted
    public <T> class_9336<T> getTypedComponent(class_9331<T> dataComponentType) {
        @NullPermitted T value = this.getValue(dataComponentType);
        return value == null ? null : new class_9336(dataComponentType, value);
    }

    public abstract <T> boolean wasRemoved(class_9331<T> var1);

    public <T> int indexOf(@NullPermitted class_9331<T> dataComponentType) {
        if (dataComponentType == null) {
            return -1;
        }
        return this.getComponentTypes().indexOf(dataComponentType);
    }

    public static ItemStackComponents getComponents(class_1799 itemStack) {
        return new MappedItemStackComponents(itemStack, () -> ((class_1799)itemStack).method_57353(), TooltipComponents.ALL);
    }

    public static ItemStackComponents getPrototypeComponents(class_1799 itemStack) {
        return new MappedItemStackComponents(itemStack, () -> ((class_1799)itemStack).method_58658(), TooltipComponents.DEFAULT);
    }

    public static ItemStackComponents getPatchedComponents(class_1799 itemStack) {
        return new PatchedItemStackComponents(itemStack, () -> ((class_1799)itemStack).method_57380(), TooltipComponents.CHANGES);
    }

    public static ItemStackComponents getComponentsBasedOnContext(class_1799 itemStack, TooltipComponents componentContext) {
        return switch (componentContext) {
            default -> throw new MatchException(null, null);
            case TooltipComponents.ALL -> ItemStackComponents.getComponents(itemStack);
            case TooltipComponents.DEFAULT -> ItemStackComponents.getPrototypeComponents(itemStack);
            case TooltipComponents.CHANGES -> ItemStackComponents.getPatchedComponents(itemStack);
        };
    }
}

