/*
 * Decompiled with CFR 0.152.
 */
package dev.fixyl.componentviewer.control.notification;

import dev.fixyl.componentviewer.annotation.NullPermitted;
import dev.fixyl.componentviewer.config.option.EnumOption;
import java.util.Objects;
import net.minecraft.class_10799;
import net.minecraft.class_124;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_327;
import net.minecraft.class_332;
import net.minecraft.class_368;
import net.minecraft.class_374;
import net.minecraft.class_7291;
import net.minecraft.class_9848;

public class EnumOptionToast<E extends Enum<E>>
implements class_368 {
    private static final class_2960 BACKGROUND_SPRITE = class_2960.method_60656((String)"toast/advancement");
    private static final long DURATION = 2000L;
    private static final int TEXT_LEFT_MARGIN = 8;
    private static final int TEXT_FIRST_ROW = 7;
    private static final int TEXT_SECOND_ROW = 18;
    private static final int FIRST_ROW_COLOR = class_9848.method_61334((int)class_124.field_1062.method_532());
    private static final int SECOND_ROW_COLOR = class_9848.method_61334((int)class_124.field_1068.method_532());
    private final EnumOption<E> option;
    private final String translationKey;
    private long totalDuration;
    private boolean shouldResetTimer;
    private class_368.class_369 visibility;

    public EnumOptionToast(EnumOption<E> option, @NullPermitted String translationKey) {
        this.option = option;
        this.translationKey = Objects.requireNonNullElse(translationKey, option.getTranslationKey());
        this.totalDuration = 2000L;
        this.shouldResetTimer = false;
        this.visibility = class_368.class_369.field_2210;
    }

    public void resetTimer() {
        this.shouldResetTimer = true;
    }

    public class_368.class_369 method_61988() {
        return this.visibility;
    }

    public void method_61989(class_374 toastManager, long visibilityTime) {
        double actualDuration;
        if (this.shouldResetTimer) {
            this.shouldResetTimer = false;
            this.totalDuration = visibilityTime + 2000L;
        }
        this.visibility = (double)visibilityTime < (actualDuration = (double)(this.totalDuration - 2000L) + 2000.0 * toastManager.method_48221()) ? class_368.class_369.field_2210 : class_368.class_369.field_2209;
    }

    public void method_1986(class_332 guiGraphics, class_327 font, long visibilityTime) {
        guiGraphics.method_52706(class_10799.field_56883, BACKGROUND_SPRITE, 0, 0, this.method_29049(), this.method_29050());
        guiGraphics.method_51439(font, (class_2561)class_2561.method_43471((String)this.translationKey), 8, 7, FIRST_ROW_COLOR, false);
        guiGraphics.method_51439(font, ((class_7291)((Enum)this.option.getValue())).method_42627(), 8, 18, SECOND_ROW_COLOR, false);
    }

    public static <E extends Enum<E>> EnumOptionToast<E> dispatch(EnumOption<E> option, @NullPermitted String translationKey) {
        EnumOptionToast<E> toast = new EnumOptionToast<E>(option, translationKey);
        class_310.method_1551().method_1566().method_1999(toast);
        return toast;
    }

    public static <E extends Enum<E>> EnumOptionToast<E> dispatch(EnumOption<E> option) {
        return EnumOptionToast.dispatch(option, null);
    }
}

