/*
 * Decompiled with CFR 0.152.
 */
package dev.fixyl.componentviewer.formatting;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonPrimitive;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import dev.fixyl.componentviewer.annotation.NullPermitted;
import dev.fixyl.componentviewer.formatting.CodecBasedFormatter;
import dev.fixyl.componentviewer.formatting.FormattingException;
import dev.fixyl.componentviewer.util.ResultCache;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import net.minecraft.class_124;
import net.minecraft.class_2561;
import net.minecraft.class_2583;
import net.minecraft.class_310;
import net.minecraft.class_5250;
import net.minecraft.class_746;

public class JsonFormatter
implements CodecBasedFormatter {
    private static final String NO_CODEC_REPR = "{}";
    private static final Pattern STRING_ESCAPE_PATTERN = Pattern.compile("[\\\\\"]");
    private static final String STRING_ESCAPE_REPLACEMENT = "\\\\$0";
    private static final Map<JsonType, class_2583> JSON_STYLES = Map.ofEntries(Map.entry(JsonType.SPECIAL, class_2583.field_24360.method_10977(class_124.field_1068)), Map.entry(JsonType.KEY, class_2583.field_24360.method_10977(class_124.field_1075)), Map.entry(JsonType.STRING, class_2583.field_24360.method_10977(class_124.field_1060)), Map.entry(JsonType.NUMBER, class_2583.field_24360.method_10977(class_124.field_1065)), Map.entry(JsonType.BOOLEAN, class_2583.field_24360.method_10977(class_124.field_1065)), Map.entry(JsonType.NULL, class_2583.field_24360.method_10977(class_124.field_1078)));
    private final ResultCache<String> stringResultCache = new ResultCache();
    private final ResultCache<List<class_2561>> textResultCache = new ResultCache();
    private final Map<Integer, String> newLinePrefixCache = new HashMap<Integer, String>();
    private int indentation;
    private boolean colored;
    private String linePrefix;
    private String indentPrefix;
    private boolean isNewLinePrefixSet = false;
    private List<class_2561> textList;
    private class_5250 textLine;
    private int indentLevel;

    @Override
    public <T> String codecToString(T value, @NullPermitted Codec<T> codec, int indentation, String linePrefix) {
        return this.stringResultCache.cache(() -> {
            List<class_2561> formattedTextList = this.getFormattedTextList(value, codec, indentation, false, linePrefix);
            return formattedTextList.stream().map(class_2561::getString).collect(Collectors.joining(System.lineSeparator()));
        }, value, codec, indentation, linePrefix);
    }

    @Override
    public <T> List<class_2561> codecToText(T value, @NullPermitted Codec<T> codec, int indentation, boolean colored, String linePrefix) {
        return Collections.unmodifiableList(this.textResultCache.cache(() -> this.getFormattedTextList(value, codec, indentation, colored, linePrefix), value, codec, indentation, colored, linePrefix));
    }

    private class_2583 getStyle(JsonType jsonType) {
        if (!this.colored) {
            return NO_COLOR_STYLE;
        }
        return JSON_STYLES.get((Object)jsonType);
    }

    private class_2583 getStyle() {
        return this.getStyle(JsonType.SPECIAL);
    }

    private void updateNewLinePrefix(int indentation, String linePrefix) {
        if (this.isNewLinePrefixSet && this.indentation == indentation && this.linePrefix.equals(linePrefix)) {
            return;
        }
        this.indentation = indentation;
        this.indentPrefix = " ".repeat(indentation);
        this.linePrefix = linePrefix;
        this.isNewLinePrefixSet = true;
        if (this.newLinePrefixCache != null) {
            this.newLinePrefixCache.clear();
        }
    }

    private String getNewLinePrefix() {
        if (this.indentLevel <= 0) {
            return this.linePrefix;
        }
        return this.newLinePrefixCache.computeIfAbsent(this.indentLevel, key -> this.linePrefix + this.indentPrefix.repeat((int)key));
    }

    private <T> List<class_2561> getFormattedTextList(T value, @NullPermitted Codec<T> codec, int indentation, boolean colored, String linePrefix) {
        this.updateNewLinePrefix(indentation, linePrefix);
        this.colored = colored;
        this.textList = new ArrayList<class_2561>();
        this.textLine = class_2561.method_43470((String)linePrefix);
        this.indentLevel = 0;
        if (codec == null) {
            this.textLine.method_10852((class_2561)class_2561.method_43470((String)NO_CODEC_REPR).method_27696(this.getStyle()));
            this.textList.add((class_2561)this.textLine);
            return this.textList;
        }
        class_746 player = class_310.method_1551().field_1724;
        JsonOps ops = player == null ? JsonOps.INSTANCE : player.method_56673().method_57093((DynamicOps)JsonOps.INSTANCE);
        JsonElement jsonElement = (JsonElement)codec.encodeStart((DynamicOps)ops, value).getOrThrow(FormattingException::new);
        this.walkJson(jsonElement);
        if (this.indentLevel != 0) {
            throw new FormattingException(String.format("Indent level must end up being zero! But it was %s.", this.indentLevel));
        }
        if (!this.textLine.getString().isEmpty()) {
            this.textList.add((class_2561)this.textLine);
        }
        return this.textList;
    }

    private void walkJson(JsonElement jsonElement) {
        if (jsonElement.isJsonObject()) {
            this.processJsonObject(jsonElement.getAsJsonObject());
        } else if (jsonElement.isJsonArray()) {
            this.processJsonArray(jsonElement.getAsJsonArray());
        } else if (jsonElement.isJsonPrimitive()) {
            this.processJsonPrimitive(jsonElement.getAsJsonPrimitive());
        } else if (jsonElement.isJsonNull()) {
            this.processJsonNull();
        } else {
            throw new FormattingException("Unknown JSON element");
        }
    }

    private void processJsonObject(JsonObject jsonObject) {
        this.textLine.method_10852((class_2561)class_2561.method_43470((String)"{").method_27696(this.getStyle()));
        if (!jsonObject.isEmpty()) {
            this.createNewLine(1);
            Iterator iterator = jsonObject.entrySet().iterator();
            while (iterator.hasNext()) {
                Map.Entry entry = (Map.Entry)iterator.next();
                this.textLine.method_10852((class_2561)class_2561.method_43470((String)"\"").method_27696(this.getStyle())).method_10852((class_2561)class_2561.method_43470((String)((String)entry.getKey())).method_27696(this.getStyle(JsonType.KEY))).method_10852((class_2561)class_2561.method_43470((String)"\": ").method_27696(this.getStyle()));
                this.walkJson((JsonElement)entry.getValue());
                if (!iterator.hasNext()) break;
                this.textLine.method_10852((class_2561)class_2561.method_43470((String)",").method_27696(this.getStyle()));
                this.createNewLine(0);
            }
            this.createNewLine(-1);
        }
        this.textLine.method_10852((class_2561)class_2561.method_43470((String)"}").method_27696(this.getStyle()));
    }

    private void processJsonArray(JsonArray jsonArray) {
        this.textLine.method_10852((class_2561)class_2561.method_43470((String)"[").method_27696(this.getStyle()));
        if (!jsonArray.isEmpty()) {
            this.createNewLine(1);
            Iterator iterator = jsonArray.iterator();
            while (iterator.hasNext()) {
                JsonElement jsonElement = (JsonElement)iterator.next();
                this.walkJson(jsonElement);
                if (!iterator.hasNext()) break;
                this.textLine.method_10852((class_2561)class_2561.method_43470((String)",").method_27696(this.getStyle()));
                this.createNewLine(0);
            }
            this.createNewLine(-1);
        }
        this.textLine.method_10852((class_2561)class_2561.method_43470((String)"]").method_27696(this.getStyle()));
    }

    private void processJsonPrimitive(JsonPrimitive jsonPrimitive) {
        if (jsonPrimitive.isString()) {
            this.textLine.method_10852((class_2561)class_2561.method_43470((String)"\"").method_27696(this.getStyle())).method_10852((class_2561)class_2561.method_43470((String)JsonFormatter.escapeString(jsonPrimitive.getAsString())).method_27696(this.getStyle(JsonType.STRING))).method_10852((class_2561)class_2561.method_43470((String)"\"").method_27696(this.getStyle()));
        } else if (jsonPrimitive.isNumber()) {
            this.textLine.method_10852((class_2561)class_2561.method_43470((String)jsonPrimitive.getAsString()).method_27696(this.getStyle(JsonType.NUMBER)));
        } else if (jsonPrimitive.isBoolean()) {
            this.textLine.method_10852((class_2561)class_2561.method_43470((String)jsonPrimitive.getAsString()).method_27696(this.getStyle(JsonType.BOOLEAN)));
        } else {
            throw new FormattingException("Unknown JSON primitive");
        }
    }

    private void processJsonNull() {
        this.textLine.method_10852((class_2561)class_2561.method_43470((String)"null").method_27696(this.getStyle(JsonType.NULL)));
    }

    private void createNewLine(int indentChange) {
        this.indentLevel += indentChange;
        if (this.indentation > 0) {
            this.textList.add((class_2561)this.textLine);
            this.textLine = class_2561.method_43470((String)this.getNewLinePrefix());
        } else if (indentChange == 0) {
            this.textLine.method_10852((class_2561)class_2561.method_43470((String)" "));
        }
    }

    private static String escapeString(String string) {
        Matcher matcher = STRING_ESCAPE_PATTERN.matcher(string);
        return matcher.replaceAll(STRING_ESCAPE_REPLACEMENT);
    }

    private static enum JsonType {
        SPECIAL,
        KEY,
        STRING,
        NUMBER,
        BOOLEAN,
        NULL;

    }
}

