/*
 * Decompiled with CFR 0.152.
 */
package dev.fixyl.componentviewer.formatting;

import dev.fixyl.componentviewer.formatting.Formatter;
import dev.fixyl.componentviewer.formatting.FormattingException;
import dev.fixyl.componentviewer.util.ResultCache;
import java.util.ArrayList;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.minecraft.class_124;
import net.minecraft.class_1799;
import net.minecraft.class_2561;
import net.minecraft.class_2583;
import net.minecraft.class_5250;
import net.minecraft.class_9336;

public class ObjectFormatter
implements Formatter {
    private static final Map<TokenType, class_2583> TOKEN_STYLES = Map.ofEntries(Map.entry(TokenType.ANY, class_2583.field_24360.method_10977(class_124.field_1075)), Map.entry(TokenType.SPECIAL, class_2583.field_24360.method_10977(class_124.field_1068)), Map.entry(TokenType.OPENING_BRACKET, class_2583.field_24360.method_10977(class_124.field_1068)), Map.entry(TokenType.CLOSING_BRACKET, class_2583.field_24360.method_10977(class_124.field_1068)), Map.entry(TokenType.COMMA, class_2583.field_24360.method_10977(class_124.field_1068)), Map.entry(TokenType.QUOTE, class_2583.field_24360.method_10977(class_124.field_1068)), Map.entry(TokenType.STRING, class_2583.field_24360.method_10977(class_124.field_1060)), Map.entry(TokenType.INTEGER, class_2583.field_24360.method_10977(class_124.field_1065)), Map.entry(TokenType.FLOAT, class_2583.field_24360.method_10977(class_124.field_1065)), Map.entry(TokenType.HEX, class_2583.field_24360.method_10977(class_124.field_1065)), Map.entry(TokenType.BOOLEAN, class_2583.field_24360.method_10977(class_124.field_1065)), Map.entry(TokenType.NULL, class_2583.field_24360.method_10977(class_124.field_1078)));
    private static final Map<Character, Character> BRACKET_PAIR = Map.of(Character.valueOf('('), Character.valueOf(')'), Character.valueOf('{'), Character.valueOf('}'), Character.valueOf('['), Character.valueOf(']'));
    private final ResultCache<String> stringResultCache = new ResultCache();
    private final ResultCache<List<class_2561>> textResultCache = new ResultCache();
    private final Tokenizer tokenizer = new Tokenizer();
    private final Map<Integer, String> newLinePrefixCache = new HashMap<Integer, String>();
    private int indentation;
    private boolean colored;
    private String indentPrefix;
    private String linePrefix;
    private boolean isNewLinePrefixSet = false;
    private List<Token> tokens;
    private int currentIndex;
    private Token currentToken;
    private int indentLevel;
    private List<Character> bracketHistory;
    private State state;
    private boolean formatAsText;
    private List<class_2561> textList;
    private class_5250 textLine;
    private StringBuilder stringBuilder;

    @Override
    public <T> String componentToString(class_9336<T> component, int indentation, String linePrefix) {
        return this.valueToString(component.comp_2444().toString(), indentation, linePrefix);
    }

    @Override
    public <T> List<class_2561> componentToText(class_9336<T> component, int indentation, boolean colored, String linePrefix) {
        return this.valueToText(component.comp_2444().toString(), indentation, colored, linePrefix);
    }

    @Override
    public String itemStackToString(class_1799 itemStack, int indentation, String linePrefix) {
        return this.valueToString(itemStack.toString(), indentation, linePrefix);
    }

    @Override
    public List<class_2561> itemStackToText(class_1799 itemStack, int indentation, boolean colored, String linePrefix) {
        return this.valueToText(itemStack.toString(), indentation, colored, linePrefix);
    }

    private String valueToString(String value, int indentation, String linePrefix) {
        return this.stringResultCache.cache(() -> {
            if (indentation <= 0) {
                return linePrefix + value;
            }
            List<Token> tokenList = this.tokenizer.tokenize(value);
            return this.formatTokensAsString(tokenList, indentation, linePrefix);
        }, value, indentation, linePrefix);
    }

    private List<class_2561> valueToText(String value, int indentation, boolean colored, String linePrefix) {
        return Collections.unmodifiableList(this.textResultCache.cache(() -> {
            if (indentation <= 0 && !colored) {
                return List.of(class_2561.method_43470((String)(linePrefix + value)).method_27696(NO_COLOR_STYLE));
            }
            List<Token> tokenList = this.tokenizer.tokenize(value);
            if (indentation <= 0) {
                class_5250 line = class_2561.method_43470((String)linePrefix);
                for (Token token : tokenList) {
                    line.method_10852((class_2561)class_2561.method_43470((String)token.content()).method_27696(TOKEN_STYLES.get((Object)token.tokenType())));
                }
                return List.of(line);
            }
            return this.formatTokensAsText(tokenList, indentation, colored, linePrefix);
        }, value, indentation, colored, linePrefix));
    }

    private String formatTokensAsString(List<Token> tokens, int indentation, String linePrefix) {
        this.formatAsText = false;
        this.stringBuilder = new StringBuilder(linePrefix);
        this.formatTokens(tokens, indentation, linePrefix);
        return this.stringBuilder.toString();
    }

    private List<class_2561> formatTokensAsText(List<Token> tokens, int indentation, boolean colored, String linePrefix) {
        this.formatAsText = true;
        this.textList = new ArrayList<class_2561>();
        this.textLine = class_2561.method_43470((String)linePrefix);
        this.colored = colored;
        if (!this.colored) {
            this.textLine.method_27696(NO_COLOR_STYLE);
        }
        this.formatTokens(tokens, indentation, linePrefix);
        if (!this.textLine.getString().isEmpty()) {
            this.textList.add((class_2561)this.textLine);
        }
        return this.textList;
    }

    private void updateNewLinePrefix(int indentation, String linePrefix) {
        if (this.isNewLinePrefixSet && this.indentation == indentation && this.linePrefix.equals(linePrefix)) {
            return;
        }
        this.indentation = indentation;
        this.indentPrefix = " ".repeat(indentation);
        this.linePrefix = linePrefix;
        this.isNewLinePrefixSet = true;
        if (this.newLinePrefixCache != null) {
            this.newLinePrefixCache.clear();
        }
    }

    private String getNewLinePrefix() {
        if (this.indentLevel <= 0) {
            return this.linePrefix;
        }
        return this.newLinePrefixCache.computeIfAbsent(this.indentLevel, key -> this.linePrefix + this.indentPrefix.repeat((int)key));
    }

    private void formatTokens(List<Token> tokens, int indentation, String linePrefix) {
        this.updateNewLinePrefix(indentation, linePrefix);
        this.tokens = tokens;
        this.indentLevel = 0;
        this.bracketHistory = new ArrayList<Character>();
        this.state = State.DEFAULT;
        this.currentIndex = 0;
        while (this.currentIndex < this.tokens.size()) {
            this.currentToken = this.tokens.get(this.currentIndex);
            this.processToken();
            ++this.currentIndex;
        }
        if (this.indentLevel != 0) {
            throw new FormattingException(String.format("Indent level must end up being zero! But it was %s.", this.indentLevel));
        }
    }

    private void processToken() {
        switch (this.currentToken.tokenType().ordinal()) {
            case 4: {
                this.processCommaToken();
                break;
            }
            case 2: {
                this.processOpeningBracketToken();
                break;
            }
            case 3: {
                this.processClosingBracketToken();
                break;
            }
            default: {
                this.addCurrentToken();
            }
        }
    }

    private void processCommaToken() {
        this.addCurrentToken();
        this.createNewLine(0);
    }

    private void processOpeningBracketToken() {
        this.bracketHistory.add(Character.valueOf(this.currentToken.content().charAt(0)));
        this.addCurrentToken();
        if (this.currentIndex < this.tokens.size() - 1 && this.tokens.get(this.currentIndex + 1).tokenType() == TokenType.CLOSING_BRACKET) {
            this.state = State.EMPTY_BRACKETS;
            return;
        }
        this.createNewLine(1);
    }

    private void processClosingBracketToken() {
        char bracketCharacter = this.currentToken.content().charAt(0);
        if (this.bracketHistory.isEmpty() || !BRACKET_PAIR.get(this.bracketHistory.getLast()).equals(Character.valueOf(bracketCharacter))) {
            throw new FormattingException(String.format("Unexpected bracket '%s' encountered! Either no pair was to be closed, or a different bracket opened this pair.", Character.valueOf(bracketCharacter)));
        }
        this.bracketHistory.removeLast();
        if (this.state == State.EMPTY_BRACKETS) {
            this.state = State.DEFAULT;
        } else {
            this.createNewLine(-1);
        }
        this.addCurrentToken();
    }

    private void createNewLine(int indentChange) {
        this.indentLevel += indentChange;
        if (this.formatAsText) {
            this.textList.add((class_2561)this.textLine);
            this.textLine = class_2561.method_43470((String)this.getNewLinePrefix());
            if (!this.colored) {
                this.textLine.method_27696(NO_COLOR_STYLE);
            }
        } else {
            this.stringBuilder.append(System.lineSeparator()).append(this.getNewLinePrefix());
        }
        this.state = State.NEW_LINE;
    }

    private void addCurrentToken() {
        String tokenContent = this.currentToken.content();
        if (this.state == State.NEW_LINE) {
            tokenContent = tokenContent.stripLeading();
            this.state = State.DEFAULT;
        }
        if (this.formatAsText) {
            this.textLine.method_10852((class_2561)class_2561.method_43470((String)tokenContent).method_27696(this.colored ? TOKEN_STYLES.get((Object)this.currentToken.tokenType()) : NO_COLOR_STYLE));
        } else {
            this.stringBuilder.append(tokenContent);
        }
    }

    private static class Tokenizer {
        private static final Pattern NON_WORD_CHAR_PATTERN = Pattern.compile("^[^\\p{L}\\p{N}_]$");
        private static final Pattern NON_WORD_DOT_CHAR_PATTERN = Pattern.compile("^[^\\p{L}\\p{N}_.]$");
        private static final Pattern NON_WORD_DOT_DASH_CHAR_PATTERN = Pattern.compile("^[^\\p{L}\\p{N}_.\\-]$");
        private static final Pattern CURLY_BRACKET_STRING_BEGIN_PATTERN = Pattern.compile("^(keybind|literal|pattern)\\{");
        private static final Pattern INTEGER_PATTERN = Pattern.compile("^(-?\\d+)(?![\\p{L}\\p{N}_.\\-])");
        private static final Pattern FLOAT_PATTERN = Pattern.compile("^(-?\\d+\\.\\d+)(?![\\p{L}\\p{N}_.\\-])");
        private static final Pattern HEX_PATTERN = Pattern.compile("^([a-fA-F\\d]+)(?![\\p{L}\\p{N}_.])");
        private static final Pattern BOOLEAN_PATTERN = Pattern.compile("^(true|false)(?![\\p{L}\\p{N}_])");
        private static final Pattern NULL_PATTERN = Pattern.compile("^(null)(?![\\p{L}\\p{N}_])");
        private Map<Pattern, Matcher> patternMatcherMap;
        private String currentString;
        private int stringLength;
        private int currentIndex;
        private char currentChar;
        private List<Token> tokens;
        private StringBuilder currentTokenContent;
        private TokenType currentTokenType;
        private TokenizerState tokenizerState;
        private char currentOpeningQuote;

        private Tokenizer() {
        }

        public List<Token> tokenize(String string) {
            this.initializeTokenizerVariables(string);
            while (this.currentIndex < this.stringLength) {
                this.currentChar = string.charAt(this.currentIndex);
                this.processCharacter();
                ++this.currentIndex;
            }
            this.finishCurrentToken();
            return this.tokens;
        }

        private void initializeTokenizerVariables(String string) {
            this.patternMatcherMap = new IdentityHashMap<Pattern, Matcher>();
            this.currentString = string;
            this.stringLength = string.length();
            this.currentIndex = 0;
            this.tokens = new ArrayList<Token>();
            this.currentTokenContent = new StringBuilder();
            this.currentTokenType = TokenType.ANY;
            this.tokenizerState = TokenizerState.DEFAULT;
            this.currentOpeningQuote = '\u0000';
        }

        private Matcher getMatcherFromPattern(Pattern pattern) {
            return this.patternMatcherMap.computeIfAbsent(pattern, key -> key.matcher(this.currentString));
        }

        private void processCharacter() {
            switch (this.tokenizerState.ordinal()) {
                case 0: {
                    this.processDefaultTokenizerState();
                    break;
                }
                case 1: {
                    this.processStringTokenizerState();
                    break;
                }
                case 2: {
                    this.processCurlyBracketStringTokenizerState();
                }
            }
        }

        private void processDefaultTokenizerState() {
            if (Tokenizer.isCurlyBracketStringBeginCharacter(this.currentChar) && this.matchCurlyBracketStringBegin()) {
                return;
            }
            if (Tokenizer.isNumberCharacter(this.currentChar) && this.matchNumber()) {
                return;
            }
            if (Tokenizer.isBooleanCharacter(this.currentChar) && this.matchBoolean()) {
                return;
            }
            if (Tokenizer.isNullCharacter(this.currentChar) && this.matchNull()) {
                return;
            }
            switch (this.currentChar) {
                case ',': 
                case ';': {
                    this.processComma();
                    break;
                }
                case '(': 
                case '[': 
                case '{': {
                    this.processOpeningBracket();
                    break;
                }
                case ')': 
                case ']': 
                case '}': {
                    this.processClosingBracket();
                    break;
                }
                case '\"': 
                case '\'': {
                    this.processOpeningQuote();
                    break;
                }
                case '!': 
                case '#': 
                case '%': 
                case '&': 
                case '*': 
                case '+': 
                case '-': 
                case '.': 
                case '/': 
                case ':': 
                case '<': 
                case '=': 
                case '>': 
                case '?': 
                case '@': 
                case '\\': 
                case '^': 
                case '|': 
                case '~': {
                    this.processSpecialCharacter();
                    break;
                }
                default: {
                    this.addCurrentCharacter(TokenType.ANY);
                }
            }
        }

        private void processStringTokenizerState() {
            if (Tokenizer.isQuoteCharacter(this.currentChar) && this.matchClosingQuote()) {
                return;
            }
            this.addCurrentCharacter(TokenType.STRING);
        }

        private void processCurlyBracketStringTokenizerState() {
            if (this.currentChar == '}') {
                this.processCurlyBracketStringEnd();
            } else {
                this.addCurrentCharacter(TokenType.STRING);
            }
        }

        private void processSpecialCharacter() {
            this.finishCurrentToken();
            this.addCurrentCharacter(TokenType.SPECIAL);
        }

        private void processComma() {
            this.finishCurrentToken();
            this.addCurrentCharacter(TokenType.COMMA);
        }

        private void processOpeningBracket() {
            this.finishCurrentToken();
            this.addCurrentCharacter(TokenType.OPENING_BRACKET);
        }

        private void processClosingBracket() {
            this.finishCurrentToken();
            this.addCurrentCharacter(TokenType.CLOSING_BRACKET);
        }

        private void processOpeningQuote() {
            this.finishCurrentToken();
            this.addCurrentCharacter(TokenType.QUOTE);
            this.currentOpeningQuote = this.currentChar;
            this.tokenizerState = TokenizerState.STRING;
        }

        private boolean matchClosingQuote() {
            if (this.currentChar != this.currentOpeningQuote || this.currentString.charAt(this.currentIndex - 1) == '\\') {
                return false;
            }
            this.finishCurrentToken(TokenType.STRING);
            this.tokenizerState = TokenizerState.DEFAULT;
            this.addCurrentCharacter(TokenType.QUOTE);
            this.currentOpeningQuote = '\u0000';
            return true;
        }

        private boolean matchCurlyBracketStringBegin() {
            if (!this.matchRegex(NON_WORD_CHAR_PATTERN, CURLY_BRACKET_STRING_BEGIN_PATTERN, TokenType.ANY)) {
                return false;
            }
            ++this.currentIndex;
            this.currentChar = (char)123;
            this.processOpeningBracket();
            this.tokenizerState = TokenizerState.CURLY_BRACKET_STRING;
            return true;
        }

        private void processCurlyBracketStringEnd() {
            this.tokenizerState = TokenizerState.DEFAULT;
            this.processClosingBracket();
        }

        private boolean matchNumber() {
            return this.matchRegex(NON_WORD_DOT_DASH_CHAR_PATTERN, INTEGER_PATTERN, TokenType.INTEGER) || this.matchRegex(NON_WORD_DOT_DASH_CHAR_PATTERN, FLOAT_PATTERN, TokenType.FLOAT) || this.matchRegex(NON_WORD_DOT_CHAR_PATTERN, HEX_PATTERN, TokenType.HEX);
        }

        private boolean matchBoolean() {
            return this.matchRegex(NON_WORD_CHAR_PATTERN, BOOLEAN_PATTERN, TokenType.BOOLEAN);
        }

        private boolean matchNull() {
            return this.matchRegex(NON_WORD_CHAR_PATTERN, NULL_PATTERN, TokenType.NULL);
        }

        private boolean matchRegex(Pattern leadingCharPattern, Pattern contentPattern, TokenType tokenType) {
            Matcher leadingCharMatcher = this.getMatcherFromPattern(leadingCharPattern);
            Matcher contentMatcher = this.getMatcherFromPattern(contentPattern);
            boolean isValidLeadingChar = true;
            if (this.currentIndex > 0) {
                leadingCharMatcher.region(this.currentIndex - 1, this.currentIndex);
                isValidLeadingChar = leadingCharMatcher.matches();
            }
            contentMatcher.region(this.currentIndex, this.stringLength);
            if (!isValidLeadingChar || !contentMatcher.find()) {
                return false;
            }
            this.finishCurrentToken();
            this.addCharacters(contentMatcher.group(1), tokenType);
            this.finishCurrentToken(tokenType);
            return true;
        }

        private void addCurrentCharacter(TokenType tokenType) {
            this.currentTokenContent.append(this.currentChar);
            if (TokenType.singleCharacterTokenTypes.contains((Object)tokenType)) {
                this.finishCurrentToken(tokenType);
            }
            this.currentTokenType = tokenType;
        }

        private void addCharacters(String characters, TokenType tokenType) {
            this.currentTokenContent.append(characters);
            this.currentTokenType = tokenType;
            this.currentIndex += characters.length() - 1;
        }

        private void finishCurrentToken() {
            this.finishCurrentToken(this.currentTokenType);
        }

        private void finishCurrentToken(TokenType tokenType) {
            if (!this.currentTokenContent.isEmpty()) {
                Token token = new Token(tokenType, this.currentTokenContent.toString());
                this.currentTokenContent.setLength(0);
                this.tokens.add(token);
            }
            this.currentTokenType = TokenType.ANY;
        }

        private static boolean isQuoteCharacter(char ch) {
            return ch == '\"' || ch == '\'';
        }

        private static boolean isCurlyBracketStringBeginCharacter(char ch) {
            return ch == 'k' || ch == 'l' || ch == 'p';
        }

        private static boolean isNumberCharacter(char ch) {
            return ch >= '0' && ch <= '9' || ch >= 'A' && ch <= 'F' || ch >= 'a' && ch <= 'f' || ch == '-';
        }

        private static boolean isBooleanCharacter(char ch) {
            return ch == 'f' || ch == 't';
        }

        private static boolean isNullCharacter(char ch) {
            return ch == 'n';
        }

        private static enum TokenizerState {
            DEFAULT,
            STRING,
            CURLY_BRACKET_STRING;

        }
    }

    private static enum State {
        DEFAULT,
        NEW_LINE,
        EMPTY_BRACKETS;

    }

    private record Token(TokenType tokenType, String content) {
    }

    private static enum TokenType {
        ANY,
        SPECIAL,
        OPENING_BRACKET,
        CLOSING_BRACKET,
        COMMA,
        QUOTE,
        STRING,
        INTEGER,
        FLOAT,
        HEX,
        BOOLEAN,
        NULL;

        private static EnumSet<TokenType> singleCharacterTokenTypes;

        static {
            singleCharacterTokenTypes = EnumSet.of(SPECIAL, OPENING_BRACKET, CLOSING_BRACKET, COMMA, QUOTE);
        }
    }
}

