/*
 * Decompiled with CFR 0.152.
 */
package dev.fixyl.componentviewer;

import dev.fixyl.componentviewer.ComponentViewer;
import dev.fixyl.componentviewer.control.ControlFlow;
import dev.fixyl.componentviewer.control.keyboard.FabricKeyboard;
import dev.fixyl.componentviewer.event.FabricEventDispatcher;
import dev.fixyl.componentviewer.event.KeyboardEvents;
import dev.fixyl.componentviewer.event.MixinEvents;
import net.fabricmc.api.ClientModInitializer;
import net.fabricmc.fabric.api.client.event.lifecycle.v1.ClientTickEvents;
import net.fabricmc.loader.api.FabricLoader;
import net.minecraft.class_310;

public final class FabricComponentViewer
extends ComponentViewer
implements ClientModInitializer {
    public FabricComponentViewer() {
        super(new FabricEventDispatcher(), FabricLoader.getInstance().getConfigDir());
    }

    public void onInitializeClient() {
        class_310 minecraftClient = ComponentViewer.getMinecraftClient();
        this.configs.loadFromDisk();
        ControlFlow controlFlow = new ControlFlow(minecraftClient, this, this.configs);
        FabricKeyboard keyboard = new FabricKeyboard(minecraftClient, this, this.eventDispatcher, this.configs);
        MixinEvents.START_RENDER_EVENT.register(controlFlow::onStartRender);
        MixinEvents.TOOLTIP_EVENT.register(controlFlow::onTooltip);
        MixinEvents.MOUSE_SCROLL_EVENT.register((xOffset, yOffset) -> controlFlow.onMouseScroll(yOffset));
        KeyboardEvents.CYCLE_COMPONENT_EVENT.register(controlFlow::onCycleComponent);
        KeyboardEvents.COPY_ACTION_EVENT.register(controlFlow::onCopyAction);
        ClientTickEvents.END_CLIENT_TICK.register(client -> keyboard.onEndClientTick());
        MixinEvents.KEY_INPUT_EVENT.register(keyboard::onKeyInput);
        MixinEvents.BUTTON_INPUT_EVENT.register(keyboard::onButtonInput);
        MixinEvents.CLEAR_TOAST_MANAGER_EVENT.register(keyboard::clearAllOptionCycleToasts);
    }
}

