/*
 * Decompiled with CFR 0.152.
 */
package dev.fixyl.componentviewer.control;

import dev.fixyl.componentviewer.annotation.NullPermitted;
import dev.fixyl.componentviewer.config.enums.TooltipComponents;
import dev.fixyl.componentviewer.control.HoveredItemStack;
import dev.fixyl.componentviewer.control.component.ItemStackComponents;
import dev.fixyl.componentviewer.formatting.Formatter;
import dev.fixyl.componentviewer.formatting.FormattingException;
import java.util.List;
import java.util.Map;
import net.minecraft.class_124;
import net.minecraft.class_1799;
import net.minecraft.class_2561;
import net.minecraft.class_2583;
import net.minecraft.class_2960;
import net.minecraft.class_5250;
import net.minecraft.class_7923;
import net.minecraft.class_9331;
import net.minecraft.class_9336;

public class Tooltip {
    private static final class_2583 HEADER_STYLE = class_2583.field_24360.method_10977(class_124.field_1080);
    private static final class_2583 COMPONENT_STYLE = class_2583.field_24360.method_10977(class_124.field_1063);
    private static final class_2583 SELECTED_COMPONENT_STYLE = class_2583.field_24360.method_10977(class_124.field_1077);
    private static final class_2583 REMOVED_COMPONENT_STYLE = class_2583.field_24360.method_36140(Boolean.valueOf(true));
    private static final class_2583 NOT_REGISTERED_COMPONENT_STYLE = class_2583.field_24360.method_10978(Boolean.valueOf(true));
    private static final class_2583 ERROR_STYLE = class_2583.field_24360.method_10977(class_124.field_1061);
    private static final String CONTENT_INDENTATION = " ";
    private static final String NOT_REGISTERED_TRANSLATION_KEY = "componentviewer.tooltip.not_registered";
    private static final Map<TooltipComponents, String> COMPONENT_SELECTION_TRANSLATION_KEYS = Map.of(TooltipComponents.ALL, "componentviewer.tooltip.purpose.components.selection.all", TooltipComponents.DEFAULT, "componentviewer.tooltip.purpose.components.selection.default", TooltipComponents.CHANGES, "componentviewer.tooltip.purpose.components.selection.changes");
    private static final Map<TooltipComponents, String> EMPTY_COMPONENT_SELECTION_TRANSLATION_KEYS = Map.of(TooltipComponents.ALL, "componentviewer.tooltip.purpose.components.selection.all.empty", TooltipComponents.DEFAULT, "componentviewer.tooltip.purpose.components.selection.default.empty", TooltipComponents.CHANGES, "componentviewer.tooltip.purpose.components.selection.changes.empty");
    private static final Map<TooltipComponents, String> COMPONENT_SELECTION_WITH_AMOUNT_TRANSLATION_KEYS = Map.of(TooltipComponents.ALL, "componentviewer.tooltip.purpose.components.selection.all.with_amount", TooltipComponents.DEFAULT, "componentviewer.tooltip.purpose.components.selection.default.with_amount", TooltipComponents.CHANGES, "componentviewer.tooltip.purpose.components.selection.changes.with_amount");
    private final List<class_2561> lines;

    public Tooltip(List<class_2561> lines) {
        this.lines = lines;
    }

    public int size() {
        return this.lines.size();
    }

    public boolean isEmpty() {
        return this.lines.isEmpty();
    }

    public Tooltip clear() {
        this.lines.clear();
        return this;
    }

    public Tooltip addSpacer() {
        this.lines.add((class_2561)class_2561.method_43473());
        return this;
    }

    public Tooltip addHeader(String translationKey, Object ... args) {
        this.lines.add((class_2561)class_2561.method_43469((String)translationKey, (Object[])args).method_27696(HEADER_STYLE));
        return this;
    }

    public Tooltip addComponentSelection(HoveredItemStack hoveredItemStack, boolean hideSelectedComponent, boolean showAmount) {
        ItemStackComponents components = hoveredItemStack.getComponents();
        TooltipComponents componentContext = components.getComponentContext();
        if (components.isEmpty()) {
            this.addHeader(EMPTY_COMPONENT_SELECTION_TRANSLATION_KEYS.get((Object)componentContext), new Object[0]);
            return this;
        }
        if (showAmount) {
            this.addHeader(COMPONENT_SELECTION_WITH_AMOUNT_TRANSLATION_KEYS.get((Object)componentContext), components.size());
        } else {
            this.addHeader(COMPONENT_SELECTION_TRANSLATION_KEYS.get((Object)componentContext), new Object[0]);
        }
        String indentationOfSelected = CONTENT_INDENTATION.repeat(Math.min(components.size(), 2));
        List<class_9331<?>> dataComponentTypes = components.getComponentTypes();
        @NullPermitted class_9331<?> selectedDataComponentType = hideSelectedComponent ? null : dataComponentTypes.get(hoveredItemStack.getComponentSelection().orElseThrow().getSelectedIndex());
        for (class_9331<?> dataComponentType : dataComponentTypes) {
            class_5250 componentTypeText;
            class_2960 resourceLocation = class_7923.field_49658.method_10221(dataComponentType);
            class_5250 class_52502 = componentTypeText = resourceLocation == null ? class_2561.method_43471((String)NOT_REGISTERED_TRANSLATION_KEY).method_27696(COMPONENT_STYLE).method_27696(NOT_REGISTERED_COMPONENT_STYLE) : class_2561.method_43470((String)resourceLocation.toString()).method_27696(COMPONENT_STYLE);
            if (dataComponentType == selectedDataComponentType) {
                componentTypeText.method_27696(SELECTED_COMPONENT_STYLE);
            }
            if (components.wasRemoved(dataComponentType)) {
                componentTypeText.method_27696(REMOVED_COMPONENT_STYLE);
            }
            this.lines.add((class_2561)class_2561.method_43470((String)(dataComponentType == selectedDataComponentType ? indentationOfSelected : CONTENT_INDENTATION)).method_10852((class_2561)componentTypeText));
        }
        return this;
    }

    public <T> Tooltip addComponentValue(class_9336<T> component, Formatter formatter, int formattingIndentation, boolean coloredFormatting) {
        this.addHeader("componentviewer.tooltip.purpose.components.value", new Object[0]);
        try {
            this.lines.addAll(formatter.componentToText(component, formattingIndentation, coloredFormatting, CONTENT_INDENTATION));
        }
        catch (FormattingException e) {
            this.addFormattingException();
        }
        return this;
    }

    public Tooltip addItemStack(class_1799 itemStack, Formatter formatter, int formattingIndentation, boolean coloredFormatting) {
        this.addHeader("componentviewer.tooltip.purpose.item_stack", new Object[0]);
        try {
            this.lines.addAll(formatter.itemStackToText(itemStack, formattingIndentation, coloredFormatting, CONTENT_INDENTATION));
        }
        catch (FormattingException e) {
            this.addFormattingException();
        }
        return this;
    }

    private void addFormattingException() {
        this.lines.add((class_2561)class_2561.method_43470((String)CONTENT_INDENTATION).method_10852((class_2561)class_2561.method_43471((String)"componentviewer.tooltip.formatting_exception").method_27696(ERROR_STYLE)));
    }
}

