/*
 * Decompiled with CFR 0.152.
 */
package dev.fixyl.componentviewer.formatting;

import com.mojang.serialization.Codec;
import com.mojang.serialization.DynamicOps;
import dev.fixyl.componentviewer.annotation.NullPermitted;
import dev.fixyl.componentviewer.formatting.CodecBasedFormatter;
import dev.fixyl.componentviewer.formatting.FormattingException;
import dev.fixyl.componentviewer.util.ResultCache;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import net.minecraft.class_124;
import net.minecraft.class_2509;
import net.minecraft.class_2520;
import net.minecraft.class_2561;
import net.minecraft.class_2583;
import net.minecraft.class_310;
import net.minecraft.class_5250;
import net.minecraft.class_5628;
import net.minecraft.class_746;

public class SnbtFormatter
implements CodecBasedFormatter {
    private static final String LF = "\n";
    private static final String NO_CODEC_REPR = "{}";
    private static final class_2583 NO_CODEC_REPR_STYLE = class_2583.field_24360.method_10977(class_124.field_1068);
    private final ResultCache<String> stringResultCache = new ResultCache();
    private final ResultCache<List<class_2561>> textResultCache = new ResultCache();

    @Override
    public <T> String codecToString(T value, @NullPermitted Codec<T> codec, int indentation, String linePrefix) {
        return this.stringResultCache.cache(() -> {
            if (codec == null) {
                return linePrefix + NO_CODEC_REPR;
            }
            Object formattedString = SnbtFormatter.getFormattedText(value, codec, indentation).getString();
            if (!linePrefix.isEmpty()) {
                formattedString = linePrefix + ((String)formattedString).replace(LF, System.lineSeparator() + linePrefix);
            } else if (!System.lineSeparator().equals(LF)) {
                formattedString = ((String)formattedString).replace(LF, System.lineSeparator());
            }
            return formattedString;
        }, value, codec, indentation, linePrefix);
    }

    @Override
    public <T> List<class_2561> codecToText(T value, @NullPermitted Codec<T> codec, int indentation, boolean colored, String linePrefix) {
        return Collections.unmodifiableList(this.textResultCache.cache(() -> {
            if (codec != null) {
                class_2561 text = SnbtFormatter.getFormattedText(value, codec, indentation);
                return SnbtFormatter.convertToTextList(text, colored, linePrefix);
            }
            class_5250 noCodecText = class_2561.method_43470((String)NO_CODEC_REPR).method_27696(colored ? NO_CODEC_REPR_STYLE : NO_COLOR_STYLE);
            if (linePrefix.isEmpty()) {
                return List.of(noCodecText);
            }
            class_5250 startOfLine = class_2561.method_43470((String)linePrefix);
            if (!colored) {
                startOfLine.method_27696(NO_COLOR_STYLE);
            }
            return List.of(startOfLine.method_10852((class_2561)noCodecText));
        }, value, codec, indentation, colored, linePrefix));
    }

    private static <T> class_2561 getFormattedText(T value, Codec<T> codec, int indentation) {
        String prefix = " ".repeat(indentation);
        class_746 player = class_310.method_1551().field_1724;
        class_2509 ops = player == null ? class_2509.field_11560 : player.method_56673().method_57093((DynamicOps)class_2509.field_11560);
        class_2520 nbtTag = (class_2520)codec.encodeStart((DynamicOps)ops, value).getOrThrow(FormattingException::new);
        class_5628 textComponentTagVisitor = new class_5628(prefix);
        return textComponentTagVisitor.method_32305(nbtTag);
    }

    private static List<class_2561> convertToTextList(class_2561 text, boolean colored, String linePrefix) {
        ArrayList<class_2561> textList = new ArrayList<class_2561>();
        class_5250 startOfLine = class_2561.method_43470((String)linePrefix);
        if (!colored) {
            startOfLine.method_27696(NO_COLOR_STYLE);
        }
        class_5250[] textLine = new class_5250[]{startOfLine.method_27661()};
        text.method_27658((style, string) -> {
            String[] stringArray;
            for (String stringSegment : stringArray = string.split("(?=\\n)|(?<=\\n)")) {
                if (!stringSegment.equals(LF)) {
                    textLine[0].method_10852((class_2561)class_2561.method_43470((String)stringSegment).method_27696(colored ? style : NO_COLOR_STYLE));
                    continue;
                }
                textList.add((class_2561)textLine[0]);
                textLine[0] = startOfLine.method_27661();
            }
            return Optional.empty();
        }, class_2583.field_24360);
        textList.add((class_2561)textLine[0]);
        return textList;
    }
}

