/*
 * Decompiled with CFR 0.152.
 */
package dev.fixyl.componentviewer.config.keymapping;

import com.mojang.blaze3d.platform.InputConstants;
import com.mojang.blaze3d.platform.Window;
import net.minecraft.client.KeyMapping;
import net.minecraft.client.Minecraft;
import net.minecraft.client.input.KeyEvent;
import net.minecraft.resources.ResourceLocation;

public class AdvancedKeyMapping
extends KeyMapping {
    public static final KeyMapping.Category GENERAL_CATEGORY = AdvancedKeyMapping.registerCategory("controls");
    public static final KeyMapping.Category CONFIG_CATEGORY = AdvancedKeyMapping.registerCategory("controls.cycle_configs");
    private static final String CATEGORY_NAMESPACE = "componentviewer";
    private final ConflictContext conflictContext;

    public AdvancedKeyMapping(String translationKey, int keyCode, KeyMapping.Category category, ConflictContext conflictContext) {
        super(translationKey, keyCode, category);
        this.conflictContext = conflictContext;
    }

    public AdvancedKeyMapping(String translationKey, int keyCode, KeyMapping.Category category) {
        this(translationKey, keyCode, category, ConflictContext.getDefault());
    }

    public ConflictContext getConfictContext() {
        return this.conflictContext;
    }

    public boolean matchesKeyEvent(KeyEvent keyEvent) {
        return this.key.getValue() == keyEvent.key();
    }

    public boolean isDownAnywhere() {
        Minecraft minecraftClient = Minecraft.getInstance();
        if (minecraftClient == null) {
            return false;
        }
        Window window = minecraftClient.getWindow();
        if (window == null) {
            return false;
        }
        return InputConstants.isKeyDown((Window)window, (int)this.key.getValue());
    }

    private static KeyMapping.Category registerCategory(String id) {
        return KeyMapping.Category.register((ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)CATEGORY_NAMESPACE, (String)id));
    }

    public static enum ConflictContext {
        UNIVERSAL,
        IN_SCREEN,
        IN_GAME;


        public static ConflictContext getDefault() {
            return UNIVERSAL;
        }
    }
}

