/*
 * Decompiled with CFR 0.152.
 */
package dev.fixyl.componentviewer.config.keymapping;

import dev.fixyl.componentviewer.annotation.NullPermitted;
import dev.fixyl.componentviewer.config.keymapping.AdvancedKeyMapping;
import dev.fixyl.componentviewer.config.keymapping.TickedKeyMapping;
import dev.fixyl.componentviewer.config.option.EnumOption;
import dev.fixyl.componentviewer.control.notification.EnumOptionToast;
import net.minecraft.client.KeyMapping;
import net.minecraft.client.gui.components.toasts.Toast;
import net.minecraft.client.input.KeyEvent;

public class EnumOptionKeyMapping<E extends Enum<E>>
extends AdvancedKeyMapping
implements TickedKeyMapping {
    private final EnumOption<E> option;
    @NullPermitted
    private EnumOptionToast<E> optionToast;

    public EnumOptionKeyMapping(String translationKey, int keyCode, KeyMapping.Category category, AdvancedKeyMapping.ConflictContext conflictContext, EnumOption<E> option) {
        super(translationKey, keyCode, category, conflictContext);
        this.option = option;
    }

    public EnumOptionKeyMapping(String translationKey, int keyCode, KeyMapping.Category category, EnumOption<E> option) {
        super(translationKey, keyCode, category);
        this.option = option;
    }

    @Override
    public void onEndClientTick() {
        if (this.optionToast != null && this.optionToast.getWantedVisibility() == Toast.Visibility.HIDE) {
            this.optionToast = null;
        }
    }

    public void clearToast() {
        this.optionToast = null;
    }

    public void cycleEnum() {
        this.option.cycleValue();
        if (this.optionToast == null) {
            this.optionToast = EnumOptionToast.dispatch(this.option, this.getName());
        } else {
            this.optionToast.resetTimer();
        }
    }

    public void cycleEnumIfKeyEventMatches(KeyEvent keyEvent) {
        if (this.matchesKeyEvent(keyEvent)) {
            this.cycleEnum();
        }
    }
}

