/*
 * Decompiled with CFR 0.152.
 */
package dev.fixyl.componentviewer.control.keyboard;

import dev.fixyl.componentviewer.DisablableMod;
import dev.fixyl.componentviewer.config.keymapping.CycleSelectionKeyMapping;
import dev.fixyl.componentviewer.config.keymapping.EnumOptionKeyMapping;
import dev.fixyl.componentviewer.config.keymapping.KeyMappings;
import dev.fixyl.componentviewer.config.keymapping.TickedKeyMapping;
import dev.fixyl.componentviewer.config.option.BooleanOption;
import dev.fixyl.componentviewer.event.EventDispatcher;
import dev.fixyl.componentviewer.screen.ConfigScreen;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.input.KeyEvent;

public abstract class Keyboard {
    protected final Minecraft minecraftClient;
    protected final DisablableMod disablableMod;
    protected final EventDispatcher eventDispatcher;
    protected final List<TickedKeyMapping> tickedKeys;
    protected final List<CycleSelectionKeyMapping> cycleSelectionKeys;
    protected final List<EnumOptionKeyMapping> enumOptionKeys;
    private BooleanOption alternativeCopyModifierKey;
    private BooleanOption allowCyclingOptionsWhileInScreen;

    protected Keyboard(Minecraft minecarftClient, DisablableMod disablableMod, EventDispatcher eventDispatcher, KeyMappings keyMappings, BooleanOption alternativeCopyModifierKey, BooleanOption allowCyclingOptionsWhileInScreen) {
        this.minecraftClient = minecarftClient;
        this.disablableMod = disablableMod;
        this.eventDispatcher = eventDispatcher;
        this.tickedKeys = keyMappings.getSubClassKeyMappings(TickedKeyMapping.class);
        this.cycleSelectionKeys = keyMappings.getSubClassKeyMappings(CycleSelectionKeyMapping.class);
        this.enumOptionKeys = keyMappings.getSubClassKeyMappings(EnumOptionKeyMapping.class);
        this.alternativeCopyModifierKey = alternativeCopyModifierKey;
        this.allowCyclingOptionsWhileInScreen = allowCyclingOptionsWhileInScreen;
    }

    public void onEndClientTick() {
        for (TickedKeyMapping tickedKey : this.tickedKeys) {
            tickedKey.onEndClientTick();
        }
    }

    public void onKeyPress(KeyEvent keyEvent) {
        if (this.disablableMod.isModDisabled()) {
            return;
        }
        for (CycleSelectionKeyMapping cycleKey : this.cycleSelectionKeys) {
            if (!cycleKey.matchesKeyEvent(keyEvent)) continue;
            this.eventDispatcher.invokeCycleComponentEvent(cycleKey.getCycleType());
        }
        if (this.isCopy(keyEvent)) {
            this.eventDispatcher.invokeCopyActionEvent();
        }
        if (this.isCyclingOptionsPossible()) {
            for (EnumOptionKeyMapping enumOptionKey : this.enumOptionKeys) {
                enumOptionKey.cycleEnumIfKeyEventMatches(keyEvent);
            }
        }
    }

    public void clearAllOptionCycleToasts() {
        for (EnumOptionKeyMapping enumOptionKey : this.enumOptionKeys) {
            enumOptionKey.clearToast();
        }
    }

    private boolean isCopy(KeyEvent keyEvent) {
        return keyEvent.input() == 67 && (this.alternativeCopyModifierKey.getBooleanValue() ? keyEvent.hasAltDown() : keyEvent.hasControlDown());
    }

    private boolean isCyclingOptionsPossible() {
        if (this.minecraftClient.level == null || this.minecraftClient.player == null) {
            return false;
        }
        if (this.minecraftClient.screen == null) {
            return true;
        }
        return this.allowCyclingOptionsWhileInScreen.getBooleanValue() && !(this.minecraftClient.screen instanceof ConfigScreen);
    }
}

