/*
 * Decompiled with CFR 0.152.
 */
package dev.fixyl.componentviewer.mixin;

import dev.fixyl.componentviewer.ComponentViewer;
import net.minecraft.client.Minecraft;
import net.minecraft.client.MouseHandler;
import net.minecraft.world.InteractionResult;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={MouseHandler.class}, priority=-2147483648)
public final class MouseHandlerMixin {
    private MouseHandlerMixin() {
    }

    @Inject(method={"onScroll(JDD)V"}, at={@At(value="HEAD")}, cancellable=true)
    private void onScroll(long windowHandle, double xOffset, double yOffset, CallbackInfo callback) {
        Minecraft minecraftClient = Minecraft.getInstance();
        if (windowHandle != minecraftClient.getWindow().handle()) {
            return;
        }
        InteractionResult result = ComponentViewer.dispatchEventWithResultSafely(dispatcher -> dispatcher.invokeMouseScrollEvent(xOffset, yOffset)).orElse((InteractionResult)InteractionResult.PASS);
        if (result == InteractionResult.SUCCESS) {
            minecraftClient.getFramerateLimitTracker().onInputReceived();
            callback.cancel();
        }
    }
}

