/*
 * Decompiled with CFR 0.152.
 */
package dev.fixyl.componentviewer.control.notification;

import dev.fixyl.componentviewer.annotation.NullPermitted;
import dev.fixyl.componentviewer.config.option.EnumOption;
import java.util.Objects;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.toasts.Toast;
import net.minecraft.client.gui.components.toasts.ToastComponent;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.OptionEnum;

public class EnumOptionToast<E extends Enum<E>>
implements Toast {
    private static final ResourceLocation BACKGROUND_SPRITE = ResourceLocation.withDefaultNamespace((String)"toast/advancement");
    private static final long DURATION = 2000L;
    private static final int TEXT_LEFT_MARGIN = 8;
    private static final int TEXT_FIRST_ROW = 7;
    private static final int TEXT_SECOND_ROW = 18;
    private static final int FIRST_ROW_COLOR = ChatFormatting.DARK_AQUA.getColor();
    private static final int SECOND_ROW_COLOR = ChatFormatting.WHITE.getColor();
    private final EnumOption<E> option;
    private final String translationKey;
    private long totalDuration;
    private boolean shouldResetTimer;
    private Toast.Visibility visibility;

    public EnumOptionToast(EnumOption<E> option, @NullPermitted String translationKey) {
        this.option = option;
        this.translationKey = Objects.requireNonNullElse(translationKey, option.getTranslationKey());
        this.totalDuration = 2000L;
        this.shouldResetTimer = false;
        this.visibility = Toast.Visibility.SHOW;
    }

    public void resetTimer() {
        this.shouldResetTimer = true;
    }

    public Toast.Visibility getWantedVisibility() {
        return this.visibility;
    }

    public Toast.Visibility render(GuiGraphics guiGraphics, ToastComponent toastComponent, long timeSinceLastVisible) {
        guiGraphics.blitSprite(BACKGROUND_SPRITE, 0, 0, this.width(), this.height());
        Font font = toastComponent.getMinecraft().font;
        guiGraphics.drawString(font, (Component)Component.translatable((String)this.translationKey), 8, 7, FIRST_ROW_COLOR, false);
        guiGraphics.drawString(font, ((OptionEnum)((Enum)this.option.getValue())).getCaption(), 8, 18, SECOND_ROW_COLOR, false);
        this.updateVisibility(toastComponent, timeSinceLastVisible);
        return this.visibility;
    }

    private void updateVisibility(ToastComponent toastComponent, long timeSinceLastVisible) {
        double actualDuration;
        if (this.shouldResetTimer) {
            this.shouldResetTimer = false;
            this.totalDuration = timeSinceLastVisible + 2000L;
        }
        this.visibility = (double)timeSinceLastVisible < (actualDuration = (double)(this.totalDuration - 2000L) + 2000.0 * toastComponent.getNotificationDisplayTimeMultiplier()) ? Toast.Visibility.SHOW : Toast.Visibility.HIDE;
    }

    public static <E extends Enum<E>> EnumOptionToast<E> dispatch(EnumOption<E> option, @NullPermitted String translationKey) {
        EnumOptionToast<E> toast = new EnumOptionToast<E>(option, translationKey);
        Minecraft.getInstance().getToasts().addToast(toast);
        return toast;
    }

    public static <E extends Enum<E>> EnumOptionToast<E> dispatch(EnumOption<E> option) {
        return EnumOptionToast.dispatch(option, null);
    }
}

