/*
 * Decompiled with CFR 0.152.
 */
package dev.fixyl.componentviewer.mixin;

import com.llamalad7.mixinextras.sugar.Local;
import dev.fixyl.componentviewer.ComponentViewer;
import dev.fixyl.componentviewer.control.Tooltip;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screens.recipebook.RecipeButton;
import net.minecraft.network.chat.Component;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.Redirect;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={RecipeButton.class}, priority=0x7FFFFFFF)
public final class RecipeButtonMixin {
    private RecipeButtonMixin() {
    }

    @Redirect(method={"getTooltipText()Ljava/util/List;"}, at=@At(value="INVOKE", target="Lnet/minecraft/client/gui/screens/Screen;getTooltipFromItem(Lnet/minecraft/client/Minecraft;Lnet/minecraft/world/item/ItemStack;)Ljava/util/List;"))
    private List<Component> getTooltipFromItem(Minecraft minecraftClient, ItemStack stack) {
        return stack.getTooltipLines(Item.TooltipContext.of((Level)minecraftClient.level), (Player)minecraftClient.player, (TooltipFlag)(minecraftClient.options.advancedItemTooltips ? TooltipFlag.ADVANCED : TooltipFlag.NORMAL));
    }

    @Inject(method={"getTooltipText()Ljava/util/List;"}, at={@At(value="RETURN")})
    private void getTooltipText(CallbackInfoReturnable<List<Component>> callback, @Local ItemStack stack) {
        ComponentViewer.dispatchEventSafely(dispatcher -> dispatcher.invokeTooltipEvent(stack, new Tooltip((List)callback.getReturnValue())));
    }
}

