/*
 * Decompiled with CFR 0.152.
 */
package de.arvitus.nospawnerchange.config;

import de.arvitus.nospawnerchange.NoSpawnerChange;
import de.arvitus.nospawnerchange.config.SpawnerConfig;
import java.nio.file.Path;
import org.spongepowered.configurate.CommentedConfigurationNode;
import org.spongepowered.configurate.hocon.HoconConfigurationLoader;
import org.spongepowered.configurate.objectmapping.ConfigSerializable;
import org.spongepowered.configurate.objectmapping.meta.Comment;

@ConfigSerializable
public class Config {
    private static final Path PATH = NoSpawnerChange.CONFIG_DIR.resolve("config.conf");
    private static final HoconConfigurationLoader LOADER = ((HoconConfigurationLoader.Builder)HoconConfigurationLoader.builder().path(PATH)).prettyPrinting(true).build();
    @Comment(value="Configuration for normal monster spawners")
    public SpawnerConfig monsterSpawner = new SpawnerConfig();
    @Comment(value="Configuration for trial spawners")
    public SpawnerConfig trialSpawner = new SpawnerConfig();

    public static Config loadOrCreate() {
        if (!PATH.toFile().isFile()) {
            CommentedConfigurationNode node = (CommentedConfigurationNode)LOADER.createNode();
            try {
                node.set(new Config());
                LOADER.save(node);
            }
            catch (Exception e) {
                NoSpawnerChange.LOGGER.warn("Failed to save default config to disk", (Throwable)e);
            }
        } else {
            try {
                return ((CommentedConfigurationNode)LOADER.load()).get(Config.class);
            }
            catch (Exception e) {
                if (NoSpawnerChange.CONFIG != null) {
                    NoSpawnerChange.LOGGER.warn("Failed to load config, using previous value instead", (Throwable)e);
                    return NoSpawnerChange.CONFIG;
                }
                NoSpawnerChange.LOGGER.warn("Failed to load config, using default config instead", (Throwable)e);
            }
        }
        return new Config();
    }
}

