/*
 * Decompiled with CFR 0.152.
 */
package org.ayosynk.landClaimPlugin;

import java.util.ArrayList;
import java.util.List;
import org.ayosynk.landClaimPlugin.commands.ClaimTabCompleter;
import org.ayosynk.landClaimPlugin.commands.CommandHandler;
import org.ayosynk.landClaimPlugin.gui.GUIListener;
import org.ayosynk.landClaimPlugin.listeners.CommandBlocker;
import org.ayosynk.landClaimPlugin.listeners.EventListener;
import org.ayosynk.landClaimPlugin.listeners.PlayerJoinListener;
import org.ayosynk.landClaimPlugin.managers.ClaimManager;
import org.ayosynk.landClaimPlugin.managers.ConfigManager;
import org.ayosynk.landClaimPlugin.managers.TrustManager;
import org.ayosynk.landClaimPlugin.managers.VisualizationManager;
import org.ayosynk.landClaimPlugin.utils.ConfigUpdater;
import org.bukkit.Bukkit;
import org.bukkit.command.TabCompleter;
import org.bukkit.event.Listener;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;

public class LandClaimPlugin
extends JavaPlugin {
    private ConfigManager configManager;
    private ClaimManager claimManager;
    private TrustManager trustManager;
    private VisualizationManager visualizationManager;
    private CommandHandler commandHandler;
    private List<String> blockedCommands = new ArrayList<String>();
    private List<String> blockedWorlds = new ArrayList<String>();
    private int autoSaveTaskId = -1;
    private boolean worldGuardEnabled = false;

    public void onEnable() {
        try {
            if (Bukkit.getPluginManager().isPluginEnabled("WorldGuard")) {
                this.worldGuardEnabled = true;
                this.getLogger().info("WorldGuard detected. Enabling region gap protection.");
            }
            this.configManager = new ConfigManager(this);
            this.claimManager = new ClaimManager(this, this.configManager);
            this.trustManager = new TrustManager(this, this.claimManager, this.configManager);
            this.claimManager.initialize();
            this.trustManager.initialize();
            this.visualizationManager = new VisualizationManager(this, this.claimManager, this.configManager);
            this.commandHandler = new CommandHandler(this, this.claimManager, this.trustManager, this.configManager, this.visualizationManager);
            this.getServer().getPluginManager().registerEvents((Listener)new EventListener(this, this.claimManager, this.trustManager, this.configManager), (Plugin)this);
            this.getServer().getPluginManager().registerEvents((Listener)new CommandBlocker(this, this.claimManager, this.trustManager), (Plugin)this);
            this.getServer().getPluginManager().registerEvents((Listener)new PlayerJoinListener(this.visualizationManager), (Plugin)this);
            this.getServer().getPluginManager().registerEvents((Listener)new GUIListener(this.trustManager), (Plugin)this);
            if (this.getCommand("claim") != null) {
                this.getCommand("claim").setTabCompleter((TabCompleter)new ClaimTabCompleter());
            }
            if (this.getCommand("unclaim") != null) {
                this.getCommand("unclaim").setTabCompleter((TabCompleter)new ClaimTabCompleter());
            }
            if (this.getCommand("unclaimall") != null) {
                this.getCommand("unclaimall").setTabCompleter((TabCompleter)new ClaimTabCompleter());
            }
            this.reloadConfiguration();
            this.scheduleAutoSave();
            this.getLogger().info("LandClaim has been enabled! Loaded " + this.claimManager.getTotalClaims() + " claims and " + this.trustManager.getTotalTrusts() + " trust relationships");
        }
        catch (Exception e) {
            this.getLogger().severe("Failed to enable LandClaim: " + e.getMessage());
            e.printStackTrace();
            this.getServer().getPluginManager().disablePlugin((Plugin)this);
        }
    }

    private void scheduleAutoSave() {
        this.autoSaveTaskId = Bukkit.getScheduler().scheduleSyncRepeatingTask((Plugin)this, () -> {
            if (this.configManager.logAutoSaveMessage()) {
                this.getLogger().info("Auto-saving claims and trust data...");
            }
            this.claimManager.saveClaims();
            this.trustManager.saveTrustedPlayers();
            this.trustManager.savePermissionsAndMembers();
        }, 6000L, 6000L);
    }

    public boolean isWorldGuardEnabled() {
        return this.worldGuardEnabled;
    }

    public void reloadConfiguration() {
        ConfigUpdater.updateConfig(this);
        this.configManager.reloadMainConfig();
        this.blockedCommands = this.configManager.getBlockedCommands();
        this.blockedWorlds = this.configManager.getConfig().getStringList("block-world");
        this.blockedCommands = this.blockedCommands.stream().map(String::toLowerCase).toList();
        this.blockedWorlds = this.blockedWorlds.stream().map(String::toLowerCase).toList();
        this.claimManager.loadClaims();
        this.trustManager.loadTrustedPlayers();
        this.trustManager.loadPermissions();
        this.trustManager.loadMembers();
    }

    public void onDisable() {
        try {
            if (this.autoSaveTaskId != -1) {
                Bukkit.getScheduler().cancelTask(this.autoSaveTaskId);
            }
            if (this.claimManager != null) {
                this.claimManager.saveClaims();
                this.getLogger().info("Saved " + this.claimManager.getTotalClaims() + " claims");
            }
            if (this.trustManager != null) {
                this.trustManager.saveTrustedPlayers();
                this.trustManager.savePermissionsAndMembers();
                this.getLogger().info("Saved trust data for " + this.trustManager.getTotalTrusts() + " relationships");
            }
            this.getLogger().info("LandClaim has been disabled!");
        }
        catch (Exception e) {
            this.getLogger().severe("Error while disabling LandClaim: " + e.getMessage());
        }
    }

    public ConfigManager getConfigManager() {
        return this.configManager;
    }

    public ClaimManager getClaimManager() {
        return this.claimManager;
    }

    public TrustManager getTrustManager() {
        return this.trustManager;
    }

    public VisualizationManager getVisualizationManager() {
        return this.visualizationManager;
    }

    public CommandHandler getCommandHandler() {
        return this.commandHandler;
    }

    public List<String> getBlockedCommands() {
        return this.blockedCommands;
    }

    public List<String> getBlockedWorlds() {
        return this.blockedWorlds;
    }
}

