/*
 * Decompiled with CFR 0.152.
 */
package org.ayosynk.landClaimPlugin.gui;

import org.ayosynk.landClaimPlugin.LandClaimPlugin;
import org.ayosynk.landClaimPlugin.gui.TrustListGUI;
import org.ayosynk.landClaimPlugin.gui.TrustMenuGUI;
import org.ayosynk.landClaimPlugin.gui.VisitorMenuGUI;
import org.ayosynk.landClaimPlugin.managers.TrustManager;
import org.ayosynk.landClaimPlugin.utils.ChatUtils;
import org.bukkit.ChatColor;
import org.bukkit.Material;
import org.bukkit.OfflinePlayer;
import org.bukkit.entity.HumanEntity;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.SkullMeta;

public class GUIListener
implements Listener {
    private final TrustManager trustManager;
    private final LandClaimPlugin plugin;

    public GUIListener(TrustManager trustManager) {
        this.trustManager = trustManager;
        this.plugin = trustManager.getPlugin();
    }

    @EventHandler
    public void onInventoryClick(InventoryClickEvent event) {
        String trustListTitle;
        HumanEntity humanEntity = event.getWhoClicked();
        if (!(humanEntity instanceof Player)) {
            return;
        }
        Player player = (Player)humanEntity;
        if (event.getClickedInventory() != event.getView().getTopInventory()) {
            return;
        }
        String title = event.getView().getTitle();
        if (title.equals(trustListTitle = ChatUtils.colorize(this.trustManager.getConfigManager().getMessage("trust-list-title", new String[0])))) {
            OfflinePlayer trustedPlayer;
            SkullMeta meta;
            event.setCancelled(true);
            ItemStack item = event.getCurrentItem();
            if (item == null || item.getType() == Material.AIR) {
                return;
            }
            if (event.getSlot() == event.getInventory().getSize() - 1) {
                player.closeInventory();
                return;
            }
            if (item.getType() == Material.PLAYER_HEAD && (meta = (SkullMeta)item.getItemMeta()) != null && (trustedPlayer = meta.getOwningPlayer()) != null) {
                TrustMenuGUI.open(player, trustedPlayer, this.trustManager);
            }
            return;
        }
        String visitorMenuTitle = ChatUtils.colorize(this.trustManager.getConfigManager().getMessage("visitor-menu-title", new String[0]));
        if (title.equals(visitorMenuTitle)) {
            event.setCancelled(true);
            ItemStack item = event.getCurrentItem();
            if (item == null || item.getType() == Material.AIR) {
                return;
            }
            if (event.getSlot() == 8) {
                player.closeInventory();
                return;
            }
            if (event.getSlot() < 4) {
                String permission = VisitorMenuGUI.PERMISSIONS[event.getSlot()];
                boolean current = this.trustManager.hasVisitorPermission(player.getUniqueId(), permission);
                this.trustManager.setVisitorPermission(player.getUniqueId(), permission, !current);
                this.trustManager.savePermissionsAndMembers();
                VisitorMenuGUI.open(player, this.trustManager);
            }
            return;
        }
        String trustMenuTitleTemplate = this.trustManager.getConfigManager().getMessage("trust-menu-title", "{player}", "");
        String trustPrefix = ChatUtils.colorize(trustMenuTitleTemplate);
        if (title.startsWith(trustPrefix)) {
            event.setCancelled(true);
            ItemStack item = event.getCurrentItem();
            if (item == null || item.getType() == Material.AIR) {
                return;
            }
            String trustedName = ChatColor.stripColor((String)title.substring(trustPrefix.length()).trim());
            if (trustedName.isEmpty()) {
                return;
            }
            Player trustedPlayer = null;
            Player onlinePlayer = this.plugin.getServer().getPlayerExact(trustedName);
            if (onlinePlayer != null) {
                trustedPlayer = onlinePlayer;
            } else {
                for (OfflinePlayer offline : this.plugin.getServer().getOfflinePlayers()) {
                    if (offline.getName() == null || !offline.getName().equals(trustedName)) continue;
                    trustedPlayer = offline;
                    break;
                }
            }
            if (trustedPlayer == null) {
                return;
            }
            if (event.getSlot() == 8) {
                TrustListGUI.open(player, this.trustManager);
                return;
            }
            if (event.getSlot() < 4) {
                String permission = TrustMenuGUI.PERMISSIONS[event.getSlot()];
                boolean current = this.trustManager.hasTrustPermission(player.getUniqueId(), trustedPlayer.getUniqueId(), permission);
                this.trustManager.setTrustPermission(player.getUniqueId(), trustedPlayer.getUniqueId(), permission, !current);
                this.trustManager.savePermissionsAndMembers();
                TrustMenuGUI.open(player, (OfflinePlayer)trustedPlayer, this.trustManager);
            }
        }
    }
}

