/*
 * Decompiled with CFR 0.152.
 */
package org.ayosynk.landClaimPlugin.managers;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import org.ayosynk.landClaimPlugin.LandClaimPlugin;
import org.ayosynk.landClaimPlugin.managers.ClaimManager;
import org.ayosynk.landClaimPlugin.managers.ConfigManager;
import org.ayosynk.landClaimPlugin.models.ChunkPosition;
import org.ayosynk.landClaimPlugin.models.Edge;
import org.bukkit.Bukkit;
import org.bukkit.Color;
import org.bukkit.Particle;
import org.bukkit.World;
import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitRunnable;
import org.bukkit.util.Vector;

public class VisualizationManager {
    private final LandClaimPlugin plugin;
    private final ClaimManager claimManager;
    private final ConfigManager configManager;
    private final Map<UUID, Map<String, Set<Edge>>> mergedEdgesCache = new HashMap<UUID, Map<String, Set<Edge>>>();
    private final Map<UUID, VisualizationMode> visualizationModes = new HashMap<UUID, VisualizationMode>();

    public VisualizationManager(LandClaimPlugin plugin, ClaimManager claimManager, ConfigManager configManager) {
        this.plugin = plugin;
        this.claimManager = claimManager;
        this.configManager = configManager;
        this.startVisualizationTask();
    }

    private void startVisualizationTask() {
        new BukkitRunnable(){

            public void run() {
                for (Map.Entry<UUID, VisualizationMode> entry : VisualizationManager.this.visualizationModes.entrySet()) {
                    Player player = Bukkit.getPlayer((UUID)entry.getKey());
                    if (player == null || !player.isOnline()) continue;
                    VisualizationManager.this.showPlayerClaims(player, entry.getValue());
                }
            }
        }.runTaskTimer((Plugin)this.plugin, 0L, (long)this.configManager.getVisualizationUpdateInterval());
    }

    public void showPlayerClaims(Player player, VisualizationMode mode) {
        UUID playerId = player.getUniqueId();
        Set<ChunkPosition> claims = this.claimManager.getPlayerClaims(playerId);
        World world = player.getWorld();
        String worldName = world.getName();
        Set<Edge> edges = this.getMergedEdges(playerId, worldName, claims);
        Color color = mode == VisualizationMode.ALWAYS ? this.configManager.getVisualizationColor("always-color") : this.configManager.getVisualizationColor("temporary-color");
        this.showEdges(player, edges, color);
    }

    public void showTemporary(Player player) {
        UUID playerId = player.getUniqueId();
        Set<ChunkPosition> claims = this.claimManager.getPlayerClaims(playerId);
        World world = player.getWorld();
        String worldName = world.getName();
        Set<Edge> edges = this.getMergedEdges(playerId, worldName, claims);
        Color color = this.configManager.getVisualizationColor("temporary-color");
        this.showEdges(player, edges, color);
    }

    private Set<Edge> getMergedEdges(UUID playerId, String worldName, Set<ChunkPosition> claims) {
        Map<String, Set<Edge>> worldCache;
        if (this.mergedEdgesCache.containsKey(playerId) && (worldCache = this.mergedEdgesCache.get(playerId)).containsKey(worldName)) {
            return worldCache.get(worldName);
        }
        HashMap<Edge, Integer> edgeCounts = new HashMap<Edge, Integer>();
        for (ChunkPosition claim : claims) {
            if (!claim.getWorld().equals(worldName)) continue;
            int minX = claim.getX() << 4;
            int minZ = claim.getZ() << 4;
            int maxX = minX + 16;
            int maxZ = minZ + 16;
            Edge north = new Edge(minX, minZ, maxX, minZ);
            Edge south = new Edge(minX, maxZ, maxX, maxZ);
            Edge west = new Edge(minX, minZ, minX, maxZ);
            Edge east = new Edge(maxX, minZ, maxX, maxZ);
            edgeCounts.put(north, edgeCounts.getOrDefault(north, 0) + 1);
            edgeCounts.put(south, edgeCounts.getOrDefault(south, 0) + 1);
            edgeCounts.put(west, edgeCounts.getOrDefault(west, 0) + 1);
            edgeCounts.put(east, edgeCounts.getOrDefault(east, 0) + 1);
        }
        HashSet<Edge> uniqueEdges = new HashSet<Edge>();
        for (Map.Entry entry : edgeCounts.entrySet()) {
            if ((Integer)entry.getValue() != 1) continue;
            uniqueEdges.add((Edge)entry.getKey());
        }
        this.cacheEdges(playerId, worldName, uniqueEdges);
        return uniqueEdges;
    }

    private void cacheEdges(UUID playerId, String worldName, Set<Edge> edges) {
        this.mergedEdgesCache.computeIfAbsent(playerId, k -> new HashMap()).put(worldName, edges);
    }

    public void invalidateCache(UUID playerId) {
        this.mergedEdgesCache.remove(playerId);
    }

    private void showEdges(Player player, Set<Edge> edges, Color color) {
        double spacing = this.configManager.getParticleSpacing();
        Particle.DustOptions dustOptions = new Particle.DustOptions(color, 1.0f);
        double y = player.getLocation().getY() + 1.0;
        for (Edge edge : edges) {
            this.drawEdge(player, edge, y, spacing, dustOptions);
        }
    }

    private void drawEdge(Player player, Edge edge, double y, double spacing, Particle.DustOptions dustOptions) {
        World world = player.getWorld();
        Vector start = new Vector((double)edge.x1, y, (double)edge.z1);
        Vector end = new Vector((double)edge.x2, y, (double)edge.z2);
        Vector direction = end.clone().subtract(start);
        double length = direction.length();
        direction.normalize().multiply(spacing);
        int particles = (int)(length / spacing);
        for (int i = 0; i < particles; ++i) {
            Vector point = start.clone().add(direction.clone().multiply(i));
            player.spawnParticle(Particle.DUST, point.getX(), point.getY(), point.getZ(), 1, 0.0, 0.0, 0.0, 0.0, (Object)dustOptions);
        }
    }

    public void setVisualizationMode(UUID playerId, VisualizationMode mode) {
        if (mode == null) {
            this.visualizationModes.remove(playerId);
        } else {
            this.visualizationModes.put(playerId, mode);
        }
    }

    public VisualizationMode getVisualizationMode(UUID playerId) {
        return this.visualizationModes.get(playerId);
    }

    public void handlePlayerJoin(Player player) {
        String defaultMode;
        if (!this.visualizationModes.containsKey(player.getUniqueId()) && "ALWAYS".equalsIgnoreCase(defaultMode = this.configManager.getDefaultVisualizationMode())) {
            this.visualizationModes.put(player.getUniqueId(), VisualizationMode.ALWAYS);
        }
    }

    public static enum VisualizationMode {
        ALWAYS;

    }
}

