/*
 * Decompiled with CFR 0.152.
 */
package org.ayosynk.landClaimPlugin.models;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.bukkit.Chunk;
import org.bukkit.Location;
import org.bukkit.block.Block;

public class ChunkPosition {
    private final String world;
    private final int x;
    private final int z;

    public ChunkPosition(Chunk chunk) {
        this.world = chunk.getWorld().getName();
        this.x = chunk.getX();
        this.z = chunk.getZ();
    }

    public ChunkPosition(String world, int x, int z) {
        this.world = world;
        this.x = x;
        this.z = z;
    }

    public ChunkPosition(Block block) {
        this(block.getChunk());
    }

    public ChunkPosition(Location location) {
        this(location.getChunk());
    }

    public String getWorld() {
        return this.world;
    }

    public int getX() {
        return this.x;
    }

    public int getZ() {
        return this.z;
    }

    public List<ChunkPosition> getNeighbors(boolean includeDiagonals) {
        ArrayList<ChunkPosition> neighbors = new ArrayList<ChunkPosition>();
        neighbors.add(new ChunkPosition(this.world, this.x + 1, this.z));
        neighbors.add(new ChunkPosition(this.world, this.x - 1, this.z));
        neighbors.add(new ChunkPosition(this.world, this.x, this.z + 1));
        neighbors.add(new ChunkPosition(this.world, this.x, this.z - 1));
        if (includeDiagonals) {
            neighbors.add(new ChunkPosition(this.world, this.x + 1, this.z + 1));
            neighbors.add(new ChunkPosition(this.world, this.x + 1, this.z - 1));
            neighbors.add(new ChunkPosition(this.world, this.x - 1, this.z + 1));
            neighbors.add(new ChunkPosition(this.world, this.x - 1, this.z - 1));
        }
        return neighbors;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ChunkPosition that = (ChunkPosition)o;
        return this.x == that.x && this.z == that.z && Objects.equals(this.world, that.world);
    }

    public int hashCode() {
        return Objects.hash(this.world, this.x, this.z);
    }

    public String toString() {
        return this.world + "," + this.x + "," + this.z;
    }
}

