/*
 * Decompiled with CFR 0.152.
 */
package org.ayosynk.landClaimPlugin.models;

import java.util.Objects;

public class Edge {
    public final int x1;
    public final int z1;
    public final int x2;
    public final int z2;

    public Edge(int x1, int z1, int x2, int z2) {
        if (x1 == x2) {
            this.x1 = x1;
            this.x2 = x2;
            this.z1 = Math.min(z1, z2);
            this.z2 = Math.max(z1, z2);
        } else if (z1 == z2) {
            this.z1 = z1;
            this.z2 = z2;
            this.x1 = Math.min(x1, x2);
            this.x2 = Math.max(x1, x2);
        } else {
            this.x1 = x1;
            this.z1 = z1;
            this.x2 = x2;
            this.z2 = z2;
        }
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Edge edge = (Edge)o;
        return this.x1 == edge.x1 && this.z1 == edge.z1 && this.x2 == edge.x2 && this.z2 == edge.z2;
    }

    public int hashCode() {
        return Objects.hash(this.x1, this.z1, this.x2, this.z2);
    }

    public boolean isVertical() {
        return this.x1 == this.x2;
    }

    public boolean isHorizontal() {
        return this.z1 == this.z2;
    }
}

