/*
 * Decompiled with CFR 0.152.
 */
package org.ayosynk.landClaimPlugin.commands;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import net.md_5.bungee.api.ChatMessageType;
import net.md_5.bungee.api.chat.TextComponent;
import org.ayosynk.landClaimPlugin.LandClaimPlugin;
import org.ayosynk.landClaimPlugin.gui.TrustListGUI;
import org.ayosynk.landClaimPlugin.gui.VisitorMenuGUI;
import org.ayosynk.landClaimPlugin.managers.ClaimManager;
import org.ayosynk.landClaimPlugin.managers.ConfigManager;
import org.ayosynk.landClaimPlugin.managers.TrustManager;
import org.ayosynk.landClaimPlugin.managers.VisualizationManager;
import org.ayosynk.landClaimPlugin.models.ChunkPosition;
import org.bukkit.Bukkit;
import org.bukkit.Chunk;
import org.bukkit.Location;
import org.bukkit.OfflinePlayer;
import org.bukkit.World;
import org.bukkit.command.Command;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;

public class CommandHandler
implements CommandExecutor {
    private final LandClaimPlugin plugin;
    private final ClaimManager claimManager;
    private final TrustManager trustManager;
    private final ConfigManager configManager;
    private final VisualizationManager visualizationManager;
    private final Map<UUID, Boolean> autoClaimPlayers = new HashMap<UUID, Boolean>();
    private final Map<UUID, Boolean> autoUnclaimPlayers = new HashMap<UUID, Boolean>();
    private final Map<UUID, Long> unstuckCooldowns = new HashMap<UUID, Long>();

    public CommandHandler(LandClaimPlugin plugin, ClaimManager claimManager, TrustManager trustManager, ConfigManager configManager, VisualizationManager visualizationManager) {
        this.plugin = plugin;
        this.claimManager = claimManager;
        this.trustManager = trustManager;
        this.configManager = configManager;
        this.visualizationManager = visualizationManager;
        if (plugin.getCommand("claim") != null) {
            plugin.getCommand("claim").setExecutor((CommandExecutor)this);
        }
        if (plugin.getCommand("unclaim") != null) {
            plugin.getCommand("unclaim").setExecutor((CommandExecutor)this);
        }
        if (plugin.getCommand("unclaimall") != null) {
            plugin.getCommand("unclaimall").setExecutor((CommandExecutor)this);
        }
    }

    public boolean onCommand(CommandSender sender, Command command, String label, String[] args) {
        if (!(sender instanceof Player)) {
            sender.sendMessage("Only players can use this command.");
            return true;
        }
        Player player = (Player)sender;
        String cmd = command.getName().toLowerCase();
        if (cmd.equals("claim")) {
            this.handleClaimCommand(player, args);
        } else if (cmd.equals("unclaim") || cmd.equals("unclaimall")) {
            this.handleUnclaimCommand(player, args, cmd);
        }
        return true;
    }

    private void handleClaimCommand(Player player, String[] args) {
        if (args.length == 0) {
            this.claimCurrentChunk(player);
        } else {
            switch (args[0].toLowerCase()) {
                case "auto": {
                    this.toggleAutoClaim(player);
                    break;
                }
                case "trust": {
                    this.handleTrustCommand(player, args);
                    break;
                }
                case "untrust": {
                    if (args.length < 2) {
                        this.sendMessage(player, "untrust-usage", new String[0]);
                        break;
                    }
                    this.untrustPlayer(player, args[1]);
                    break;
                }
                case "unstuck": {
                    this.handleUnstuckCommand(player);
                    break;
                }
                case "visible": {
                    this.handleVisibleCommand(player, args);
                    break;
                }
                case "help": {
                    this.showHelp(player);
                    break;
                }
                case "reload": {
                    this.reloadConfig(player);
                    break;
                }
                case "admin": {
                    this.handleAdminCommand(player, args);
                    break;
                }
                case "trustlist": {
                    this.showTrustList(player);
                    break;
                }
                case "info": {
                    this.showClaimInfo(player);
                    break;
                }
                case "visitor": {
                    this.handleVisitorCommand(player, args);
                    break;
                }
                case "member": {
                    this.handleMemberCommand(player, args);
                    break;
                }
                default: {
                    this.sendMessage(player, "invalid-command", new String[0]);
                }
            }
        }
    }

    private void handleTrustCommand(Player player, String[] args) {
        if (args.length < 2) {
            this.sendMessage(player, "trust-usage", new String[0]);
            return;
        }
        if (args[1].equalsIgnoreCase("menu")) {
            this.openTrustMenu(player);
        } else {
            this.trustPlayer(player, args[1]);
        }
    }

    private void handleVisitorCommand(Player player, String[] args) {
        if (args.length > 1 && args[1].equalsIgnoreCase("menu")) {
            this.openVisitorMenu(player);
        } else {
            this.sendMessage(player, "invalid-command", new String[0]);
        }
    }

    private void handleVisibleCommand(Player player, String[] args) {
        if (args.length > 1) {
            if (args[1].equalsIgnoreCase("always")) {
                this.visualizationManager.setVisualizationMode(player.getUniqueId(), VisualizationManager.VisualizationMode.ALWAYS);
                this.sendMessage(player, "visible-enabled-always", new String[0]);
            } else if (args[1].equalsIgnoreCase("off")) {
                this.visualizationManager.setVisualizationMode(player.getUniqueId(), null);
                this.sendMessage(player, "visible-disabled", new String[0]);
            } else {
                this.sendMessage(player, "invalid-command", new String[0]);
            }
        } else {
            this.visualizationManager.showTemporary(player);
            this.sendMessage(player, "visible-enabled-temporary", new String[0]);
        }
    }

    private void handleUnstuckCommand(Player player) {
        Location location;
        ChunkPosition pos;
        UUID playerId = player.getUniqueId();
        int cooldown = this.configManager.getUnstuckCooldown();
        if (this.unstuckCooldowns.containsKey(playerId)) {
            long lastUsed = this.unstuckCooldowns.get(playerId);
            long secondsLeft = (long)cooldown - (System.currentTimeMillis() - lastUsed) / 1000L;
            if (secondsLeft > 0L) {
                this.sendMessage(player, "unstuck-cooldown", "{seconds}", String.valueOf(secondsLeft));
                return;
            }
        }
        if (!this.claimManager.isChunkClaimed(pos = new ChunkPosition(location = player.getLocation()))) {
            this.sendMessage(player, "cannot-unstuck-here", new String[0]);
            return;
        }
        UUID owner = this.claimManager.getChunkOwner(pos);
        if (player.getUniqueId().equals(owner)) {
            this.sendMessage(player, "cannot-unstuck-here", new String[0]);
            return;
        }
        if (this.trustManager.isTrusted(owner, player)) {
            this.sendMessage(player, "cannot-unstuck-here", new String[0]);
            return;
        }
        Location safeLocation = this.findNearestUnclaimed(location);
        if (safeLocation == null) {
            safeLocation = player.getWorld().getSpawnLocation();
        }
        this.unstuckCooldowns.put(playerId, System.currentTimeMillis());
        player.teleport(safeLocation);
        this.sendMessage(player, "unstuck-success", new String[0]);
    }

    private Location findNearestUnclaimed(Location origin) {
        World world = origin.getWorld();
        int startX = origin.getBlockX() >> 4;
        int startZ = origin.getBlockZ() >> 4;
        for (int radius = 1; radius <= 50; ++radius) {
            for (int x = -radius; x <= radius; ++x) {
                for (int z = -radius; z <= radius; ++z) {
                    if (Math.abs(x) != radius && Math.abs(z) != radius) continue;
                    int chunkX = startX + x;
                    int chunkZ = startZ + z;
                    ChunkPosition pos = new ChunkPosition(world.getName(), chunkX, chunkZ);
                    if (this.claimManager.isChunkClaimed(pos)) continue;
                    return this.findSafeLocation(world, chunkX, chunkZ);
                }
            }
        }
        return null;
    }

    private Location findSafeLocation(World world, int chunkX, int chunkZ) {
        int centerX = (chunkX << 4) + 8;
        int centerZ = (chunkZ << 4) + 8;
        int y = world.getHighestBlockYAt(centerX, centerZ);
        Location location = new Location(world, (double)centerX, (double)(y + 1), (double)centerZ);
        if (location.getBlock().isLiquid()) {
            for (int x = -2; x <= 2; ++x) {
                for (int z = -2; z <= 2; ++z) {
                    Location testLoc = location.clone().add((double)x, 0.0, (double)z);
                    int testY = world.getHighestBlockYAt(testLoc);
                    testLoc.setY((double)(testY + 1));
                    if (testLoc.getBlock().isLiquid()) continue;
                    return testLoc;
                }
            }
        }
        return location;
    }

    private void handleAdminCommand(Player player, String[] args) {
        if (!player.hasPermission("landclaim.admin")) {
            this.sendMessage(player, "access-denied", new String[0]);
            return;
        }
        if (args.length < 2) {
            this.sendMessage(player, "invalid-command", new String[0]);
            return;
        }
        switch (args[1].toLowerCase()) {
            case "unclaim": {
                this.adminUnclaim(player);
                break;
            }
            case "unclaimall": {
                if (args.length < 3) {
                    this.sendMessage(player, "invalid-command", new String[0]);
                    return;
                }
                this.adminUnclaimAll(player, args[2]);
                break;
            }
            default: {
                this.sendMessage(player, "invalid-command", new String[0]);
            }
        }
    }

    private void adminUnclaim(Player admin) {
        Chunk chunk = admin.getLocation().getChunk();
        ChunkPosition pos = new ChunkPosition(chunk);
        if (!this.claimManager.isChunkClaimed(pos)) {
            this.sendMessage(admin, "not-owner", new String[0]);
            return;
        }
        UUID ownerId = this.claimManager.getChunkOwner(pos);
        String ownerName = Bukkit.getOfflinePlayer((UUID)ownerId).getName();
        if (ownerName == null) {
            ownerName = "Unknown";
        }
        if (this.claimManager.unclaimChunk(chunk)) {
            this.sendMessage(admin, "admin-unclaimed", "{owner}", ownerName);
            this.visualizationManager.invalidateCache(ownerId);
        }
    }

    private void adminUnclaimAll(Player admin, String targetName) {
        OfflinePlayer target = Bukkit.getOfflinePlayer((String)targetName);
        if (target == null || !target.hasPlayedBefore()) {
            this.sendMessage(admin, "player-not-found", new String[0]);
            return;
        }
        UUID targetId = target.getUniqueId();
        int count = this.claimManager.unclaimAll(targetId);
        if (count > 0) {
            this.sendMessage(admin, "admin-unclaimed-all", "{player}", targetName, "{count}", String.valueOf(count));
            this.visualizationManager.invalidateCache(targetId);
        } else {
            this.sendMessage(admin, "&cThat player has no claims.", new String[0]);
        }
    }

    public void showTrustList(Player player) {
        UUID playerId = player.getUniqueId();
        Set<UUID> trusted = this.trustManager.getTrustedPlayers(playerId);
        if (trusted.isEmpty()) {
            this.sendMessage(player, "no-trusted-players", new String[0]);
            return;
        }
        this.sendMessage(player, "trust-list-header", new String[0]);
        for (UUID id : trusted) {
            String name = Bukkit.getOfflinePlayer((UUID)id).getName();
            if (name == null) continue;
            player.spigot().sendMessage(ChatMessageType.CHAT, TextComponent.fromLegacyText((String)this.configManager.getMessage("trust-list-item", "{player}", name)));
        }
        this.sendMessage(player, "click-to-manage", new String[0]);
    }

    private void openTrustMenu(Player player) {
        TrustListGUI.open(player, this.trustManager);
    }

    private void openVisitorMenu(Player player) {
        VisitorMenuGUI.open(player, this.trustManager);
    }

    private void showClaimInfo(Player player) {
        Set<UUID> members;
        ChunkPosition pos = new ChunkPosition(player.getLocation());
        if (!this.claimManager.isChunkClaimed(pos)) {
            this.sendMessage(player, "claim-info-not-claimed", new String[0]);
            return;
        }
        UUID ownerId = this.claimManager.getChunkOwner(pos);
        String ownerName = Bukkit.getOfflinePlayer((UUID)ownerId).getName();
        if (ownerName == null) {
            ownerName = "Unknown";
        }
        this.sendMessage(player, "claim-info-owner", "{owner}", ownerName);
        Set<UUID> trusted = this.trustManager.getTrustedPlayers(ownerId);
        if (!trusted.isEmpty()) {
            ArrayList<String> names = new ArrayList<String>();
            for (UUID id : trusted) {
                String name = Bukkit.getOfflinePlayer((UUID)id).getName();
                if (name == null) continue;
                names.add(name);
            }
            player.sendMessage(this.configManager.getMessage("claim-info-trusted", "{players}", String.join((CharSequence)", ", names)));
        }
        if (!(members = this.trustManager.getMembers(ownerId)).isEmpty()) {
            ArrayList<String> memberNames = new ArrayList<String>();
            for (UUID id : members) {
                String name = Bukkit.getOfflinePlayer((UUID)id).getName();
                if (name == null) continue;
                memberNames.add(name);
            }
            player.sendMessage(this.configManager.getMessage("claim-info-members", "{members}", String.join((CharSequence)", ", memberNames)));
        }
    }

    private void handleMemberCommand(Player player, String[] args) {
        if (args.length < 3) {
            this.sendMessage(player, "invalid-command", new String[0]);
            return;
        }
        ChunkPosition pos = new ChunkPosition(player.getLocation());
        if (!this.claimManager.isChunkClaimed(pos)) {
            this.sendMessage(player, "claim-info-not-claimed", new String[0]);
            return;
        }
        UUID ownerId = this.claimManager.getChunkOwner(pos);
        if (!player.getUniqueId().equals(ownerId)) {
            this.sendMessage(player, "only-owner-can-manage", new String[0]);
            return;
        }
        OfflinePlayer target = Bukkit.getOfflinePlayer((String)args[2]);
        if (target == null || !target.hasPlayedBefore()) {
            this.sendMessage(player, "player-not-found", new String[0]);
            return;
        }
        switch (args[1].toLowerCase()) {
            case "add": {
                if (!this.trustManager.addMember(ownerId, target)) break;
                this.sendMessage(player, "member-added", "{player}", target.getName());
                this.trustManager.savePermissionsAndMembers();
                break;
            }
            case "remove": {
                if (this.trustManager.removeMember(ownerId, target)) {
                    this.sendMessage(player, "member-removed", "{player}", target.getName());
                    this.trustManager.savePermissionsAndMembers();
                    break;
                }
                this.sendMessage(player, "not-a-member", new String[0]);
                break;
            }
            default: {
                this.sendMessage(player, "invalid-command", new String[0]);
            }
        }
    }

    private void handleUnclaimCommand(Player player, String[] args, String cmd) {
        if (cmd.equals("unclaimall") || args.length > 0 && args[0].equalsIgnoreCase("all")) {
            if (args.length > 1 && args[1].equalsIgnoreCase("confirm")) {
                this.unclaimAll(player);
            } else {
                this.sendMessage(player, "confirm-unclaimall", new String[0]);
            }
        } else if (args.length > 0 && args[0].equalsIgnoreCase("auto")) {
            this.toggleAutoUnclaim(player);
        } else {
            this.unclaimCurrentChunk(player);
        }
    }

    private void claimCurrentChunk(Player player) {
        Chunk chunk = player.getLocation().getChunk();
        if (this.claimManager.claimChunk(player, chunk)) {
            this.sendMessage(player, "chunk-claimed", new String[0]);
        }
    }

    private void unclaimCurrentChunk(Player player) {
        Chunk chunk = player.getLocation().getChunk();
        ChunkPosition pos = new ChunkPosition(chunk);
        if (!this.claimManager.isChunkClaimed(pos)) {
            this.sendMessage(player, "not-owner", new String[0]);
            return;
        }
        if (!this.claimManager.getChunkOwner(pos).equals(player.getUniqueId())) {
            this.sendMessage(player, "not-owner", new String[0]);
            return;
        }
        if (this.claimManager.unclaimChunk(chunk)) {
            this.sendMessage(player, "chunk-unclaimed", new String[0]);
        }
    }

    private void toggleAutoClaim(Player player) {
        boolean current = this.autoClaimPlayers.getOrDefault(player.getUniqueId(), this.configManager.getConfig().getBoolean("auto-claim-default", false));
        boolean newValue = !current;
        this.autoClaimPlayers.put(player.getUniqueId(), newValue);
        this.sendMessage(player, newValue ? "auto-claim-enabled" : "auto-claim-disabled", new String[0]);
    }

    private void toggleAutoUnclaim(Player player) {
        boolean current = this.autoUnclaimPlayers.getOrDefault(player.getUniqueId(), this.configManager.getConfig().getBoolean("auto-unclaim-default", false));
        boolean newValue = !current;
        this.autoUnclaimPlayers.put(player.getUniqueId(), newValue);
        this.sendMessage(player, newValue ? "auto-unclaim-enabled" : "auto-unclaim-disabled", new String[0]);
    }

    private void trustPlayer(Player player, String targetName) {
        if (player.getName().equalsIgnoreCase(targetName)) {
            this.sendMessage(player, "cannot-trust-self", new String[0]);
            return;
        }
        if (this.trustManager.addTrustedPlayer(player, targetName)) {
            this.sendMessage(player, "player-trusted-all", "{player}", targetName);
            this.trustManager.saveTrustedPlayers();
        } else {
            this.sendMessage(player, "player-not-found", new String[0]);
        }
    }

    private void untrustPlayer(Player player, String targetName) {
        if (this.trustManager.removeTrustedPlayer(player, targetName)) {
            this.sendMessage(player, "player-untrusted-all", "{player}", targetName);
            this.trustManager.saveTrustedPlayers();
        } else {
            this.sendMessage(player, "player-not-trusted", new String[0]);
        }
    }

    private void unclaimAll(Player player) {
        UUID playerId = player.getUniqueId();
        int count = this.claimManager.unclaimAll(playerId);
        if (count > 0) {
            this.sendMessage(player, "unclaimed-all", "{count}", String.valueOf(count));
            this.visualizationManager.invalidateCache(playerId);
        } else {
            this.sendMessage(player, "&cYou don't have any claims!", new String[0]);
        }
    }

    public void showHelp(Player player) {
        String[] helpKeys;
        for (String key : helpKeys = new String[]{"help-header", "help-claim", "help-unclaim", "help-claim-auto", "help-unclaim-auto", "help-trust", "help-untrust", "help-unstuck", "help-visible", "help-trustlist", "help-info", "help-admin", "help-unclaimall", "help-trust-menu", "help-visitor-menu", "help-member"}) {
            String message = this.configManager.getConfig().getString("messages." + key);
            if (message == null) continue;
            player.sendMessage(this.configManager.getMessage(key, new String[0]));
        }
    }

    private void reloadConfig(Player player) {
        if (!player.hasPermission("landclaim.admin")) {
            this.sendMessage(player, "access-denied", new String[0]);
            return;
        }
        this.configManager.reloadMainConfig();
        this.plugin.reloadConfiguration();
        this.sendMessage(player, "reloaded", new String[0]);
    }

    private void sendMessage(Player player, String key, String ... replacements) {
        player.sendMessage(this.configManager.getMessage(key, replacements));
    }

    public boolean isAutoClaimEnabled(UUID playerId) {
        return this.autoClaimPlayers.getOrDefault(playerId, this.configManager.getConfig().getBoolean("auto-claim-default", false));
    }

    public boolean isAutoUnclaimEnabled(UUID playerId) {
        return this.autoUnclaimPlayers.getOrDefault(playerId, this.configManager.getConfig().getBoolean("auto-unclaim-default", false));
    }
}

