/*
 * Decompiled with CFR 0.152.
 */
package org.ayosynk.landClaimPlugin.gui;

import org.ayosynk.landClaimPlugin.LandClaimPlugin;
import org.ayosynk.landClaimPlugin.gui.TrustMenuGUI;
import org.ayosynk.landClaimPlugin.gui.VisitorMenuGUI;
import org.ayosynk.landClaimPlugin.managers.TrustManager;
import org.ayosynk.landClaimPlugin.utils.ChatUtils;
import org.bukkit.ChatColor;
import org.bukkit.Material;
import org.bukkit.OfflinePlayer;
import org.bukkit.entity.HumanEntity;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.SkullMeta;

public class GUIListener
implements Listener {
    private final TrustManager trustManager;
    private final LandClaimPlugin plugin;

    public GUIListener(TrustManager trustManager) {
        this.trustManager = trustManager;
        this.plugin = trustManager.getPlugin();
    }

    @EventHandler
    public void onInventoryClick(InventoryClickEvent event) {
        HumanEntity humanEntity = event.getWhoClicked();
        if (!(humanEntity instanceof Player)) {
            return;
        }
        Player player = (Player)humanEntity;
        String title = event.getView().getTitle();
        Inventory inv = event.getInventory();
        String trustPrefix = ChatUtils.colorize(this.trustManager.getConfigManager().getMessage("trust-menu-title", "{player}", ""));
        if (title.startsWith(trustPrefix)) {
            event.setCancelled(true);
            item = event.getCurrentItem();
            if (item == null) {
                return;
            }
            String trustedName = ChatColor.stripColor((String)title.replace(trustPrefix, ""));
            Player trustedPlayer = this.plugin.getServer().getPlayer(trustedName);
            if (trustedPlayer == null) {
                return;
            }
            if (event.getRawSlot() == 8) {
                this.plugin.getCommandHandler().showTrustList(player);
                return;
            }
            if (event.getSlot() < 4) {
                String permission = TrustMenuGUI.PERMISSIONS[event.getSlot()];
                boolean current = this.trustManager.hasTrustPermission(player.getUniqueId(), trustedPlayer.getUniqueId(), permission);
                this.trustManager.setTrustPermission(player.getUniqueId(), trustedPlayer.getUniqueId(), permission, !current);
                this.trustManager.savePermissionsAndMembers();
                TrustMenuGUI.open(player, (OfflinePlayer)trustedPlayer, this.trustManager);
            }
        } else if (title.equals(ChatUtils.colorize(this.trustManager.getConfigManager().getMessage("visitor-menu-title", new String[0])))) {
            event.setCancelled(true);
            item = event.getCurrentItem();
            if (item == null) {
                return;
            }
            if (event.getSlot() < 4) {
                String permission = VisitorMenuGUI.PERMISSIONS[event.getSlot()];
                boolean current = this.trustManager.hasVisitorPermission(player.getUniqueId(), permission);
                this.trustManager.setVisitorPermission(player.getUniqueId(), permission, !current);
                this.trustManager.savePermissionsAndMembers();
                VisitorMenuGUI.open(player, this.trustManager);
            }
        }
        String trustListTitle = ChatUtils.colorize(this.trustManager.getConfigManager().getMessage("trust-list-title", new String[0]));
        if (title.equals(trustListTitle)) {
            SkullMeta meta;
            OfflinePlayer trustedPlayer;
            event.setCancelled(true);
            ItemStack item = event.getCurrentItem();
            if (item == null) {
                return;
            }
            if (event.getSlot() == event.getInventory().getSize() - 1) {
                player.closeInventory();
                return;
            }
            if (item.getType() == Material.PLAYER_HEAD && (trustedPlayer = (meta = (SkullMeta)item.getItemMeta()).getOwningPlayer()) != null) {
                Player onlineTrusted = trustedPlayer.getPlayer();
                if (onlineTrusted != null) {
                    TrustMenuGUI.open((Player)event.getWhoClicked(), (OfflinePlayer)onlineTrusted, this.trustManager);
                } else {
                    TrustMenuGUI.open((Player)event.getWhoClicked(), trustedPlayer, this.trustManager);
                }
            }
        }
    }
}

