/*
 * Decompiled with CFR 0.152.
 */
package org.ayosynk.landClaimPlugin.listeners;

import java.util.List;
import java.util.UUID;
import org.ayosynk.landClaimPlugin.LandClaimPlugin;
import org.ayosynk.landClaimPlugin.managers.ClaimManager;
import org.ayosynk.landClaimPlugin.managers.TrustManager;
import org.ayosynk.landClaimPlugin.models.ChunkPosition;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.player.PlayerCommandPreprocessEvent;

public class CommandBlocker
implements Listener {
    private final LandClaimPlugin plugin;
    private final ClaimManager claimManager;
    private final TrustManager trustManager;

    public CommandBlocker(LandClaimPlugin plugin, ClaimManager claimManager, TrustManager trustManager) {
        this.plugin = plugin;
        this.claimManager = claimManager;
        this.trustManager = trustManager;
    }

    @EventHandler
    public void onPlayerCommand(PlayerCommandPreprocessEvent event) {
        Player player = event.getPlayer();
        if (player.hasPermission("landclaim.admin")) {
            return;
        }
        String command = event.getMessage().split(" ")[0].substring(1).toLowerCase();
        List<String> blockedCommands = this.plugin.getConfigManager().getBlockedCommands();
        if (blockedCommands.isEmpty() || !blockedCommands.contains(command)) {
            return;
        }
        ChunkPosition pos = new ChunkPosition(player.getLocation());
        if (!this.claimManager.isChunkClaimed(pos)) {
            return;
        }
        UUID owner = this.claimManager.getChunkOwner(pos);
        if (player.getUniqueId().equals(owner) || this.trustManager.isTrusted(owner, player)) {
            return;
        }
        event.setCancelled(true);
        player.sendMessage(this.plugin.getConfigManager().getMessage("command-blocked", new String[0]));
    }
}

