/*
 * Decompiled with CFR 0.152.
 */
package org.ayosynk.landClaimPlugin.listeners;

import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import net.md_5.bungee.api.ChatMessageType;
import net.md_5.bungee.api.chat.TextComponent;
import org.ayosynk.landClaimPlugin.LandClaimPlugin;
import org.ayosynk.landClaimPlugin.gui.TrustMenuGUI;
import org.ayosynk.landClaimPlugin.managers.ClaimManager;
import org.ayosynk.landClaimPlugin.managers.ConfigManager;
import org.ayosynk.landClaimPlugin.managers.TrustManager;
import org.ayosynk.landClaimPlugin.models.ChunkPosition;
import org.ayosynk.landClaimPlugin.utils.ChatUtils;
import org.bukkit.Bukkit;
import org.bukkit.Chunk;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.OfflinePlayer;
import org.bukkit.block.Block;
import org.bukkit.entity.Animals;
import org.bukkit.entity.Entity;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.Player;
import org.bukkit.entity.Projectile;
import org.bukkit.entity.Tameable;
import org.bukkit.entity.Villager;
import org.bukkit.event.Cancellable;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.block.BlockBreakEvent;
import org.bukkit.event.block.BlockPlaceEvent;
import org.bukkit.event.entity.EntityChangeBlockEvent;
import org.bukkit.event.entity.EntityDamageByEntityEvent;
import org.bukkit.event.entity.EntityExplodeEvent;
import org.bukkit.event.player.AsyncPlayerChatEvent;
import org.bukkit.event.player.PlayerBucketEmptyEvent;
import org.bukkit.event.player.PlayerInteractEvent;
import org.bukkit.event.player.PlayerMoveEvent;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitRunnable;

public class EventListener
implements Listener {
    private final LandClaimPlugin plugin;
    private final ClaimManager claimManager;
    private final TrustManager trustManager;
    private final ConfigManager configManager;
    private final Map<UUID, ChunkPosition> lastChunkMap = new HashMap<UUID, ChunkPosition>();
    private final Map<UUID, String> lastActionBarMap = new HashMap<UUID, String>();
    private static final Set<Material> INTERACTABLE_BLOCKS = new HashSet<Material>(Arrays.asList(Material.CHEST, Material.TRAPPED_CHEST, Material.ENDER_CHEST, Material.BARREL, Material.FURNACE, Material.BLAST_FURNACE, Material.SMOKER, Material.HOPPER, Material.DROPPER, Material.DISPENSER, Material.BREWING_STAND, Material.ACACIA_DOOR, Material.BIRCH_DOOR, Material.DARK_OAK_DOOR, Material.JUNGLE_DOOR, Material.OAK_DOOR, Material.SPRUCE_DOOR, Material.CHERRY_DOOR, Material.PALE_OAK_DOOR, Material.BAMBOO_DOOR, Material.CRIMSON_DOOR, Material.WARPED_DOOR, Material.ACACIA_TRAPDOOR, Material.BIRCH_TRAPDOOR, Material.CHERRY_TRAPDOOR, Material.BAMBOO_TRAPDOOR, Material.PALE_OAK_TRAPDOOR, Material.CRIMSON_TRAPDOOR, Material.WARPED_TRAPDOOR, Material.BAMBOO_BUTTON, Material.CHERRY_BUTTON, Material.PALE_OAK_BUTTON, Material.DARK_OAK_TRAPDOOR, Material.JUNGLE_TRAPDOOR, Material.OAK_TRAPDOOR, Material.SPRUCE_TRAPDOOR, Material.IRON_DOOR, Material.IRON_TRAPDOOR, Material.LEVER, Material.STONE_BUTTON, Material.OAK_BUTTON, Material.SPRUCE_BUTTON, Material.BIRCH_BUTTON, Material.JUNGLE_BUTTON, Material.ACACIA_BUTTON, Material.DARK_OAK_BUTTON, Material.CRIMSON_BUTTON, Material.WARPED_BUTTON, Material.ANVIL, Material.CHIPPED_ANVIL, Material.DAMAGED_ANVIL, Material.GRINDSTONE, Material.SMITHING_TABLE, Material.LOOM, Material.CARTOGRAPHY_TABLE, Material.FLETCHING_TABLE, Material.STONECUTTER, Material.BELL, Material.COMPOSTER, Material.SHULKER_BOX, Material.WHITE_SHULKER_BOX, Material.ORANGE_SHULKER_BOX, Material.MAGENTA_SHULKER_BOX, Material.LIGHT_BLUE_SHULKER_BOX, Material.YELLOW_SHULKER_BOX, Material.LIME_SHULKER_BOX, Material.PINK_SHULKER_BOX, Material.GRAY_SHULKER_BOX, Material.LIGHT_GRAY_SHULKER_BOX, Material.CYAN_SHULKER_BOX, Material.PURPLE_SHULKER_BOX, Material.BLUE_SHULKER_BOX, Material.BROWN_SHULKER_BOX, Material.GREEN_SHULKER_BOX, Material.RED_SHULKER_BOX, Material.BLACK_SHULKER_BOX, Material.WATER_BUCKET, Material.LAVA_BUCKET));

    public EventListener(LandClaimPlugin plugin, ClaimManager claimManager, TrustManager trustManager, ConfigManager configManager) {
        this.plugin = plugin;
        this.claimManager = claimManager;
        this.trustManager = trustManager;
        this.configManager = configManager;
        this.startActionBarTask();
    }

    private void startActionBarTask() {
        new BukkitRunnable(){

            public void run() {
                for (Player player : EventListener.this.plugin.getServer().getOnlinePlayers()) {
                    EventListener.this.updateActionBar(player);
                }
            }
        }.runTaskTimer((Plugin)this.plugin, 0L, 10L);
    }

    private void updateActionBar(Player player) {
        ChunkPosition currentPos = new ChunkPosition(player.getLocation().getChunk());
        ChunkPosition lastPos = this.lastChunkMap.get(player.getUniqueId());
        if (lastPos == null || !currentPos.equals(lastPos)) {
            this.lastChunkMap.put(player.getUniqueId(), currentPos);
            if (this.claimManager.isChunkClaimed(currentPos)) {
                UUID playerId;
                UUID ownerId = this.claimManager.getChunkOwner(currentPos);
                String ownerName = this.plugin.getServer().getOfflinePlayer(ownerId).getName();
                if (ownerName == null) {
                    ownerName = "Unknown";
                }
                String message = (playerId = player.getUniqueId()).equals(ownerId) ? this.configManager.getConfig().getString("messages.actionbar-own", "&aYour claim") : (this.trustManager.isTrusted(ownerId, player) ? this.configManager.getConfig().getString("messages.actionbar-trusted", "&eTrusted in {owner}'s claim").replace("{owner}", ownerName) : (player.hasPermission("landclaim.admin") ? this.configManager.getConfig().getString("messages.actionbar-admin", "&cAdmin: {owner}'s claim").replace("{owner}", ownerName) : this.configManager.getConfig().getString("messages.actionbar-owner", "&e{owner}'s claim").replace("{owner}", ownerName)));
                this.sendActionBar(player, ChatUtils.colorize(message));
                this.lastActionBarMap.put(player.getUniqueId(), message);
            } else if (this.lastActionBarMap.containsKey(player.getUniqueId())) {
                this.sendActionBar(player, "");
                this.lastActionBarMap.remove(player.getUniqueId());
            }
        }
    }

    private void sendActionBar(Player player, String message) {
        player.spigot().sendMessage(ChatMessageType.ACTION_BAR, TextComponent.fromLegacyText((String)message));
    }

    @EventHandler
    public void onPlayerMove(PlayerMoveEvent event) {
        ChunkPosition fromPos;
        ChunkPosition pos;
        Chunk toChunk;
        Location from = event.getFrom();
        Location to = event.getTo();
        if (to == null) {
            return;
        }
        Chunk fromChunk = from.getChunk();
        if (fromChunk.equals((Object)(toChunk = to.getChunk()))) {
            return;
        }
        Player player = event.getPlayer();
        UUID playerId = player.getUniqueId();
        if (this.plugin.getCommandHandler().isAutoClaimEnabled(playerId) && !this.claimManager.isChunkClaimed(pos = new ChunkPosition(toChunk)) && this.claimManager.claimChunk(player, toChunk)) {
            player.sendMessage(this.configManager.getMessage("chunk-claimed", new String[0]));
        }
        if (this.plugin.getCommandHandler().isAutoUnclaimEnabled(playerId) && this.claimManager.isChunkClaimed(fromPos = new ChunkPosition(fromChunk)) && this.claimManager.getChunkOwner(fromPos).equals(playerId) && !this.isConnectedToOtherClaims(fromPos, playerId)) {
            this.claimManager.unclaimChunk(fromChunk);
            player.sendMessage(this.configManager.getMessage("auto-unclaimed", new String[0]));
        }
    }

    private boolean isConnectedToOtherClaims(ChunkPosition pos, UUID playerId) {
        if (!this.configManager.requireConnectedClaims()) {
            return false;
        }
        Set<ChunkPosition> claims = this.claimManager.getPlayerClaims(playerId);
        if (claims.isEmpty()) {
            return false;
        }
        HashSet<ChunkPosition> neighbors = new HashSet<ChunkPosition>(pos.getNeighbors(this.configManager.allowDiagonalConnections()));
        neighbors.retainAll(claims);
        neighbors.remove(pos);
        return !neighbors.isEmpty();
    }

    @EventHandler
    public void onBlockPlace(BlockPlaceEvent event) {
        this.checkBlockPermission(event.getPlayer(), event.getBlock(), (Cancellable)event, "BUILD");
    }

    @EventHandler
    public void onBlockBreak(BlockBreakEvent event) {
        this.checkBlockPermission(event.getPlayer(), event.getBlock(), (Cancellable)event, "BUILD");
    }

    @EventHandler
    public void onPlayerInteract(PlayerInteractEvent event) {
        if (event.getClickedBlock() == null) {
            return;
        }
        Block block = event.getClickedBlock();
        if (!INTERACTABLE_BLOCKS.contains(block.getType())) {
            return;
        }
        this.checkInteractionPermission(event.getPlayer(), event, "INTERACT");
    }

    @EventHandler
    public void onBucketEmpty(PlayerBucketEmptyEvent event) {
        Player player = event.getPlayer();
        Block block = event.getBlockClicked().getRelative(event.getBlockFace());
        Material bucket = event.getBucket();
        if (bucket != Material.WATER_BUCKET && bucket != Material.LAVA_BUCKET) {
            return;
        }
        if (this.shouldCancelBucketPlacement(player, block)) {
            event.setCancelled(true);
            player.sendMessage(this.configManager.getMessage("bucket-denied", new String[0]));
        }
    }

    @EventHandler
    public void onEntityDamage(EntityDamageByEntityEvent event) {
        Projectile projectile;
        if (event.getEntity() instanceof Villager || event.getEntity() instanceof Animals || this.isPet(event.getEntity())) {
            ChunkPosition pos;
            Projectile projectile2;
            Player damager = null;
            if (event.getDamager() instanceof Player) {
                damager = (Player)event.getDamager();
            } else if (event.getDamager() instanceof Projectile && (projectile2 = (Projectile)event.getDamager()).getShooter() instanceof Player) {
                damager = (Player)projectile2.getShooter();
            }
            if (damager == null) {
                return;
            }
            Location location = event.getEntity().getLocation();
            if (this.isInProtectedChunk(location) && this.claimManager.isChunkClaimed(pos = new ChunkPosition(location))) {
                UUID owner = this.claimManager.getChunkOwner(pos);
                if (damager.getUniqueId().equals(owner) || this.trustManager.isTrusted(owner, damager)) {
                    return;
                }
                event.setCancelled(true);
                damager.sendMessage(this.configManager.getMessage("harm-entity-denied", new String[0]));
            }
            return;
        }
        if (!this.configManager.preventPvP()) {
            return;
        }
        Player attacker = null;
        Player victim = null;
        if (event.getDamager() instanceof Player && event.getEntity() instanceof Player) {
            attacker = (Player)event.getDamager();
            victim = (Player)event.getEntity();
        } else if (event.getDamager() instanceof Projectile && (projectile = (Projectile)event.getDamager()).getShooter() instanceof Player && event.getEntity() instanceof Player) {
            attacker = (Player)projectile.getShooter();
            victim = (Player)event.getEntity();
        }
        if (attacker == null || victim == null) {
            return;
        }
        Location location = victim.getLocation();
        if (this.isInProtectedChunk(location)) {
            event.setCancelled(true);
            attacker.sendMessage(this.configManager.getMessage("pvp-denied", new String[0]));
        }
    }

    private boolean isPet(Entity entity) {
        if (entity instanceof Tameable) {
            Tameable tameable = (Tameable)entity;
            return tameable.isTamed() && tameable.getOwner() != null;
        }
        return false;
    }

    @EventHandler
    public void onEntityExplode(EntityExplodeEvent event) {
        if (!this.configManager.preventExplosionDamage()) {
            return;
        }
        Location explosionLoc = event.getLocation();
        ChunkPosition explosionChunk = new ChunkPosition(explosionLoc);
        boolean nearClaim = false;
        for (int dx = -1; dx <= 1; ++dx) {
            for (int dz = -1; dz <= 1; ++dz) {
                ChunkPosition checkPos = new ChunkPosition(explosionLoc.getWorld().getName(), explosionChunk.getX() + dx, explosionChunk.getZ() + dz);
                if (!this.claimManager.isChunkClaimed(checkPos)) continue;
                nearClaim = true;
                break;
            }
            if (nearClaim) break;
        }
        if (!nearClaim) {
            return;
        }
        event.blockList().removeIf(b -> this.claimManager.isChunkClaimed(new ChunkPosition((Block)b)));
    }

    @EventHandler
    public void onEntityChangeBlock(EntityChangeBlockEvent event) {
        if (!this.configManager.preventMobGriefing()) {
            return;
        }
        EntityType type = event.getEntityType();
        if ((type == EntityType.ENDERMAN || type == EntityType.RAVAGER) && this.isInProtectedChunk(event.getBlock().getLocation())) {
            event.setCancelled(true);
        }
    }

    private boolean isInProtectedChunk(Location location) {
        ChunkPosition pos = new ChunkPosition(location);
        return this.claimManager.isChunkClaimed(pos);
    }

    private void checkBlockPermission(Player player, Block block, Cancellable event, String permission) {
        if (player.hasPermission("landclaim.admin")) {
            return;
        }
        ChunkPosition pos = new ChunkPosition(block);
        if (this.claimManager.isChunkClaimed(pos)) {
            UUID owner = this.claimManager.getChunkOwner(pos);
            if (player.getUniqueId().equals(owner)) {
                return;
            }
            if (this.trustManager.isTrusted(owner, player) ? this.trustManager.hasTrustPermission(owner, player.getUniqueId(), permission) : this.trustManager.hasVisitorPermission(owner, permission)) {
                return;
            }
            event.setCancelled(true);
            player.sendMessage(this.configManager.getMessage("access-denied", new String[0]));
        }
    }

    private boolean shouldCancelBucketPlacement(Player player, Block block) {
        if (player.hasPermission("landclaim.admin")) {
            return false;
        }
        ChunkPosition pos = new ChunkPosition(block);
        if (this.claimManager.isChunkClaimed(pos)) {
            UUID owner = this.claimManager.getChunkOwner(pos);
            UUID playerId = player.getUniqueId();
            if (playerId.equals(owner)) {
                return false;
            }
            if (this.trustManager.isTrusted(owner, player)) {
                return !this.trustManager.hasTrustPermission(owner, player.getUniqueId(), "BUILD");
            }
            return !this.trustManager.hasVisitorPermission(owner, "BUILD");
        }
        return false;
    }

    private void checkInteractionPermission(Player player, PlayerInteractEvent event, String permission) {
        if (player.hasPermission("landclaim.admin")) {
            return;
        }
        Block block = event.getClickedBlock();
        ChunkPosition pos = new ChunkPosition(block);
        if (this.claimManager.isChunkClaimed(pos)) {
            UUID owner = this.claimManager.getChunkOwner(pos);
            if (player.getUniqueId().equals(owner)) {
                return;
            }
            if (this.trustManager.isTrusted(owner, player) ? this.trustManager.hasTrustPermission(owner, player.getUniqueId(), permission) : this.trustManager.hasVisitorPermission(owner, permission)) {
                return;
            }
            event.setCancelled(true);
            player.sendMessage(this.configManager.getMessage("access-denied-interact", new String[0]));
        }
    }

    @EventHandler
    public void onPlayerChat(AsyncPlayerChatEvent event) {
        Player player = event.getPlayer();
        String message = event.getMessage();
        if (message.startsWith("\u00a77- \u00a7e")) {
            event.setCancelled(true);
            String playerName = message.substring(6);
            Player trustedPlayer = Bukkit.getPlayer((String)playerName);
            if (trustedPlayer != null) {
                TrustMenuGUI.open(player, (OfflinePlayer)trustedPlayer, this.trustManager);
            }
        }
    }
}

