/*
 * Decompiled with CFR 0.152.
 */
package org.ayosynk.landClaimPlugin.managers;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import org.ayosynk.landClaimPlugin.LandClaimPlugin;
import org.ayosynk.landClaimPlugin.managers.ConfigManager;
import org.ayosynk.landClaimPlugin.models.ChunkPosition;
import org.bukkit.Bukkit;
import org.bukkit.Chunk;
import org.bukkit.World;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.entity.Player;

public class ClaimManager {
    private final LandClaimPlugin plugin;
    private final ConfigManager configManager;
    private final Map<ChunkPosition, UUID> claimedChunks = new HashMap<ChunkPosition, UUID>();
    private final Map<UUID, Set<ChunkPosition>> playerClaims = new HashMap<UUID, Set<ChunkPosition>>();

    public ClaimManager(LandClaimPlugin plugin, ConfigManager configManager) {
        this.plugin = plugin;
        this.configManager = configManager;
    }

    public void initialize() {
        this.loadClaims();
    }

    public int getTotalClaims() {
        return this.claimedChunks.size();
    }

    public void loadClaims() {
        this.claimedChunks.clear();
        this.playerClaims.clear();
        FileConfiguration config = this.configManager.getClaimsConfig();
        ConfigurationSection claimsSection = config.getConfigurationSection("claims");
        if (claimsSection == null) {
            return;
        }
        for (String playerIdStr : claimsSection.getKeys(false)) {
            UUID ownerId;
            try {
                ownerId = UUID.fromString(playerIdStr);
            }
            catch (IllegalArgumentException e) {
                this.plugin.getLogger().warning("Skipping invalid player UUID: " + playerIdStr);
                continue;
            }
            List chunkStrings = claimsSection.getStringList(playerIdStr);
            for (String chunkStr : chunkStrings) {
                String[] parts = chunkStr.split(",");
                if (parts.length != 3) {
                    this.plugin.getLogger().warning("Skipping invalid chunk entry: " + chunkStr);
                    continue;
                }
                try {
                    String world = parts[0];
                    int x = Integer.parseInt(parts[1]);
                    int z = Integer.parseInt(parts[2]);
                    ChunkPosition pos = new ChunkPosition(world, x, z);
                    this.claimedChunks.put(pos, ownerId);
                    this.playerClaims.computeIfAbsent(ownerId, k -> new HashSet()).add(pos);
                }
                catch (NumberFormatException e) {
                    this.plugin.getLogger().warning("Skipping chunk entry with invalid coordinates: " + chunkStr);
                }
            }
        }
    }

    public void saveClaims() {
        FileConfiguration config = this.configManager.getClaimsConfig();
        config.set("claims", null);
        ConfigurationSection claimsSection = config.createSection("claims");
        for (Map.Entry<UUID, Set<ChunkPosition>> entry : this.playerClaims.entrySet()) {
            ArrayList<String> chunkStrings = new ArrayList<String>();
            for (ChunkPosition pos : entry.getValue()) {
                chunkStrings.add(pos.toString());
            }
            claimsSection.set(entry.getKey().toString(), chunkStrings);
        }
        this.configManager.saveClaimsConfig();
    }

    public boolean claimChunk(Player player, Chunk chunk) {
        boolean isConnected;
        String worldName = chunk.getWorld().getName();
        if (this.configManager.isWorldBlocked(worldName)) {
            player.sendMessage(this.configManager.getMessage("world-blocked", new String[0]));
            return false;
        }
        ChunkPosition pos = new ChunkPosition(chunk);
        if (this.isChunkClaimed(pos)) {
            UUID owner = this.getChunkOwner(pos);
            String ownerName = this.plugin.getServer().getOfflinePlayer(owner).getName();
            player.sendMessage(this.configManager.getMessage("already-claimed", "{owner}", ownerName != null ? ownerName : "Unknown"));
            return false;
        }
        UUID playerId = player.getUniqueId();
        int claimLimit = this.getClaimLimit(player);
        Set claims = this.playerClaims.getOrDefault(playerId, new HashSet());
        if (claims.size() >= claimLimit) {
            player.sendMessage(this.configManager.getMessage("claim-limit-reached", "{limit}", String.valueOf(claimLimit)));
            return false;
        }
        if (this.configManager.requireConnectedClaims() && !claims.isEmpty() && !(isConnected = this.isConnectedToOwnClaims(pos, playerId))) {
            player.sendMessage(this.configManager.getMessage("not-connected", new String[0]));
            return false;
        }
        this.claimedChunks.put(pos, playerId);
        claims.add(pos);
        this.playerClaims.put(playerId, claims);
        this.plugin.getVisualizationManager().invalidateCache(playerId);
        return true;
    }

    private boolean isConnectedToOwnClaims(ChunkPosition pos, UUID playerId) {
        Set<ChunkPosition> claims = this.playerClaims.get(playerId);
        if (claims == null || claims.isEmpty()) {
            return false;
        }
        boolean allowDiagonals = this.configManager.allowDiagonalConnections();
        for (ChunkPosition neighbor : pos.getNeighbors(allowDiagonals)) {
            if (!claims.contains(neighbor)) continue;
            return true;
        }
        return false;
    }

    public boolean unclaimChunk(Chunk chunk) {
        ChunkPosition pos = new ChunkPosition(chunk);
        if (!this.isChunkClaimed(pos)) {
            return false;
        }
        UUID owner = this.claimedChunks.remove(pos);
        if (owner != null) {
            Set<ChunkPosition> claims = this.playerClaims.get(owner);
            if (claims != null) {
                claims.remove(pos);
                if (claims.isEmpty()) {
                    this.playerClaims.remove(owner);
                }
            }
            this.plugin.getVisualizationManager().invalidateCache(owner);
            return true;
        }
        return false;
    }

    public int unclaimAll(UUID playerId) {
        Set claims = this.playerClaims.getOrDefault(playerId, new HashSet());
        if (claims.isEmpty()) {
            return 0;
        }
        HashSet toRemove = new HashSet(claims);
        int count = 0;
        for (ChunkPosition pos : toRemove) {
            Chunk chunk;
            World world = Bukkit.getWorld((String)pos.getWorld());
            if (world == null || !this.unclaimChunk(chunk = world.getChunkAt(pos.getX(), pos.getZ()))) continue;
            ++count;
        }
        return count;
    }

    public boolean isChunkClaimed(ChunkPosition pos) {
        return this.claimedChunks.containsKey(pos);
    }

    public UUID getChunkOwner(ChunkPosition pos) {
        return this.claimedChunks.get(pos);
    }

    public Set<ChunkPosition> getPlayerClaims(UUID playerId) {
        return this.playerClaims.getOrDefault(playerId, Collections.emptySet());
    }

    public int getClaimLimit(Player player) {
        if (player.hasPermission("landclaim.admin")) {
            return Integer.MAX_VALUE;
        }
        for (int i = 100; i > 0; --i) {
            if (!player.hasPermission("landclaim.limit." + i)) continue;
            return i;
        }
        return this.configManager.getConfig().getInt("chunk-claim-limit", 5);
    }
}

