/*
 * Decompiled with CFR 0.152.
 */
package org.ayosynk.landClaimPlugin.managers;

import java.io.File;
import java.io.IOException;
import java.util.List;
import org.ayosynk.landClaimPlugin.LandClaimPlugin;
import org.ayosynk.landClaimPlugin.utils.ChatUtils;
import org.ayosynk.landClaimPlugin.utils.ConfigUpdater;
import org.bukkit.Color;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.configuration.file.YamlConfiguration;

public class ConfigManager {
    private final LandClaimPlugin plugin;
    private FileConfiguration config;
    private File configFile;
    private FileConfiguration claimsConfig;
    private File claimsFile;
    private FileConfiguration trustConfig;
    private File trustFile;

    public ConfigManager(LandClaimPlugin plugin) {
        this.plugin = plugin;
        this.updateConfig();
        this.loadConfigs();
    }

    private void updateConfig() {
        ConfigUpdater.updateConfig(this.plugin);
    }

    private void loadConfigs() {
        this.plugin.saveDefaultConfig();
        this.config = this.plugin.getConfig();
        this.claimsFile = new File(this.plugin.getDataFolder(), "claims.yml");
        if (!this.claimsFile.exists()) {
            this.createEmptyFile(this.claimsFile);
        }
        this.claimsConfig = YamlConfiguration.loadConfiguration((File)this.claimsFile);
        this.trustFile = new File(this.plugin.getDataFolder(), "trust.yml");
        if (!this.trustFile.exists()) {
            this.createEmptyFile(this.trustFile);
        }
        this.trustConfig = YamlConfiguration.loadConfiguration((File)this.trustFile);
    }

    private void createEmptyFile(File file) {
        try {
            file.getParentFile().mkdirs();
            file.createNewFile();
        }
        catch (IOException e) {
            this.plugin.getLogger().severe("Failed to create file: " + file.getName());
            e.printStackTrace();
        }
    }

    public void reloadMainConfig() {
        this.plugin.reloadConfig();
        this.config = this.plugin.getConfig();
    }

    public FileConfiguration getConfig() {
        return this.config;
    }

    public FileConfiguration getClaimsConfig() {
        return this.claimsConfig;
    }

    public FileConfiguration getTrustConfig() {
        return this.trustConfig;
    }

    public boolean requireConnectedClaims() {
        return this.getConfig().getBoolean("require-connected-claims", false);
    }

    public boolean allowDiagonalConnections() {
        return this.getConfig().getBoolean("allow-diagonal-connections", true);
    }

    public boolean preventPvP() {
        return this.getConfig().getBoolean("prevent-pvp", true);
    }

    public boolean preventMobGriefing() {
        return this.getConfig().getBoolean("prevent-mob-griefing", true);
    }

    public boolean preventExplosionDamage() {
        return this.getConfig().getBoolean("prevent-explosion-damage", true);
    }

    public boolean preventHarmEntities() {
        return this.getConfig().getBoolean("prevent-harm-entities", true);
    }

    public boolean isWorldBlocked(String worldName) {
        List blockedWorlds = this.getConfig().getStringList("block-world");
        return blockedWorlds.contains(worldName);
    }

    public List<String> getBlockedCommands() {
        return this.getConfig().getStringList("block-cmd");
    }

    public int getUnstuckCooldown() {
        return this.getConfig().getInt("cooldown-unstuck", 30);
    }

    public Color getVisualizationColor(String type) {
        String colorStr = this.getConfig().getString("visualization." + type, "0,255,0");
        String[] rgb = colorStr.split(",");
        try {
            int r = Integer.parseInt(rgb[0].trim());
            int g = Integer.parseInt(rgb[1].trim());
            int b = Integer.parseInt(rgb[2].trim());
            return Color.fromRGB((int)r, (int)g, (int)b);
        }
        catch (Exception e) {
            return type.equals("always-color") ? Color.LIME : Color.YELLOW;
        }
    }

    public double getParticleSpacing() {
        return this.getConfig().getDouble("visualization.particle-spacing", 0.5);
    }

    public int getVisualizationUpdateInterval() {
        return this.getConfig().getInt("visualization.update-interval", 20);
    }

    public boolean getDefaultTrustPermission(String permission) {
        return this.getConfig().getBoolean("default-trust-permissions." + permission, true);
    }

    public boolean getDefaultVisitorPermission(String permission) {
        return this.getConfig().getBoolean("default-visitor-permissions." + permission, false);
    }

    public void saveClaimsConfig() {
        try {
            this.claimsConfig.save(this.claimsFile);
        }
        catch (IOException e) {
            this.plugin.getLogger().severe("Could not save claims.yml: " + e.getMessage());
        }
    }

    public void saveTrustConfig() {
        try {
            this.trustConfig.save(this.trustFile);
        }
        catch (IOException e) {
            this.plugin.getLogger().severe("Could not save trust.yml: " + e.getMessage());
        }
    }

    public String getMessage(String key, String ... replacements) {
        String prefix = this.getConfig().getString("prefix", "&8[&6LandClaim&8]&r ");
        String message = this.getConfig().getString("messages." + key, "&cMessage not found: " + key);
        for (int i = 0; i < replacements.length; i += 2) {
            message = message.replace(replacements[i], replacements[i + 1]);
        }
        return ChatUtils.colorize(prefix + message);
    }
}

