/*
 * Decompiled with CFR 0.152.
 */
package org.ayosynk.landClaimPlugin.managers;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import org.ayosynk.landClaimPlugin.LandClaimPlugin;
import org.ayosynk.landClaimPlugin.managers.ClaimManager;
import org.ayosynk.landClaimPlugin.managers.ConfigManager;
import org.bukkit.Bukkit;
import org.bukkit.OfflinePlayer;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.entity.Player;

public class TrustManager {
    private final LandClaimPlugin plugin;
    private final ClaimManager claimManager;
    private final ConfigManager configManager;
    private final Map<UUID, Set<UUID>> trustedPlayers = new HashMap<UUID, Set<UUID>>();
    private final Map<UUID, Map<UUID, Set<String>>> trustPermissions = new HashMap<UUID, Map<UUID, Set<String>>>();
    private final Map<UUID, Map<String, Boolean>> visitorPermissions = new HashMap<UUID, Map<String, Boolean>>();
    private final Map<UUID, Set<UUID>> claimMembers = new HashMap<UUID, Set<UUID>>();

    public TrustManager(LandClaimPlugin plugin, ClaimManager claimManager, ConfigManager configManager) {
        this.plugin = plugin;
        this.claimManager = claimManager;
        this.configManager = configManager;
    }

    public LandClaimPlugin getPlugin() {
        return this.plugin;
    }

    public ConfigManager getConfigManager() {
        return this.configManager;
    }

    public void initialize() {
        this.loadTrustedPlayers();
        this.loadPermissions();
        this.loadMembers();
    }

    public int getTotalTrusts() {
        int count = 0;
        for (Set<UUID> trustedSet : this.trustedPlayers.values()) {
            count += trustedSet.size();
        }
        return count;
    }

    public void loadTrustedPlayers() {
        this.trustedPlayers.clear();
        FileConfiguration config = this.configManager.getTrustConfig();
        ConfigurationSection trustSection = config.getConfigurationSection("trust");
        if (trustSection == null) {
            return;
        }
        for (String ownerIdStr : trustSection.getKeys(false)) {
            try {
                UUID owner = UUID.fromString(ownerIdStr);
                List trustedIds = trustSection.getStringList(ownerIdStr);
                HashSet<UUID> trustedSet = new HashSet<UUID>();
                for (String id : trustedIds) {
                    trustedSet.add(UUID.fromString(id));
                }
                this.trustedPlayers.put(owner, trustedSet);
            }
            catch (Exception e) {
                this.plugin.getLogger().warning("Skipping invalid trust entry: " + ownerIdStr);
            }
        }
    }

    public void loadPermissions() {
        this.trustPermissions.clear();
        this.visitorPermissions.clear();
        FileConfiguration config = this.configManager.getTrustConfig();
        ConfigurationSection permissionsSection = config.getConfigurationSection("permissions");
        if (permissionsSection == null) {
            return;
        }
        for (String ownerIdStr : permissionsSection.getKeys(false)) {
            ConfigurationSection visitorSection;
            UUID owner = UUID.fromString(ownerIdStr);
            ConfigurationSection ownerSection = permissionsSection.getConfigurationSection(ownerIdStr);
            ConfigurationSection trustSection = ownerSection.getConfigurationSection("trust");
            if (trustSection != null) {
                for (String trustedIdStr : trustSection.getKeys(false)) {
                    UUID trustedId = UUID.fromString(trustedIdStr);
                    HashSet permissions = new HashSet(trustSection.getStringList(trustedIdStr));
                    this.trustPermissions.computeIfAbsent(owner, k -> new HashMap()).put(trustedId, permissions);
                }
            }
            if ((visitorSection = ownerSection.getConfigurationSection("visitor")) == null) continue;
            HashMap<String, Boolean> perms = new HashMap<String, Boolean>();
            for (String perm : visitorSection.getKeys(false)) {
                perms.put(perm, visitorSection.getBoolean(perm));
            }
            this.visitorPermissions.put(owner, perms);
        }
    }

    public void loadMembers() {
        this.claimMembers.clear();
        FileConfiguration config = this.configManager.getTrustConfig();
        ConfigurationSection membersSection = config.getConfigurationSection("members");
        if (membersSection == null) {
            return;
        }
        for (String ownerIdStr : membersSection.getKeys(false)) {
            UUID owner = UUID.fromString(ownerIdStr);
            List memberIds = membersSection.getStringList(ownerIdStr);
            HashSet<UUID> memberSet = new HashSet<UUID>();
            for (String id : memberIds) {
                memberSet.add(UUID.fromString(id));
            }
            this.claimMembers.put(owner, memberSet);
        }
    }

    public void saveTrustedPlayers() {
        FileConfiguration config = this.configManager.getTrustConfig();
        config.set("trust", null);
        ConfigurationSection trustSection = config.createSection("trust");
        for (Map.Entry<UUID, Set<UUID>> entry : this.trustedPlayers.entrySet()) {
            ArrayList<String> trustedIds = new ArrayList<String>();
            for (UUID id : entry.getValue()) {
                trustedIds.add(id.toString());
            }
            trustSection.set(entry.getKey().toString(), trustedIds);
        }
        this.configManager.saveTrustConfig();
    }

    public void savePermissionsAndMembers() {
        ConfigurationSection ownerSection;
        FileConfiguration config = this.configManager.getTrustConfig();
        config.set("permissions", null);
        ConfigurationSection permissionsSection = config.createSection("permissions");
        for (Map.Entry<UUID, Map<UUID, Set<String>>> entry : this.trustPermissions.entrySet()) {
            ownerSection = permissionsSection.createSection(entry.getKey().toString());
            ConfigurationSection trustSection = ownerSection.createSection("trust");
            for (Map.Entry<UUID, Set<String>> trustEntry : entry.getValue().entrySet()) {
                trustSection.set(trustEntry.getKey().toString(), new ArrayList(trustEntry.getValue()));
            }
        }
        for (Map.Entry<UUID, Map<Object, Object>> entry : this.visitorPermissions.entrySet()) {
            ownerSection = permissionsSection.getConfigurationSection(entry.getKey().toString());
            if (ownerSection == null) {
                ownerSection = permissionsSection.createSection(entry.getKey().toString());
            }
            ConfigurationSection visitorSection = ownerSection.createSection("visitor");
            for (Map.Entry<Object, Object> permEntry : entry.getValue().entrySet()) {
                visitorSection.set((String)permEntry.getKey(), permEntry.getValue());
            }
        }
        config.set("members", null);
        ConfigurationSection membersSection = config.createSection("members");
        for (Map.Entry<UUID, Set<UUID>> entry : this.claimMembers.entrySet()) {
            ArrayList<String> memberIds = new ArrayList<String>();
            for (UUID id : entry.getValue()) {
                memberIds.add(id.toString());
            }
            membersSection.set(entry.getKey().toString(), memberIds);
        }
        this.configManager.saveTrustConfig();
    }

    public boolean addTrustedPlayer(Player owner, String targetName) {
        if (owner.getName().equalsIgnoreCase(targetName)) {
            return false;
        }
        Player onlinePlayer = Bukkit.getPlayerExact((String)targetName);
        if (onlinePlayer != null) {
            return this.addTrustedPlayer(owner, onlinePlayer.getUniqueId());
        }
        for (OfflinePlayer offlinePlayer : Bukkit.getOfflinePlayers()) {
            if (offlinePlayer.getName() == null || !offlinePlayer.getName().equalsIgnoreCase(targetName)) continue;
            return this.addTrustedPlayer(owner, offlinePlayer.getUniqueId());
        }
        return false;
    }

    public boolean addTrustedPlayer(Player owner, UUID trustedId) {
        UUID ownerId = owner.getUniqueId();
        this.trustedPlayers.computeIfAbsent(ownerId, k -> new HashSet()).add(trustedId);
        this.setDefaultPermissions(ownerId, trustedId);
        return true;
    }

    private void setDefaultPermissions(UUID ownerId, UUID trustedId) {
        for (String permission : new String[]{"BUILD", "INTERACT", "CONTAINER", "TELEPORT"}) {
            if (!this.configManager.getDefaultTrustPermission(permission)) continue;
            this.setTrustPermission(ownerId, trustedId, permission, true);
        }
    }

    public boolean removeTrustedPlayer(Player owner, String targetName) {
        Player onlinePlayer = Bukkit.getPlayerExact((String)targetName);
        if (onlinePlayer != null) {
            return this.removeTrustedPlayer(owner, onlinePlayer.getUniqueId());
        }
        for (OfflinePlayer offlinePlayer : Bukkit.getOfflinePlayers()) {
            if (offlinePlayer.getName() == null || !offlinePlayer.getName().equalsIgnoreCase(targetName)) continue;
            return this.removeTrustedPlayer(owner, offlinePlayer.getUniqueId());
        }
        return false;
    }

    public boolean removeTrustedPlayer(Player owner, UUID trustedId) {
        UUID ownerId = owner.getUniqueId();
        Set<UUID> trustedSet = this.trustedPlayers.get(ownerId);
        if (trustedSet != null) {
            return trustedSet.remove(trustedId);
        }
        return false;
    }

    public Set<UUID> getTrustedPlayers(UUID ownerId) {
        return this.trustedPlayers.getOrDefault(ownerId, Collections.emptySet());
    }

    public boolean isTrusted(UUID ownerId, Player player) {
        return this.getTrustedPlayers(ownerId).contains(player.getUniqueId());
    }

    public boolean addMember(UUID ownerId, OfflinePlayer member) {
        this.claimMembers.computeIfAbsent(ownerId, k -> new HashSet()).add(member.getUniqueId());
        return true;
    }

    public boolean removeMember(UUID ownerId, OfflinePlayer member) {
        Set<UUID> members = this.claimMembers.get(ownerId);
        if (members != null) {
            return members.remove(member.getUniqueId());
        }
        return false;
    }

    public boolean isMember(UUID ownerId, Player player) {
        Set<UUID> members = this.claimMembers.get(ownerId);
        return members != null && members.contains(player.getUniqueId());
    }

    public Set<UUID> getMembers(UUID ownerId) {
        return this.claimMembers.getOrDefault(ownerId, Collections.emptySet());
    }

    public void setTrustPermission(UUID ownerId, UUID trustedId, String permission, boolean enabled) {
        Map ownerPermissions = this.trustPermissions.computeIfAbsent(ownerId, k -> new HashMap());
        Set permissions = ownerPermissions.computeIfAbsent(trustedId, k -> new HashSet());
        if (enabled) {
            permissions.add(permission);
        } else {
            permissions.remove(permission);
        }
    }

    public boolean hasTrustPermission(UUID ownerId, UUID trustedId, String permission) {
        Map<UUID, Set<String>> ownerPermissions = this.trustPermissions.get(ownerId);
        if (ownerPermissions == null) {
            return this.configManager.getDefaultTrustPermission(permission);
        }
        Set<String> permissions = ownerPermissions.get(trustedId);
        return permissions != null && permissions.contains(permission);
    }

    public void setVisitorPermission(UUID ownerId, String permission, boolean enabled) {
        Map permissions = this.visitorPermissions.computeIfAbsent(ownerId, k -> new HashMap());
        permissions.put(permission, enabled);
    }

    public boolean hasVisitorPermission(UUID ownerId, String permission) {
        Map<String, Boolean> permissions = this.visitorPermissions.get(ownerId);
        if (permissions == null) {
            return this.configManager.getDefaultVisitorPermission(permission);
        }
        return permissions.getOrDefault(permission, false);
    }

    public boolean canManageTrust(UUID ownerId, Player player) {
        return player.getUniqueId().equals(ownerId) || this.isMember(ownerId, player);
    }
}

