ServerEvents.recipes(event => {
    // remove recipes
    event.remove({ mod: 'immersive_aircraft' })
    event.remove({ mod: 'man_of_many_planes' })
    // ingridients
    let ironSheet = 'create:iron_sheet';
    let andesiteSheet = 'createdeco:andesite_sheet'
    // components
    let hull = 'immersive_aircraft:hull';
    let sail = 'immersive_aircraft:sail';
    let ironProp = 'immersive_aircraft:propeller';
    let boiler = 'immersive_aircraft:boiler';
    let advancedBoiler = 'immersive_aircraft:engine'
    // upgrades
    let brassProp = 'immersive_aircraft:enhanced_propeller';
    let gyroscope = 'immersive_aircraft:gyroscope';
    let sturdyPipes = 'immersive_aircraft:sturdy_pipes';
    let industrialGears = 'immersive_aircraft:industrial_gears';
    let reinforcedHull = 'immersive_aircraft:hull_reinforcement';
    let landingGear = 'immersive_aircraft:improved_landing_gear';
    let ironBoiler = 'immersive_aircraft:steel_boiler';
    let waterBoiler = 'immersive_aircraft:eco_engine';
    let lavaBoiler = 'immersive_aircraft:nether_engine';
    // weapons
    let bombs = 'immersive_aircraft:bomb_bay';
    let telescope = 'immersive_aircraft:telescope';
    let crossbow = 'immersive_aircraft:heavy_crossbow';
    let cannon = 'immersive_aircraft:rotary_cannon';
    // aircraft
    let gyrodyne = 'immersive_aircraft:gyrodyne';
    let quadrocopter = 'immersive_aircraft:quadrocopter';
    let airship = 'immersive_aircraft:airship';
    let cargoAirship = 'immersive_aircraft:cargo_airship';
    let warship = 'immersive_aircraft:warship';
    let biplane = 'immersive_aircraft:biplane';
    // recipes
    event.shaped(Item.of(hull), [
		' B ',
    	'BAB',
		' B '
	], {
		A: 'create:andesite_casing',
		B: andesiteSheet
	})
    event.shaped(Item.of(sail), [
        'CC',
        'CC'
    ], {
        C: 'create:white_sail'
    })
    event.shaped(Item.of(ironProp), [
        ' D ',
        'DED',
        ' D '
    ], {
        D: ironSheet,
        E: 'create:propeller'
    })
    event.shaped(Item.of(brassProp), [
        ' D ',
        'DED',
        ' D '
    ], {
        D: 'create:brass_sheet',
        E: 'create:andesite_alloy'
    })
    event.shaped(Item.of(gyroscope), [
        'FHF',
        ' G '
    ], {
        F: 'create:electron_tube',
        G: 'minecraft:compass',
        H: ironSheet
    })
    event.shaped(Item.of(sturdyPipes), [
        '  F',
        'IFI',
        'F  '
    ], {
        F: 'create:fluid_pipe',
        I: ironSheet
    })
    event.shaped(Item.of(industrialGears), [
        ' I ',
        'IGI',
        ' I '
    ], {
        I: 'createdeco:industrial_iron_sheet',
        G: ['create:gearbox', 'create:vertical_gearbox']
    })
    event.shaped(Item.of(reinforcedHull), [
        'ICI',
        'HHH',
        'ICI'
    ], {
        H: hull,
        I: 'createaddition:iron_rod',
        C: 'create:andesite_casing'

    })
    event.shaped(Item.of(landingGear), [
        ' II',
        'RRW',
        'RR '
    ], {
        R: 'kubejs:rubber',
        I: ironSheet,
        W: andesiteSheet
    })
    event.shaped(Item.of(boiler), [
        'RCR',
        'CFC',
        'RBR'
    ], {
        F: 'create:fluid_tank',
        B: 'minecraft:campfire',
        R: 'kubejs:rubber',
        C: 'create:copper_sheet'
    })
    event.shaped(Item.of(ironBoiler), [
        'III',
        'IBI',
        'RFR'
    ], {
        B: boiler,
        I: ironSheet,
        F: 'minecraft:blast_furnace',
        R: 'kubejs:rubber'
    })
    event.shaped(Item.of(advancedBoiler), [
        ' I ',
        'IBI',
        'SUS'
    ], {
        B: boiler,
        I: 'create:copper_sheet',
        S: 'kubejs:sealed_mechanism',
        U: 'create:blaze_burner'
    })
    event.shaped(Item.of(waterBoiler), [
        'WWW',
        'CAC',
        'CSC'
    ], {
        A: advancedBoiler,
        C: 'create:copper_sheet',
        W: 'minecraft:water_bucket',
        S: 'kubejs:sealed_mechanism'
    }).replaceIngredient('minecraft:water_bucket', 'minecraft:bucket')
    event.shaped(Item.of(lavaBoiler), [
        'LNL',
        'CAC',
        'CSC'
    ], {
        A: advancedBoiler,
        C: 'create:copper_sheet',
        L: 'minecraft:lava_bucket',
        S: 'kubejs:sealed_mechanism',
        N: 'minecraft:netherite_ingot'
    }).replaceIngredient('minecraft:lava_bucket', 'minecraft:bucket')
    //
    // Weapon Recipes
    event.shaped(Item.of(bombs), [
        ' A ',
        'ATA'
    ], {
        T: 'minecraft:tnt',
        A: andesiteSheet
    }).keepIngredient('minecraft:tnt')
    event.shaped(Item.of(telescope), [
        'S',
        'T'
    ], {
        S: 'minecraft:spyglass',
        T: 'create:turntable'
    })
    event.shaped(Item.of(crossbow), [
        'SCS',
        ' T '
    ], {
        C: 'minecraft:crossbow',
        T: 'create:turntable',
        S: 'minecraft:stick'
    })
    event.shaped(Item.of(cannon), [
        ' F ',
        'GPM',
        ' T '
    ], {
        G: industrialGears,
        T: 'create:turntable',
        P: 'create:mechanical_pump',
        F: 'create:fluid_pipe',
        M: 'create:precision_mechanism'
    })
    //
    // Aircraft Recipes
    event.shaped(Item.of(gyrodyne), [
        ' P ',
        'SBS',
        'HKH'
    ], {
        H: hull,
        S: sail,
        B: '#create:seats',
        P: ironProp,
        K: 'kubejs:kinetic_mechanism'
    })
    event.shaped(Item.of(quadrocopter), [
        'PCP',
        'RAR',
        'PBP'
    ], {
        A: '#create:seats',
        P: 'create:propeller',
        C: 'kubejs:calculation_mechanism',
        R: 'minecraft:stick',
        B: boiler
    })
    event.recipes.create.mechanical_crafting(Item.of(airship), [
        'SSSSS',
        ' R R ',
        ' HTBP',
        ' HHH '
    ], {
        S: sail,
        P: ironProp,
        B: boiler,
        T: '#create:seats',
        R: 'minecraft:string',
        H: hull
    })
    event.recipes.create.mechanical_crafting(Item.of(cargoAirship), [
        ' SSS ',
        'BS SB',
        ' R R ',
        'HCTAP',
        ' HHH '
    ], {
        S: sail,
        P: ironProp,
        B: boiler,
        A: advancedBoiler,
        T: '#create:seats',
        R: 'minecraft:string',
        H: hull,
        C: '#forge:chests/wooden'
    })
    event.recipes.create.mechanical_crafting(Item.of(warship), [
        ' SSSSSSS ',
        'SSA A ASS',
        ' R     R ',
        ' HECTCMAP',
        '  HHHHHH '
    ], {
        S: sail,
        P: ironProp,
        A: advancedBoiler,
        T: '#create:seats',
        R: 'minecraft:string',
        H: hull,
        C: '#forge:chests/wooden',
        M: 'kubejs:calculation_mechanism',
        E: 'create:precisioni_mechanism'
    })
    event.recipes.create.mechanical_crafting(Item.of(biplane), [
        ' S   ',
        ' S   ',
        ' S  S',
        'PATHH',
        ' S  S',
        ' S   ',
        ' S   '
    ], {
        S: sail,
        P: ironProp,
        A: advancedBoiler,
        T: '#create:seats',
        H: hull
    })
})
