ServerEvents.recipes(event => {
	// remove advanced upgrade crafting recipes
	event.remove({ output: 'sophisticatedbackpacks:advanced_pickup_upgrade' })
	event.remove({ output: 'sophisticatedbackpacks:advanced_magnet_upgrade' })
	event.remove({ output: 'sophisticatedbackpacks:advanced_feeding_upgrade' })
	event.remove({ output: 'sophisticatedbackpacks:advanced_compacting_upgrade' })
	event.remove({ output: 'sophisticatedbackpacks:advanced_void_upgrade' })
	event.remove({ output: 'sophisticatedbackpacks:advanced_restock_upgrade' })
	event.remove({ output: 'sophisticatedbackpacks:advanced_deposit_upgrade' })
	event.remove({ output: 'sophisticatedbackpacks:advanced_refill_upgrade' })
	event.remove({ output: 'sophisticatedbackpacks:advanced_tool_swapper_upgrade' })
	event.remove({ output: 'sophisticatedbackpacks:advanced_filter_upgrade' })
	event.remove({ output: 'sophisticatedbackpacks:advanced_pump_upgrade' })
	event.remove({ output: 'sophisticatedbackpacks:xp_pump_upgrade' })
	event.remove({ output: 'sophisticatedbackpacks:auto_blasting_upgrade' })
	event.remove({ output: 'sophisticatedbackpacks:auto_smelting_upgrade' })
	event.remove({ output: 'sophisticatedbackpacks:auto_smoking_upgrade' })
	event.remove({ output: 'sophisticatedbackpacks:inception_upgrade' })
	event.remove({ output: 'sophisticatedbackpacks:everlasting_upgrade' })
	event.remove({ output: 'sophisticatedbackpacks:advanced_jukebox_upgrade' })
	event.remove({ output: 'sophisticatedbackpacks:stack_upgrade_tier_4' })
	//
	// define inter as the incomplete item for advanced upgrades
	let inter = 'kubejs:incomplete_advanced_upgrade'
	//
	// define functions used to generate multiple advanced recipes using same format
    function advUpgrade(output, advUpgradeInput) {
	event.recipes.create.sequenced_assembly([
        Item.of(output).withChance(140.0),
        Item.of('minecraft:redstone_dust').withChance(6.0),
        Item.of('kubejs:golden_electron_tube').withChance(3.0),
        Item.of('minecraft:diamond').withChance(1.0)
    ], advUpgradeInput, [
        event.recipes.createCutting(inter, inter),
        event.recipes.createDeploying(inter, [inter, 'minecraft:redstone']),
        event.recipes.createPressing(inter, inter),
        event.recipes.createDeploying(inter, [inter, 'kubejs:golden_electron_tube']),
        event.recipes.createPressing(inter, inter),
        event.recipes.createDeploying(inter, [inter, 'minecraft:diamond']),
        event.recipes.createPressing(inter, inter)
    ])
    .transitionalItem(inter).loops(1)
    }
    // Now call advUpgrade outside the function
    advUpgrade('sophisticatedbackpacks:advanced_pickup_upgrade', 'sophisticatedbackpacks:pickup_upgrade')
    advUpgrade('sophisticatedbackpacks:advanced_magnet_upgrade', 'sophisticatedbackpacks:magnet_upgrade')
    advUpgrade('sophisticatedbackpacks:advanced_feeding_upgrade', 'sophisticatedbackpacks:feeding_upgrade')
    advUpgrade('sophisticatedbackpacks:advanced_compacting_upgrade', 'sophisticatedbackpacks:compacting_upgrade')
    advUpgrade('sophisticatedbackpacks:advanced_void_upgrade', 'sophisticatedbackpacks:void_upgrade')
    advUpgrade('sophisticatedbackpacks:advanced_restock_upgrade', 'sophisticatedbackpacks:restock_upgrade')
    advUpgrade('sophisticatedbackpacks:advanced_deposit_upgrade', 'sophisticatedbackpacks:deposit_upgrade')
    advUpgrade('sophisticatedbackpacks:advanced_refill_upgrade', 'sophisticatedbackpacks:refill_upgrade')
    advUpgrade('sophisticatedbackpacks:advanced_tool_swapper_upgrade', 'sophisticatedbackpacks:tool_swapper_upgrade')
    advUpgrade('sophisticatedbackpacks:advanced_jukebox_upgrade', 'sophisticatedbackpacks:jukebox_upgrade')
	//
	// advanced filter upgrade
	event.recipes.create.sequenced_assembly([
		Item.of('sophisticatedbackpacks:advanced_filter_upgrade').withChance(140.0),
        Item.of('minecraft:redstone_dust').withChance(6.0),
        Item.of('kubejs:golden_electron_tube').withChance(3.0),
        Item.of('create:gold_sheet').withChance(1.0)
	], 'sophisticatedbackpacks:filter_upgrade', [
		event.recipes.createCutting(inter, inter),
        event.recipes.createDeploying(inter, [inter, 'minecraft:redstone']),
        event.recipes.createPressing(inter, inter),
        event.recipes.createDeploying(inter, [inter, 'kubejs:golden_electron_tube']),
        event.recipes.createPressing(inter, inter)
	])
	.transitionalItem(inter).loops(1)
	//
	// advanced pump
	event.recipes.create.sequenced_assembly([
		Item.of('sophisticatedbackpacks:advanced_pump_upgrade').withChance(140.0),
		Item.of('minecraft:redstone_dust').withChance(6.0),
        Item.of('kubejs:golden_electron_tube').withChance(3.0),
        Item.of('minecraft:diamond').withChance(1.0),
        Item.of('minecraft:dispenser').withChance(1.0)
	], 'sophisticatedbackpacks:pump_upgrade', [
		event.recipes.createCutting(inter, inter),
        event.recipes.createDeploying(inter, [inter, 'minecraft:redstone']),
        event.recipes.createPressing(inter, inter),
        event.recipes.createDeploying(inter, [inter, 'kubejs:golden_electron_tube']),
        event.recipes.createPressing(inter, inter),
        event.recipes.createDeploying(inter, [inter, 'minecraft:diamond']),
        event.recipes.createPressing(inter, inter),
        event.recipes.createDeploying(inter, [inter, 'minecraft:dispenser']),
        event.recipes.createPressing(inter, inter)
	])
	.transitionalItem(inter).loops(1)
	//
	// Auto Smelting Recipes
	function autosmelt(smeltIn, smeltOut) {
	event.recipes.create.sequenced_assembly([
		Item.of(smeltOut).withChance(140.0),
		Item.of('minecraft:redstone_dust').withChance(6.0),
        Item.of('kubejs:golden_electron_tube').withChance(3.0),
        Item.of('minecraft:diamond').withChance(1.0),
        Item.of('minecraft:hopper').withChance(1.0)
	], smeltIn, [
        event.recipes.createCutting(inter, inter),
        event.recipes.createDeploying(inter, [inter, 'minecraft:redstone']),
        event.recipes.createPressing(inter, inter),
        event.recipes.createDeploying(inter, [inter, 'kubejs:golden_electron_tube']),
        event.recipes.createPressing(inter, inter),
        event.recipes.createDeploying(inter, [inter, 'minecraft:diamond']),
        event.recipes.createPressing(inter, inter),
        event.recipes.createDeploying(inter, [inter, 'minecraft:hopper']),
        event.recipes.createPressing(inter, inter)
    ])
	.transitionalItem(inter).loops(1)
	}
	// Now call autosmelt outside the function
	autosmelt('sophisticatedbackpacks:smelting_upgrade', 'sophisticatedbackpacks:auto_smelting_upgrade')
	autosmelt('sophisticatedbackpacks:blasting_upgrade', 'sophisticatedbackpacks:auto_blasting_upgrade')
	autosmelt('sophisticatedbackpacks:smoking_upgrade', 'sophisticatedbackpacks:auto_smoking_upgrade')
	//
	// xp pump upgrade
	event.recipes.create.sequenced_assembly([
		Item.of('sophisticatedbackpacks:xp_pump_upgrade').withChance(140.0),
		Item.of('minecraft:redstone_dust').withChance(4.0),
        Item.of('minecraft:ender_eye').withChance(2.0),
		Item.of('sophisticatedbackpacks:advanced_pump_upgrade').withChance(1.0)
	], 'sophisticatedbackpacks:advanced_pump_upgrade', [
		event.recipes.createCutting(inter, inter),
        event.recipes.createDeploying(inter, [inter, 'minecraft:redstone']),
        event.recipes.createPressing(inter, inter),
        event.recipes.createDeploying(inter, [inter, 'minecraft:ender_eye']),
		event.recipes.createFilling(inter, [inter, Fluid.of('create_enchantment_industry:experience', 100)]),
        event.recipes.createPressing(inter, inter)
	])
	.transitionalItem('kubejs:incomplete_xp_upgrade').loops(1)
	//
	// recipe for the basic upgrade template
	let iub = 'kubejs:incomplete_upgrade_base' // define the transitional item as iub
	event.recipes.create.sequenced_assembly([
		Item.of('sophisticatedbackpacks:upgrade_base').withChance(150.0), // this is the item that will appear in JEI as the result
		Item.of('create:iron_sheet').withChance(6.0), // the rest of these items will be part of the scrap
		Item.of('minecraft:leather').withChance(6.0),
		Item.of('minecraft:string').withChance(4.0),
		Item.of('minecraft:iron_ingot').withChance(2.0),
		Item.of('2x minecraft:iron_ingot').withChance(2.0)
	], 'minecraft:leather', [
		event.recipes.createDeploying(iub, [iub, 'minecraft:string']),
		event.recipes.createDeploying(iub, [iub, 'minecraft:iron_ingot']),
		event.recipes.createPressing(iub, iub)
	])
	.transitionalItem(iub).loops(2) // set the transitional item and the number of loops
	//
	// deploying recipe for the tank upgrade
	event.recipes.create.deploying('sophisticatedbackpacks:tank_upgrade', ['sophisticatedbackpacks:upgrade_base', 'create:fluid_tank'])
	//
	// mechanical crafting recipe for remaining upgrades
	// inception upgrade
	event.recipes.create.mechanical_crafting('sophisticatedbackpacks:inception_upgrade', [
		'  D  ',
		' ESE ',
		'DNUND',
		' ENE ',
		'  D  '
	], {
		U: 'sophisticatedbackpacks:upgrade_base',
		D: 'minecraft:diamond',
		E: 'minecraft:ender_eye',
		S: 'minecraft:nether_star',
		N: 'kubejs:copper_enchanting_tube'
	})
	//
	// everlasting upgrade
	event.recipes.create.mechanical_crafting('sophisticatedbackpacks:everlasting_upgrade', [
		'  S  ',
		' ENE ',
		'SNUNS',
		' ENE ',
		'  S  '
	], {
		U: 'sophisticatedbackpacks:upgrade_base',
		E: 'minecraft:end_crystal',
		S: 'minecraft:nether_star',
		N: 'kubejs:copper_enchanting_tube'
	})
	//
	// netherite stack upgrade
	event.recipes.create.mechanical_crafting('sophisticatedbackpacks:stack_upgrade_tier_4', [
		' N ',
		'NUN',
		' N '
	], {
		N: 'minecraft:netherite_block',
		U: 'sophisticatedbackpacks:stack_upgrade_tier_3'
	})
	//
	// post in log stating the recipes have been fired
	console.log('Hello! The advanced recipe event has fired!')
})
