ServerEvents.recipes(event => {
    let moltenBrass = 'molten_metals:molten_brass';
    let moltenCopper = 'molten_metals:molten_copper';
    let moltenGold = 'molten_metals:molten_gold';
    let moltenIron = 'molten_metals:molten_iron';
    let moltenNetherite = 'molten_metals:molten_netherite';
    let moltenZinc = 'molten_metals:molten_zinc';
    let rawCopper = 'minecraft:raw_copper';
    let rawGold = 'minecraft:raw_gold';
    let rawIron = 'minecraft:raw_iron';
    let rawZinc = 'create:raw_zinc';
    let rawCopperBlock = 'minecraft:raw_copper_block';
    let rawGoldBlock = 'minecraft:raw_gold_block';
    let rawIronBlock = 'minecraft:raw_iron_block';
    let rawZincBlock = 'create:raw_zinc_block';
    let slag = 'molten_metals:slag';
    let slagBlock = 'molten_metals:slag_block';
    let netheriteScrap = 'minecraft:netherite_scrap'
    let ingotBrass = 'create:brass_ingot';
    let ingotCopper = 'minecraft:copper_ingot';
    let ingotGold = 'minecraft:gold_ingot';
    let ingotIron = 'minecraft:iron_ingot';
    let ingotZinc = 'create:zinc_ingot';
    let ingotNetherite = 'minecraft:netherite_ingot';
    let nuggetBrass = 'create:brass_nugget';
    let nuggetCopper = 'create:copper_nugget';
    let nuggetGold = 'minecraft:gold_nugget';
    let nuggetIron = 'minecraft:iron_nugget';
    let nuggetZinc = 'create:zinc_nugget';
    let nuggetNetherite = 'createdeco:netherite_nugget';
    // removing the mixing recipes added by the mod
    event.remove({type: 'create:mixing', mod: 'molten_metals' })
    
    // adding recipes with extra outputs for ores
    function rawOres(input, output) {
        event.recipes.create.mixing([slag, Fluid.of(output, 216)], input).superheated()
    }
    rawOres(rawCopper, moltenCopper)
    rawOres(rawGold, moltenGold)
    rawOres(rawIron, moltenIron)
    rawOres(rawZinc, moltenZinc)

    function rawOresBlock(inputBlock, outputBlock) {
        event.recipes.create.mixing([slagBlock, Fluid.of(outputBlock, 1944)], inputBlock).superheated()
    }
    rawOresBlock(rawCopperBlock, moltenCopper)
    rawOresBlock(rawGoldBlock, moltenGold)
    rawOresBlock(rawIronBlock, moltenIron)
    rawOresBlock(rawZincBlock, moltenZinc)

    event.recipes.create.mixing([`4x ${slag}`, Fluid.of(moltenNetherite, 216)], [Fluid.of(moltenGold, 576), `4x ${netheriteScrap}`]).superheated()
    
    // alloying brass
    event.recipes.create.mixing([Fluid.of(moltenBrass, 288)], [Fluid.of(moltenCopper, 144), Fluid.of(moltenZinc, 144)]).superheated()
    // melting down ingots into molten metals
    function meltingIngots(inputingot, outputfluid) {
        event.recipes.create.mixing([Fluid.of(outputfluid, 144)], inputingot).superheated()
    }
    meltingIngots(ingotBrass, moltenBrass)
    meltingIngots(ingotCopper, moltenCopper)
    meltingIngots(ingotGold, moltenGold)
    meltingIngots(ingotIron, moltenIron)
    meltingIngots(ingotZinc, moltenZinc)
    meltingIngots(ingotNetherite, moltenNetherite)

    // melting down nuggets into molten metals
    function meltingNuggets(inputnugget, outputfluid) {
        event.recipes.create.mixing([Fluid.of(outputfluid, 16)], inputnugget).superheated()
    }
    meltingNuggets(nuggetBrass, moltenBrass)
    meltingNuggets(nuggetCopper, moltenCopper)
    meltingNuggets(nuggetGold, moltenGold)
    meltingNuggets(nuggetIron, moltenIron)
    meltingNuggets(nuggetZinc, moltenZinc)
    meltingNuggets(nuggetNetherite, moltenNetherite)
})
