/*
 * Decompiled with CFR 0.152.
 */
package net.skart.skd.block;

import io.netty.buffer.Unpooled;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.util.RandomSource;
import net.minecraft.world.Container;
import net.minecraft.world.Containers;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.ScheduledTickAccess;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.EntityBlock;
import net.minecraft.world.level.block.HorizontalDirectionalBlock;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.SimpleWaterloggedBlock;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.level.material.MapColor;
import net.minecraft.world.level.redstone.Orientation;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.skart.skd.Placement;
import net.skart.skd.block.entity.MagentaDumpsterBlockEntity;
import net.skart.skd.procedures.DumpsterGuiOpenProcedure;
import net.skart.skd.procedures.DumpsterPlacedProcedure;
import net.skart.skd.procedures.DumpsterUpdateProcedure;
import net.skart.skd.world.inventory.BinGUIMenu;

public class MagentaDumpsterBlock
extends Block
implements SimpleWaterloggedBlock,
EntityBlock {
    public static final EnumProperty<Direction> FACING = HorizontalDirectionalBlock.FACING;
    public static final BooleanProperty WATERLOGGED = BlockStateProperties.WATERLOGGED;
    public static final EnumProperty PLACEMENT = EnumProperty.create((String)"placement", Placement.class);

    public MagentaDumpsterBlock(BlockBehaviour.Properties properties) {
        super(properties.mapColor(MapColor.METAL).sound(SoundType.METAL).strength(4.0f, 5.0f).requiresCorrectToolForDrops().noOcclusion().isRedstoneConductor((bs, br, bp) -> false));
        this.registerDefaultState((BlockState)((BlockState)((BlockState)((BlockState)this.stateDefinition.any()).setValue(FACING, (Comparable)Direction.NORTH)).setValue((Property)WATERLOGGED, (Comparable)Boolean.valueOf(false))).setValue((Property)PLACEMENT, (Comparable)((Object)Placement.BMF)));
    }

    public boolean propagatesSkylightDown(BlockState state) {
        return state.getFluidState().isEmpty();
    }

    public int getLightBlock(BlockState state) {
        return 0;
    }

    public VoxelShape getVisualShape(BlockState state, BlockGetter world, BlockPos pos, CollisionContext context) {
        return Shapes.empty();
    }

    public VoxelShape getShape(BlockState state, BlockGetter world, BlockPos pos, CollisionContext context) {
        return switch ((Direction)state.getValue(FACING)) {
            default -> {
                if (state.getValue((Property)PLACEMENT) == Placement.BLF) {
                    yield Shapes.or((VoxelShape)MagentaDumpsterBlock.box((double)0.0, (double)3.0, (double)0.0, (double)13.0, (double)16.0, (double)14.0), (VoxelShape)MagentaDumpsterBlock.box((double)9.0, (double)0.0, (double)9.0, (double)11.0, (double)3.0, (double)12.0));
                }
                if (state.getValue((Property)PLACEMENT) == Placement.BMF) {
                    yield MagentaDumpsterBlock.box((double)0.0, (double)3.0, (double)0.0, (double)16.0, (double)16.0, (double)14.0);
                }
                if (state.getValue((Property)PLACEMENT) == Placement.BRF) {
                    yield Shapes.or((VoxelShape)MagentaDumpsterBlock.box((double)3.0, (double)3.0, (double)0.0, (double)16.0, (double)16.0, (double)14.0), (VoxelShape)MagentaDumpsterBlock.box((double)5.0, (double)0.0, (double)9.0, (double)7.0, (double)3.0, (double)12.0));
                }
                if (state.getValue((Property)PLACEMENT) == Placement.BLB) {
                    yield Shapes.or((VoxelShape)MagentaDumpsterBlock.box((double)0.0, (double)3.0, (double)2.0, (double)13.0, (double)16.0, (double)16.0), (VoxelShape)MagentaDumpsterBlock.box((double)9.0, (double)0.0, (double)4.0, (double)11.0, (double)3.0, (double)7.0));
                }
                if (state.getValue((Property)PLACEMENT) == Placement.BMB) {
                    yield MagentaDumpsterBlock.box((double)0.0, (double)3.0, (double)2.0, (double)16.0, (double)16.0, (double)16.0);
                }
                if (state.getValue((Property)PLACEMENT) == Placement.BRB) {
                    yield Shapes.or((VoxelShape)MagentaDumpsterBlock.box((double)3.0, (double)3.0, (double)2.0, (double)16.0, (double)16.0, (double)16.0), (VoxelShape)MagentaDumpsterBlock.box((double)5.0, (double)0.0, (double)4.0, (double)7.0, (double)3.0, (double)7.0));
                }
                if (state.getValue((Property)PLACEMENT) == Placement.TLF) {
                    yield Shapes.or((VoxelShape)MagentaDumpsterBlock.box((double)0.0, (double)0.0, (double)0.0, (double)13.0, (double)5.0, (double)14.0), (VoxelShape[])new VoxelShape[]{MagentaDumpsterBlock.box((double)0.0, (double)5.0, (double)0.0, (double)14.0, (double)16.0, (double)16.0), MagentaDumpsterBlock.box((double)13.0, (double)0.0, (double)0.0, (double)16.0, (double)4.0, (double)14.0)});
                }
                if (state.getValue((Property)PLACEMENT) == Placement.TMF) {
                    yield Shapes.or((VoxelShape)MagentaDumpsterBlock.box((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)5.0, (double)14.0), (VoxelShape)MagentaDumpsterBlock.box((double)0.0, (double)5.0, (double)0.0, (double)16.0, (double)16.0, (double)16.0));
                }
                if (state.getValue((Property)PLACEMENT) == Placement.TRF) {
                    yield Shapes.or((VoxelShape)MagentaDumpsterBlock.box((double)3.0, (double)0.0, (double)0.0, (double)16.0, (double)5.0, (double)14.0), (VoxelShape[])new VoxelShape[]{MagentaDumpsterBlock.box((double)0.0, (double)0.0, (double)0.0, (double)3.0, (double)4.0, (double)14.0), MagentaDumpsterBlock.box((double)2.0, (double)5.0, (double)0.0, (double)16.0, (double)16.0, (double)16.0)});
                }
                if (state.getValue((Property)PLACEMENT) == Placement.TLB) {
                    yield Shapes.or((VoxelShape)MagentaDumpsterBlock.box((double)0.0, (double)0.0, (double)2.0, (double)13.0, (double)16.0, (double)16.0), (VoxelShape[])new VoxelShape[]{MagentaDumpsterBlock.box((double)0.0, (double)11.0, (double)1.0, (double)14.0, (double)14.0, (double)16.0), MagentaDumpsterBlock.box((double)13.0, (double)0.0, (double)2.0, (double)16.0, (double)4.0, (double)16.0)});
                }
                if (state.getValue((Property)PLACEMENT) == Placement.TMB) {
                    yield Shapes.or((VoxelShape)MagentaDumpsterBlock.box((double)0.0, (double)0.0, (double)2.0, (double)16.0, (double)16.0, (double)16.0), (VoxelShape)MagentaDumpsterBlock.box((double)0.0, (double)11.0, (double)1.0, (double)16.0, (double)14.0, (double)2.0));
                }
                if (state.getValue((Property)PLACEMENT) == Placement.TRB) {
                    yield Shapes.or((VoxelShape)MagentaDumpsterBlock.box((double)3.0, (double)0.0, (double)2.0, (double)16.0, (double)16.0, (double)16.0), (VoxelShape[])new VoxelShape[]{MagentaDumpsterBlock.box((double)2.0, (double)11.0, (double)1.0, (double)16.0, (double)14.0, (double)16.0), MagentaDumpsterBlock.box((double)0.0, (double)0.0, (double)2.0, (double)3.0, (double)4.0, (double)16.0)});
                }
                yield null;
            }
            case Direction.NORTH -> {
                if (state.getValue((Property)PLACEMENT) == Placement.BLF) {
                    yield Shapes.or((VoxelShape)MagentaDumpsterBlock.box((double)3.0, (double)3.0, (double)2.0, (double)16.0, (double)16.0, (double)16.0), (VoxelShape)MagentaDumpsterBlock.box((double)5.0, (double)0.0, (double)4.0, (double)7.0, (double)3.0, (double)7.0));
                }
                if (state.getValue((Property)PLACEMENT) == Placement.BMF) {
                    yield MagentaDumpsterBlock.box((double)0.0, (double)3.0, (double)2.0, (double)16.0, (double)16.0, (double)16.0);
                }
                if (state.getValue((Property)PLACEMENT) == Placement.BRF) {
                    yield Shapes.or((VoxelShape)MagentaDumpsterBlock.box((double)0.0, (double)3.0, (double)2.0, (double)13.0, (double)16.0, (double)16.0), (VoxelShape)MagentaDumpsterBlock.box((double)9.0, (double)0.0, (double)4.0, (double)11.0, (double)3.0, (double)7.0));
                }
                if (state.getValue((Property)PLACEMENT) == Placement.BLB) {
                    yield Shapes.or((VoxelShape)MagentaDumpsterBlock.box((double)3.0, (double)3.0, (double)0.0, (double)16.0, (double)16.0, (double)14.0), (VoxelShape)MagentaDumpsterBlock.box((double)5.0, (double)0.0, (double)9.0, (double)7.0, (double)3.0, (double)12.0));
                }
                if (state.getValue((Property)PLACEMENT) == Placement.BMB) {
                    yield MagentaDumpsterBlock.box((double)0.0, (double)3.0, (double)0.0, (double)16.0, (double)16.0, (double)14.0);
                }
                if (state.getValue((Property)PLACEMENT) == Placement.BRB) {
                    yield Shapes.or((VoxelShape)MagentaDumpsterBlock.box((double)0.0, (double)3.0, (double)0.0, (double)13.0, (double)16.0, (double)14.0), (VoxelShape)MagentaDumpsterBlock.box((double)9.0, (double)0.0, (double)9.0, (double)11.0, (double)3.0, (double)12.0));
                }
                if (state.getValue((Property)PLACEMENT) == Placement.TLF) {
                    yield Shapes.or((VoxelShape)MagentaDumpsterBlock.box((double)3.0, (double)0.0, (double)2.0, (double)16.0, (double)5.0, (double)16.0), (VoxelShape[])new VoxelShape[]{MagentaDumpsterBlock.box((double)2.0, (double)5.0, (double)0.0, (double)16.0, (double)16.0, (double)16.0), MagentaDumpsterBlock.box((double)0.0, (double)0.0, (double)2.0, (double)3.0, (double)4.0, (double)16.0)});
                }
                if (state.getValue((Property)PLACEMENT) == Placement.TMF) {
                    yield Shapes.or((VoxelShape)MagentaDumpsterBlock.box((double)0.0, (double)0.0, (double)2.0, (double)16.0, (double)5.0, (double)16.0), (VoxelShape)MagentaDumpsterBlock.box((double)0.0, (double)5.0, (double)0.0, (double)16.0, (double)16.0, (double)16.0));
                }
                if (state.getValue((Property)PLACEMENT) == Placement.TRF) {
                    yield Shapes.or((VoxelShape)MagentaDumpsterBlock.box((double)0.0, (double)0.0, (double)2.0, (double)13.0, (double)5.0, (double)16.0), (VoxelShape[])new VoxelShape[]{MagentaDumpsterBlock.box((double)13.0, (double)0.0, (double)2.0, (double)16.0, (double)4.0, (double)16.0), MagentaDumpsterBlock.box((double)0.0, (double)5.0, (double)0.0, (double)14.0, (double)16.0, (double)16.0)});
                }
                if (state.getValue((Property)PLACEMENT) == Placement.TLB) {
                    yield Shapes.or((VoxelShape)MagentaDumpsterBlock.box((double)3.0, (double)0.0, (double)0.0, (double)16.0, (double)16.0, (double)14.0), (VoxelShape[])new VoxelShape[]{MagentaDumpsterBlock.box((double)2.0, (double)11.0, (double)0.0, (double)16.0, (double)14.0, (double)15.0), MagentaDumpsterBlock.box((double)0.0, (double)0.0, (double)0.0, (double)3.0, (double)4.0, (double)14.0)});
                }
                if (state.getValue((Property)PLACEMENT) == Placement.TMB) {
                    yield Shapes.or((VoxelShape)MagentaDumpsterBlock.box((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)16.0, (double)14.0), (VoxelShape)MagentaDumpsterBlock.box((double)0.0, (double)11.0, (double)14.0, (double)16.0, (double)14.0, (double)15.0));
                }
                if (state.getValue((Property)PLACEMENT) == Placement.TRB) {
                    yield Shapes.or((VoxelShape)MagentaDumpsterBlock.box((double)0.0, (double)0.0, (double)0.0, (double)13.0, (double)16.0, (double)14.0), (VoxelShape[])new VoxelShape[]{MagentaDumpsterBlock.box((double)0.0, (double)11.0, (double)0.0, (double)14.0, (double)14.0, (double)15.0), MagentaDumpsterBlock.box((double)13.0, (double)0.0, (double)0.0, (double)16.0, (double)4.0, (double)14.0)});
                }
                yield null;
            }
            case Direction.EAST -> {
                if (state.getValue((Property)PLACEMENT) == Placement.BLF) {
                    yield Shapes.or((VoxelShape)MagentaDumpsterBlock.box((double)0.0, (double)3.0, (double)3.0, (double)14.0, (double)16.0, (double)16.0), (VoxelShape)MagentaDumpsterBlock.box((double)9.0, (double)0.0, (double)5.0, (double)12.0, (double)3.0, (double)7.0));
                }
                if (state.getValue((Property)PLACEMENT) == Placement.BMF) {
                    yield MagentaDumpsterBlock.box((double)0.0, (double)3.0, (double)0.0, (double)14.0, (double)16.0, (double)16.0);
                }
                if (state.getValue((Property)PLACEMENT) == Placement.BRF) {
                    yield Shapes.or((VoxelShape)MagentaDumpsterBlock.box((double)0.0, (double)3.0, (double)0.0, (double)14.0, (double)16.0, (double)13.0), (VoxelShape)MagentaDumpsterBlock.box((double)9.0, (double)0.0, (double)9.0, (double)12.0, (double)3.0, (double)11.0));
                }
                if (state.getValue((Property)PLACEMENT) == Placement.BLB) {
                    yield Shapes.or((VoxelShape)MagentaDumpsterBlock.box((double)2.0, (double)3.0, (double)3.0, (double)16.0, (double)16.0, (double)16.0), (VoxelShape)MagentaDumpsterBlock.box((double)4.0, (double)0.0, (double)5.0, (double)7.0, (double)3.0, (double)7.0));
                }
                if (state.getValue((Property)PLACEMENT) == Placement.BMB) {
                    yield MagentaDumpsterBlock.box((double)2.0, (double)3.0, (double)0.0, (double)16.0, (double)16.0, (double)16.0);
                }
                if (state.getValue((Property)PLACEMENT) == Placement.BRB) {
                    yield Shapes.or((VoxelShape)MagentaDumpsterBlock.box((double)2.0, (double)3.0, (double)0.0, (double)16.0, (double)16.0, (double)13.0), (VoxelShape)MagentaDumpsterBlock.box((double)4.0, (double)0.0, (double)9.0, (double)7.0, (double)3.0, (double)11.0));
                }
                if (state.getValue((Property)PLACEMENT) == Placement.TLF) {
                    yield Shapes.or((VoxelShape)MagentaDumpsterBlock.box((double)0.0, (double)0.0, (double)3.0, (double)14.0, (double)5.0, (double)16.0), (VoxelShape[])new VoxelShape[]{MagentaDumpsterBlock.box((double)0.0, (double)5.0, (double)2.0, (double)16.0, (double)16.0, (double)16.0), MagentaDumpsterBlock.box((double)0.0, (double)0.0, (double)0.0, (double)14.0, (double)4.0, (double)3.0)});
                }
                if (state.getValue((Property)PLACEMENT) == Placement.TMF) {
                    yield Shapes.or((VoxelShape)MagentaDumpsterBlock.box((double)0.0, (double)0.0, (double)0.0, (double)14.0, (double)5.0, (double)16.0), (VoxelShape)MagentaDumpsterBlock.box((double)0.0, (double)5.0, (double)0.0, (double)16.0, (double)16.0, (double)16.0));
                }
                if (state.getValue((Property)PLACEMENT) == Placement.TRF) {
                    yield Shapes.or((VoxelShape)MagentaDumpsterBlock.box((double)0.0, (double)0.0, (double)0.0, (double)14.0, (double)5.0, (double)13.0), (VoxelShape[])new VoxelShape[]{MagentaDumpsterBlock.box((double)0.0, (double)0.0, (double)13.0, (double)14.0, (double)4.0, (double)16.0), MagentaDumpsterBlock.box((double)0.0, (double)5.0, (double)0.0, (double)16.0, (double)16.0, (double)14.0)});
                }
                if (state.getValue((Property)PLACEMENT) == Placement.TLB) {
                    yield Shapes.or((VoxelShape)MagentaDumpsterBlock.box((double)2.0, (double)0.0, (double)3.0, (double)16.0, (double)16.0, (double)16.0), (VoxelShape[])new VoxelShape[]{MagentaDumpsterBlock.box((double)1.0, (double)11.0, (double)2.0, (double)16.0, (double)14.0, (double)16.0), MagentaDumpsterBlock.box((double)2.0, (double)0.0, (double)0.0, (double)16.0, (double)4.0, (double)3.0)});
                }
                if (state.getValue((Property)PLACEMENT) == Placement.TMB) {
                    yield Shapes.or((VoxelShape)MagentaDumpsterBlock.box((double)2.0, (double)0.0, (double)0.0, (double)16.0, (double)16.0, (double)16.0), (VoxelShape)MagentaDumpsterBlock.box((double)1.0, (double)11.0, (double)0.0, (double)2.0, (double)14.0, (double)16.0));
                }
                if (state.getValue((Property)PLACEMENT) == Placement.TRB) {
                    yield Shapes.or((VoxelShape)MagentaDumpsterBlock.box((double)2.0, (double)0.0, (double)0.0, (double)16.0, (double)16.0, (double)13.0), (VoxelShape[])new VoxelShape[]{MagentaDumpsterBlock.box((double)1.0, (double)11.0, (double)0.0, (double)16.0, (double)14.0, (double)14.0), MagentaDumpsterBlock.box((double)2.0, (double)0.0, (double)13.0, (double)16.0, (double)4.0, (double)16.0)});
                }
                yield null;
            }
            case Direction.WEST -> state.getValue((Property)PLACEMENT) == Placement.BLF ? Shapes.or((VoxelShape)MagentaDumpsterBlock.box((double)2.0, (double)3.0, (double)0.0, (double)16.0, (double)16.0, (double)13.0), (VoxelShape)MagentaDumpsterBlock.box((double)4.0, (double)0.0, (double)9.0, (double)7.0, (double)3.0, (double)11.0)) : (state.getValue((Property)PLACEMENT) == Placement.BMF ? MagentaDumpsterBlock.box((double)2.0, (double)3.0, (double)0.0, (double)16.0, (double)16.0, (double)16.0) : (state.getValue((Property)PLACEMENT) == Placement.BRF ? Shapes.or((VoxelShape)MagentaDumpsterBlock.box((double)2.0, (double)3.0, (double)3.0, (double)16.0, (double)16.0, (double)16.0), (VoxelShape)MagentaDumpsterBlock.box((double)4.0, (double)0.0, (double)5.0, (double)7.0, (double)3.0, (double)7.0)) : (state.getValue((Property)PLACEMENT) == Placement.BLB ? Shapes.or((VoxelShape)MagentaDumpsterBlock.box((double)0.0, (double)3.0, (double)0.0, (double)14.0, (double)16.0, (double)13.0), (VoxelShape)MagentaDumpsterBlock.box((double)9.0, (double)0.0, (double)9.0, (double)12.0, (double)3.0, (double)11.0)) : (state.getValue((Property)PLACEMENT) == Placement.BMB ? MagentaDumpsterBlock.box((double)0.0, (double)3.0, (double)0.0, (double)14.0, (double)16.0, (double)16.0) : (state.getValue((Property)PLACEMENT) == Placement.BRB ? Shapes.or((VoxelShape)MagentaDumpsterBlock.box((double)0.0, (double)3.0, (double)3.0, (double)14.0, (double)16.0, (double)16.0), (VoxelShape)MagentaDumpsterBlock.box((double)9.0, (double)0.0, (double)5.0, (double)12.0, (double)3.0, (double)7.0)) : (state.getValue((Property)PLACEMENT) == Placement.TLF ? Shapes.or((VoxelShape)MagentaDumpsterBlock.box((double)2.0, (double)0.0, (double)0.0, (double)16.0, (double)5.0, (double)13.0), (VoxelShape[])new VoxelShape[]{MagentaDumpsterBlock.box((double)0.0, (double)5.0, (double)0.0, (double)16.0, (double)16.0, (double)14.0), MagentaDumpsterBlock.box((double)2.0, (double)0.0, (double)13.0, (double)16.0, (double)4.0, (double)16.0)}) : (state.getValue((Property)PLACEMENT) == Placement.TMF ? Shapes.or((VoxelShape)MagentaDumpsterBlock.box((double)2.0, (double)0.0, (double)0.0, (double)16.0, (double)5.0, (double)16.0), (VoxelShape)MagentaDumpsterBlock.box((double)0.0, (double)5.0, (double)0.0, (double)16.0, (double)16.0, (double)16.0)) : (state.getValue((Property)PLACEMENT) == Placement.TRF ? Shapes.or((VoxelShape)MagentaDumpsterBlock.box((double)2.0, (double)0.0, (double)3.0, (double)16.0, (double)5.0, (double)16.0), (VoxelShape[])new VoxelShape[]{MagentaDumpsterBlock.box((double)2.0, (double)0.0, (double)0.0, (double)16.0, (double)4.0, (double)3.0), MagentaDumpsterBlock.box((double)0.0, (double)5.0, (double)2.0, (double)16.0, (double)16.0, (double)16.0)}) : (state.getValue((Property)PLACEMENT) == Placement.TLB ? Shapes.or((VoxelShape)MagentaDumpsterBlock.box((double)0.0, (double)0.0, (double)0.0, (double)14.0, (double)16.0, (double)13.0), (VoxelShape[])new VoxelShape[]{MagentaDumpsterBlock.box((double)0.0, (double)11.0, (double)0.0, (double)15.0, (double)14.0, (double)14.0), MagentaDumpsterBlock.box((double)0.0, (double)0.0, (double)13.0, (double)14.0, (double)4.0, (double)16.0)}) : (state.getValue((Property)PLACEMENT) == Placement.TMB ? Shapes.or((VoxelShape)MagentaDumpsterBlock.box((double)0.0, (double)0.0, (double)0.0, (double)14.0, (double)16.0, (double)16.0), (VoxelShape)MagentaDumpsterBlock.box((double)14.0, (double)11.0, (double)0.0, (double)15.0, (double)14.0, (double)16.0)) : (state.getValue((Property)PLACEMENT) == Placement.TRB ? Shapes.or((VoxelShape)MagentaDumpsterBlock.box((double)0.0, (double)0.0, (double)3.0, (double)14.0, (double)16.0, (double)16.0), (VoxelShape[])new VoxelShape[]{MagentaDumpsterBlock.box((double)0.0, (double)11.0, (double)2.0, (double)15.0, (double)14.0, (double)16.0), MagentaDumpsterBlock.box((double)0.0, (double)0.0, (double)0.0, (double)14.0, (double)4.0, (double)3.0)}) : null)))))))))));
        };
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        builder.add(new Property[]{FACING, WATERLOGGED, PLACEMENT});
    }

    public BlockState getStateForPlacement(BlockPlaceContext context) {
        boolean flag = context.getLevel().getFluidState(context.getClickedPos()).getType() == Fluids.WATER;
        return (BlockState)((BlockState)super.getStateForPlacement(context).setValue(FACING, (Comparable)context.getHorizontalDirection().getOpposite())).setValue((Property)WATERLOGGED, (Comparable)Boolean.valueOf(flag));
    }

    public BlockState rotate(BlockState state, Rotation rot) {
        return (BlockState)state.setValue(FACING, (Comparable)rot.rotate((Direction)state.getValue(FACING)));
    }

    public BlockState mirror(BlockState state, Mirror mirrorIn) {
        return state.rotate(mirrorIn.getRotation((Direction)state.getValue(FACING)));
    }

    public FluidState getFluidState(BlockState state) {
        return (Boolean)state.getValue((Property)WATERLOGGED) != false ? Fluids.WATER.getSource(false) : super.getFluidState(state);
    }

    public BlockState updateShape(BlockState state, LevelReader world, ScheduledTickAccess scheduledTickAccess, BlockPos currentPos, Direction facing, BlockPos facingPos, BlockState facingState, RandomSource random) {
        if (((Boolean)state.getValue((Property)WATERLOGGED)).booleanValue()) {
            scheduledTickAccess.scheduleTick(currentPos, (Fluid)Fluids.WATER, Fluids.WATER.getTickDelay(world));
        }
        return super.updateShape(state, world, scheduledTickAccess, currentPos, facing, facingPos, facingState, random);
    }

    public void neighborChanged(BlockState blockstate, Level world, BlockPos pos, Block neighborBlock, @Nullable Orientation orientation, boolean moving) {
        super.neighborChanged(blockstate, world, pos, neighborBlock, orientation, moving);
        DumpsterUpdateProcedure.execute((LevelAccessor)world, pos.getX(), pos.getY(), pos.getZ());
    }

    public void setPlacedBy(Level world, BlockPos pos, BlockState blockstate, LivingEntity entity, ItemStack itemstack) {
        super.setPlacedBy(world, pos, blockstate, entity, itemstack);
        DumpsterPlacedProcedure.execute((LevelAccessor)world, pos.getX(), pos.getY(), pos.getZ(), (Entity)entity);
    }

    public InteractionResult useWithoutItem(BlockState blockstate, Level world, final BlockPos pos, Player entity, BlockHitResult hit) {
        super.useWithoutItem(blockstate, world, pos, entity, hit);
        if (entity instanceof ServerPlayer) {
            ServerPlayer player = (ServerPlayer)entity;
            player.openMenu(new MenuProvider(){

                public Component getDisplayName() {
                    return Component.literal((String)"Magenta Dumpster");
                }

                public AbstractContainerMenu createMenu(int id, Inventory inventory, Player player) {
                    return new BinGUIMenu(id, inventory, new FriendlyByteBuf(Unpooled.buffer()).writeBlockPos(pos));
                }
            }, pos);
        }
        int x = pos.getX();
        int y = pos.getY();
        int z = pos.getZ();
        double hitX = hit.getLocation().x;
        double hitY = hit.getLocation().y;
        double hitZ = hit.getLocation().z;
        Direction direction = hit.getDirection();
        DumpsterGuiOpenProcedure.execute((LevelAccessor)world, x, y, z, (Entity)entity);
        return InteractionResult.SUCCESS;
    }

    public MenuProvider getMenuProvider(BlockState state, Level worldIn, BlockPos pos) {
        MenuProvider menuProvider;
        BlockEntity tileEntity = worldIn.getBlockEntity(pos);
        return tileEntity instanceof MenuProvider ? (menuProvider = (MenuProvider)tileEntity) : null;
    }

    public BlockEntity newBlockEntity(BlockPos pos, BlockState state) {
        return new MagentaDumpsterBlockEntity(pos, state);
    }

    public boolean triggerEvent(BlockState state, Level world, BlockPos pos, int eventID, int eventParam) {
        super.triggerEvent(state, world, pos, eventID, eventParam);
        BlockEntity blockEntity = world.getBlockEntity(pos);
        return blockEntity != null && blockEntity.triggerEvent(eventID, eventParam);
    }

    protected void affectNeighborsAfterRemoval(BlockState blockstate, ServerLevel world, BlockPos blockpos, boolean flag) {
        Containers.updateNeighboursAfterDestroy((BlockState)blockstate, (Level)world, (BlockPos)blockpos);
    }

    public boolean hasAnalogOutputSignal(BlockState state) {
        return true;
    }

    public int getAnalogOutputSignal(BlockState blockState, Level world, BlockPos pos) {
        BlockEntity tileentity = world.getBlockEntity(pos);
        if (tileentity instanceof MagentaDumpsterBlockEntity) {
            MagentaDumpsterBlockEntity be = (MagentaDumpsterBlockEntity)tileentity;
            return AbstractContainerMenu.getRedstoneSignalFromContainer((Container)be);
        }
        return 0;
    }
}

