/*
 * Decompiled with CFR 0.152.
 */
package net.skart.skd.block;

import io.netty.buffer.Unpooled;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.util.RandomSource;
import net.minecraft.world.Container;
import net.minecraft.world.Containers;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.ScheduledTickAccess;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.EntityBlock;
import net.minecraft.world.level.block.HorizontalDirectionalBlock;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.SimpleWaterloggedBlock;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.level.material.MapColor;
import net.minecraft.world.level.redstone.Orientation;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.skart.skd.Attachment;
import net.skart.skd.block.entity.WhiteWallBinBlockEntity;
import net.skart.skd.procedures.WallBinUpdateProcedure;
import net.skart.skd.world.inventory.BinGUIMenu;

public class WhiteWallBinBlock
extends Block
implements SimpleWaterloggedBlock,
EntityBlock {
    public static final EnumProperty<Direction> FACING = HorizontalDirectionalBlock.FACING;
    public static final BooleanProperty WATERLOGGED = BlockStateProperties.WATERLOGGED;
    public static final EnumProperty ATTACHMENT = EnumProperty.create((String)"attachment", Attachment.class);

    public WhiteWallBinBlock(BlockBehaviour.Properties properties) {
        super(properties.mapColor(MapColor.QUARTZ).sound(SoundType.METAL).strength(1.5f, 1.0f).noOcclusion().isRedstoneConductor((bs, br, bp) -> false));
        this.registerDefaultState((BlockState)((BlockState)((BlockState)((BlockState)this.stateDefinition.any()).setValue(FACING, (Comparable)Direction.NORTH)).setValue((Property)WATERLOGGED, (Comparable)Boolean.valueOf(false))).setValue((Property)ATTACHMENT, (Comparable)((Object)Attachment.NONE)));
    }

    public boolean propagatesSkylightDown(BlockState state) {
        return state.getFluidState().isEmpty();
    }

    public int getLightBlock(BlockState state) {
        return 0;
    }

    public VoxelShape getVisualShape(BlockState state, BlockGetter world, BlockPos pos, CollisionContext context) {
        return Shapes.empty();
    }

    public VoxelShape getShape(BlockState state, BlockGetter world, BlockPos pos, CollisionContext context) {
        return switch ((Direction)state.getValue(FACING)) {
            default -> {
                if (state.getValue((Property)ATTACHMENT) == Attachment.NONE) {
                    yield Shapes.or((VoxelShape)WhiteWallBinBlock.box((double)3.0, (double)2.0, (double)0.0, (double)13.0, (double)16.0, (double)8.0), (VoxelShape)WhiteWallBinBlock.box((double)2.0, (double)10.0, (double)0.0, (double)14.0, (double)12.0, (double)9.0));
                }
                if (state.getValue((Property)ATTACHMENT) == Attachment.WALL) {
                    yield Shapes.or((VoxelShape)WhiteWallBinBlock.box((double)3.0, (double)2.0, (double)-4.0, (double)13.0, (double)16.0, (double)4.0), (VoxelShape)WhiteWallBinBlock.box((double)2.0, (double)10.0, (double)-4.0, (double)14.0, (double)12.0, (double)5.0));
                }
                if (state.getValue((Property)ATTACHMENT) == Attachment.FENCE) {
                    yield Shapes.or((VoxelShape)WhiteWallBinBlock.box((double)3.0, (double)2.0, (double)-6.0, (double)13.0, (double)16.0, (double)2.0), (VoxelShape)WhiteWallBinBlock.box((double)2.0, (double)10.0, (double)-6.0, (double)14.0, (double)12.0, (double)3.0));
                }
                yield null;
            }
            case Direction.NORTH -> {
                if (state.getValue((Property)ATTACHMENT) == Attachment.NONE) {
                    yield Shapes.or((VoxelShape)WhiteWallBinBlock.box((double)3.0, (double)2.0, (double)8.0, (double)13.0, (double)16.0, (double)16.0), (VoxelShape)WhiteWallBinBlock.box((double)2.0, (double)10.0, (double)7.0, (double)14.0, (double)12.0, (double)16.0));
                }
                if (state.getValue((Property)ATTACHMENT) == Attachment.WALL) {
                    yield Shapes.or((VoxelShape)WhiteWallBinBlock.box((double)3.0, (double)2.0, (double)12.0, (double)13.0, (double)16.0, (double)20.0), (VoxelShape)WhiteWallBinBlock.box((double)2.0, (double)10.0, (double)11.0, (double)14.0, (double)12.0, (double)20.0));
                }
                if (state.getValue((Property)ATTACHMENT) == Attachment.FENCE) {
                    yield Shapes.or((VoxelShape)WhiteWallBinBlock.box((double)3.0, (double)2.0, (double)14.0, (double)13.0, (double)16.0, (double)22.0), (VoxelShape)WhiteWallBinBlock.box((double)2.0, (double)10.0, (double)13.0, (double)14.0, (double)12.0, (double)22.0));
                }
                yield null;
            }
            case Direction.EAST -> {
                if (state.getValue((Property)ATTACHMENT) == Attachment.NONE) {
                    yield Shapes.or((VoxelShape)WhiteWallBinBlock.box((double)0.0, (double)2.0, (double)3.0, (double)8.0, (double)16.0, (double)13.0), (VoxelShape)WhiteWallBinBlock.box((double)0.0, (double)10.0, (double)2.0, (double)9.0, (double)12.0, (double)14.0));
                }
                if (state.getValue((Property)ATTACHMENT) == Attachment.WALL) {
                    yield Shapes.or((VoxelShape)WhiteWallBinBlock.box((double)-4.0, (double)2.0, (double)3.0, (double)4.0, (double)16.0, (double)13.0), (VoxelShape)WhiteWallBinBlock.box((double)-4.0, (double)10.0, (double)2.0, (double)5.0, (double)12.0, (double)14.0));
                }
                if (state.getValue((Property)ATTACHMENT) == Attachment.FENCE) {
                    yield Shapes.or((VoxelShape)WhiteWallBinBlock.box((double)-6.0, (double)2.0, (double)3.0, (double)2.0, (double)16.0, (double)13.0), (VoxelShape)WhiteWallBinBlock.box((double)-6.0, (double)10.0, (double)2.0, (double)3.0, (double)12.0, (double)14.0));
                }
                yield null;
            }
            case Direction.WEST -> state.getValue((Property)ATTACHMENT) == Attachment.NONE ? Shapes.or((VoxelShape)WhiteWallBinBlock.box((double)8.0, (double)2.0, (double)3.0, (double)16.0, (double)16.0, (double)13.0), (VoxelShape)WhiteWallBinBlock.box((double)7.0, (double)10.0, (double)2.0, (double)16.0, (double)12.0, (double)14.0)) : (state.getValue((Property)ATTACHMENT) == Attachment.WALL ? Shapes.or((VoxelShape)WhiteWallBinBlock.box((double)12.0, (double)2.0, (double)3.0, (double)20.0, (double)16.0, (double)13.0), (VoxelShape)WhiteWallBinBlock.box((double)11.0, (double)10.0, (double)2.0, (double)20.0, (double)12.0, (double)14.0)) : (state.getValue((Property)ATTACHMENT) == Attachment.FENCE ? Shapes.or((VoxelShape)WhiteWallBinBlock.box((double)14.0, (double)2.0, (double)3.0, (double)22.0, (double)16.0, (double)13.0), (VoxelShape)WhiteWallBinBlock.box((double)13.0, (double)10.0, (double)2.0, (double)22.0, (double)12.0, (double)14.0)) : null));
        };
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        super.createBlockStateDefinition(builder);
        builder.add(new Property[]{FACING, WATERLOGGED, ATTACHMENT});
    }

    public BlockState getStateForPlacement(BlockPlaceContext context) {
        boolean flag = context.getLevel().getFluidState(context.getClickedPos()).getType() == Fluids.WATER;
        return (BlockState)((BlockState)super.getStateForPlacement(context).setValue(FACING, (Comparable)context.getHorizontalDirection().getOpposite())).setValue((Property)WATERLOGGED, (Comparable)Boolean.valueOf(flag));
    }

    public BlockState rotate(BlockState state, Rotation rot) {
        return (BlockState)state.setValue(FACING, (Comparable)rot.rotate((Direction)state.getValue(FACING)));
    }

    public BlockState mirror(BlockState state, Mirror mirrorIn) {
        return state.rotate(mirrorIn.getRotation((Direction)state.getValue(FACING)));
    }

    public FluidState getFluidState(BlockState state) {
        return (Boolean)state.getValue((Property)WATERLOGGED) != false ? Fluids.WATER.getSource(false) : super.getFluidState(state);
    }

    public BlockState updateShape(BlockState state, LevelReader world, ScheduledTickAccess scheduledTickAccess, BlockPos currentPos, Direction facing, BlockPos facingPos, BlockState facingState, RandomSource random) {
        if (((Boolean)state.getValue((Property)WATERLOGGED)).booleanValue()) {
            scheduledTickAccess.scheduleTick(currentPos, (Fluid)Fluids.WATER, Fluids.WATER.getTickDelay(world));
        }
        return super.updateShape(state, world, scheduledTickAccess, currentPos, facing, facingPos, facingState, random);
    }

    public void neighborChanged(BlockState blockstate, Level world, BlockPos pos, Block neighborBlock, @Nullable Orientation orientation, boolean moving) {
        super.neighborChanged(blockstate, world, pos, neighborBlock, orientation, moving);
        WallBinUpdateProcedure.execute((LevelAccessor)world, pos.getX(), pos.getY(), pos.getZ());
    }

    public void setPlacedBy(Level world, BlockPos pos, BlockState blockstate, LivingEntity entity, ItemStack itemstack) {
        super.setPlacedBy(world, pos, blockstate, entity, itemstack);
        WallBinUpdateProcedure.execute((LevelAccessor)world, pos.getX(), pos.getY(), pos.getZ());
    }

    public InteractionResult useWithoutItem(BlockState blockstate, Level world, final BlockPos pos, Player entity, BlockHitResult hit) {
        super.useWithoutItem(blockstate, world, pos, entity, hit);
        if (entity instanceof ServerPlayer) {
            ServerPlayer player = (ServerPlayer)entity;
            player.openMenu(new MenuProvider(){

                public Component getDisplayName() {
                    return Component.literal((String)"White Wall Bin");
                }

                public AbstractContainerMenu createMenu(int id, Inventory inventory, Player player) {
                    return new BinGUIMenu(id, inventory, new FriendlyByteBuf(Unpooled.buffer()).writeBlockPos(pos));
                }
            }, pos);
        }
        return InteractionResult.SUCCESS;
    }

    public MenuProvider getMenuProvider(BlockState state, Level worldIn, BlockPos pos) {
        MenuProvider menuProvider;
        BlockEntity tileEntity = worldIn.getBlockEntity(pos);
        return tileEntity instanceof MenuProvider ? (menuProvider = (MenuProvider)tileEntity) : null;
    }

    public BlockEntity newBlockEntity(BlockPos pos, BlockState state) {
        return new WhiteWallBinBlockEntity(pos, state);
    }

    public boolean triggerEvent(BlockState state, Level world, BlockPos pos, int eventID, int eventParam) {
        super.triggerEvent(state, world, pos, eventID, eventParam);
        BlockEntity blockEntity = world.getBlockEntity(pos);
        return blockEntity != null && blockEntity.triggerEvent(eventID, eventParam);
    }

    protected void affectNeighborsAfterRemoval(BlockState blockstate, ServerLevel world, BlockPos blockpos, boolean flag) {
        Containers.updateNeighboursAfterDestroy((BlockState)blockstate, (Level)world, (BlockPos)blockpos);
    }

    public boolean hasAnalogOutputSignal(BlockState state) {
        return true;
    }

    public int getAnalogOutputSignal(BlockState blockState, Level world, BlockPos pos) {
        BlockEntity tileentity = world.getBlockEntity(pos);
        if (tileentity instanceof WhiteWallBinBlockEntity) {
            WhiteWallBinBlockEntity be = (WhiteWallBinBlockEntity)tileentity;
            return AbstractContainerMenu.getRedstoneSignalFromContainer((Container)be);
        }
        return 0;
    }
}

