/*
 * Decompiled with CFR 0.152.
 */
package net.skart.skd.client.gui;

import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.ImageButton;
import net.minecraft.client.gui.components.WidgetSprites;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;
import net.minecraft.client.renderer.RenderPipelines;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.neoforged.neoforge.client.network.ClientPacketDistributor;
import net.skart.skd.init.SkdModScreens;
import net.skart.skd.network.BinGUIButtonMessage;
import net.skart.skd.procedures.BinIsEmptyDisplayConditionProcedure;
import net.skart.skd.procedures.BinIsFullDisplayConditionProcedure;
import net.skart.skd.procedures.ThrowOutButtonDisplayConditionProcedure;
import net.skart.skd.procedures.TrashButtonDisplayConditionProcedure;
import net.skart.skd.world.inventory.BinGUIMenu;

public class BinGUIScreen
extends AbstractContainerScreen<BinGUIMenu>
implements SkdModScreens.ScreenAccessor {
    private final Level world;
    private final int x;
    private final int y;
    private final int z;
    private final Player entity;
    private boolean menuStateUpdateActive = false;
    private ImageButton imagebutton_throw_out;
    private ImageButton imagebutton_trash;
    private static final ResourceLocation texture = ResourceLocation.parse((String)"skd:textures/screens/bin.png");

    public BinGUIScreen(BinGUIMenu container, Inventory inventory, Component text) {
        super((AbstractContainerMenu)container, inventory, text);
        this.world = container.world;
        this.x = container.x;
        this.y = container.y;
        this.z = container.z;
        this.entity = container.entity;
        this.imageWidth = 176;
        this.imageHeight = 166;
    }

    @Override
    public void updateMenuState(int elementType, String name, Object elementState) {
        this.menuStateUpdateActive = true;
        this.menuStateUpdateActive = false;
    }

    public void render(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTicks) {
        super.render(guiGraphics, mouseX, mouseY, partialTicks);
        boolean customTooltipShown = false;
        if (ThrowOutButtonDisplayConditionProcedure.execute((LevelAccessor)this.world, this.x, this.y, this.z) && mouseX > this.leftPos + 8 && mouseX < this.leftPos + 32 && mouseY > this.topPos + 27 && mouseY < this.topPos + 51) {
            guiGraphics.setTooltipForNextFrame(this.font, (Component)Component.translatable((String)"gui.skd.bin_gui.tooltip_throw_out"), mouseX, mouseY);
            customTooltipShown = true;
        }
        if (BinIsEmptyDisplayConditionProcedure.execute((LevelAccessor)this.world, this.x, this.y, this.z) && mouseX > this.leftPos + 8 && mouseX < this.leftPos + 32 && mouseY > this.topPos + 27 && mouseY < this.topPos + 51) {
            guiGraphics.setTooltipForNextFrame(this.font, (Component)Component.translatable((String)"gui.skd.bin_gui.tooltip_the_bin_is_empty"), mouseX, mouseY);
            customTooltipShown = true;
        }
        if (TrashButtonDisplayConditionProcedure.execute((LevelAccessor)this.world, this.x, this.y, this.z) && mouseX > this.leftPos + 35 && mouseX < this.leftPos + 59 && mouseY > this.topPos + 27 && mouseY < this.topPos + 51) {
            guiGraphics.setTooltipForNextFrame(this.font, (Component)Component.translatable((String)"gui.skd.bin_gui.tooltip_convert_items_to_trash"), mouseX, mouseY);
            customTooltipShown = true;
        }
        if (BinIsEmptyDisplayConditionProcedure.execute((LevelAccessor)this.world, this.x, this.y, this.z) && mouseX > this.leftPos + 35 && mouseX < this.leftPos + 59 && mouseY > this.topPos + 27 && mouseY < this.topPos + 51) {
            guiGraphics.setTooltipForNextFrame(this.font, (Component)Component.translatable((String)"gui.skd.bin_gui.tooltip_the_bin_is_empty1"), mouseX, mouseY);
            customTooltipShown = true;
        }
        if (BinIsFullDisplayConditionProcedure.execute((LevelAccessor)this.world, this.x, this.y, this.z) && mouseX > this.leftPos + 35 && mouseX < this.leftPos + 59 && mouseY > this.topPos + 27 && mouseY < this.topPos + 51) {
            guiGraphics.setTooltipForNextFrame(this.font, (Component)Component.translatable((String)"gui.skd.bin_gui.tooltip_the_bin_is_full"), mouseX, mouseY);
            customTooltipShown = true;
        }
        if (!customTooltipShown) {
            this.renderTooltip(guiGraphics, mouseX, mouseY);
        }
    }

    protected void renderBg(GuiGraphics guiGraphics, float partialTicks, int mouseX, int mouseY) {
        guiGraphics.blit(RenderPipelines.GUI_TEXTURED, texture, this.leftPos, this.topPos, 0.0f, 0.0f, this.imageWidth, this.imageHeight, this.imageWidth, this.imageHeight);
    }

    public boolean keyPressed(int key, int b, int c) {
        if (key == 256) {
            this.minecraft.player.closeContainer();
            return true;
        }
        return super.keyPressed(key, b, c);
    }

    protected void renderLabels(GuiGraphics guiGraphics, int mouseX, int mouseY) {
        guiGraphics.drawString(this.font, (Component)Component.translatable((String)"gui.skd.gui.label_inventory"), 6, 73, -12829636, false);
        guiGraphics.drawString(this.font, (Component)Component.translatable((String)"gui.skd.bin_gui.label_trash_bin"), 7, 11, -12829636, false);
    }

    public void init() {
        super.init();
        this.imagebutton_throw_out = new ImageButton(this.leftPos + 11, this.topPos + 30, 18, 18, new WidgetSprites(ResourceLocation.parse((String)"skd:textures/screens/throw_out.png"), ResourceLocation.parse((String)"skd:textures/screens/throw_out_pressed.png")), e -> {
            int x = this.x;
            int y = this.y;
            if (ThrowOutButtonDisplayConditionProcedure.execute((LevelAccessor)this.world, x, y, this.z)) {
                ClientPacketDistributor.sendToServer((CustomPacketPayload)new BinGUIButtonMessage(0, x, y, this.z), (CustomPacketPayload[])new CustomPacketPayload[0]);
                BinGUIButtonMessage.handleButtonAction(this.entity, 0, x, y, this.z);
            }
        }){

            public void renderWidget(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTicks) {
                int x = BinGUIScreen.this.x;
                int y = BinGUIScreen.this.y;
                if (ThrowOutButtonDisplayConditionProcedure.execute((LevelAccessor)BinGUIScreen.this.world, x, y, BinGUIScreen.this.z)) {
                    guiGraphics.blit(RenderPipelines.GUI_TEXTURED, this.sprites.get(this.isActive(), this.isHoveredOrFocused()), this.getX(), this.getY(), 0.0f, 0.0f, this.width, this.height, this.width, this.height);
                }
            }
        };
        this.addRenderableWidget((GuiEventListener)this.imagebutton_throw_out);
        this.imagebutton_trash = new ImageButton(this.leftPos + 38, this.topPos + 30, 18, 18, new WidgetSprites(ResourceLocation.parse((String)"skd:textures/screens/trash.png"), ResourceLocation.parse((String)"skd:textures/screens/trash_pressed.png")), e -> {
            int x = this.x;
            int y = this.y;
            if (TrashButtonDisplayConditionProcedure.execute((LevelAccessor)this.world, x, y, this.z)) {
                ClientPacketDistributor.sendToServer((CustomPacketPayload)new BinGUIButtonMessage(1, x, y, this.z), (CustomPacketPayload[])new CustomPacketPayload[0]);
                BinGUIButtonMessage.handleButtonAction(this.entity, 1, x, y, this.z);
            }
        }){

            public void renderWidget(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTicks) {
                int x = BinGUIScreen.this.x;
                int y = BinGUIScreen.this.y;
                if (TrashButtonDisplayConditionProcedure.execute((LevelAccessor)BinGUIScreen.this.world, x, y, BinGUIScreen.this.z)) {
                    guiGraphics.blit(RenderPipelines.GUI_TEXTURED, this.sprites.get(this.isActive(), this.isHoveredOrFocused()), this.getX(), this.getY(), 0.0f, 0.0f, this.width, this.height, this.width, this.height);
                }
            }
        };
        this.addRenderableWidget((GuiEventListener)this.imagebutton_trash);
    }
}

