/*
 * Decompiled with CFR 0.152.
 */
package net.skart.skd.init;

import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.MobCategory;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.event.entity.EntityAttributeCreationEvent;
import net.neoforged.neoforge.event.entity.RegisterSpawnPlacementsEvent;
import net.neoforged.neoforge.registries.DeferredHolder;
import net.neoforged.neoforge.registries.DeferredRegister;
import net.skart.skd.entity.MediumSeatEntity;
import net.skart.skd.entity.SeatEntity;
import net.skart.skd.entity.TallSeatEntity;

@EventBusSubscriber
public class SkdModEntities {
    public static final DeferredRegister<EntityType<?>> REGISTRY = DeferredRegister.create((ResourceKey)Registries.ENTITY_TYPE, (String)"skd");
    public static final DeferredHolder<EntityType<?>, EntityType<SeatEntity>> SEAT = SkdModEntities.register("seat", EntityType.Builder.of(SeatEntity::new, (MobCategory)MobCategory.MISC).setShouldReceiveVelocityUpdates(true).setTrackingRange(64).setUpdateInterval(3).sized(0.6f, 0.6f));
    public static final DeferredHolder<EntityType<?>, EntityType<TallSeatEntity>> TALL_SEAT = SkdModEntities.register("tall_seat", EntityType.Builder.of(TallSeatEntity::new, (MobCategory)MobCategory.MISC).setShouldReceiveVelocityUpdates(true).setTrackingRange(64).setUpdateInterval(3).sized(0.6f, 0.1f));
    public static final DeferredHolder<EntityType<?>, EntityType<MediumSeatEntity>> MEDIUM_SEAT = SkdModEntities.register("medium_seat", EntityType.Builder.of(MediumSeatEntity::new, (MobCategory)MobCategory.MISC).setShouldReceiveVelocityUpdates(true).setTrackingRange(64).setUpdateInterval(3).sized(0.6f, 0.85f));

    private static <T extends Entity> DeferredHolder<EntityType<?>, EntityType<T>> register(String registryname, EntityType.Builder<T> entityTypeBuilder) {
        return REGISTRY.register(registryname, () -> entityTypeBuilder.build(ResourceKey.create((ResourceKey)Registries.ENTITY_TYPE, (ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"skd", (String)registryname))));
    }

    @SubscribeEvent
    public static void init(RegisterSpawnPlacementsEvent event) {
        SeatEntity.init(event);
        TallSeatEntity.init(event);
        MediumSeatEntity.init(event);
    }

    @SubscribeEvent
    public static void registerAttributes(EntityAttributeCreationEvent event) {
        event.put((EntityType)SEAT.get(), SeatEntity.createAttributes().build());
        event.put((EntityType)TALL_SEAT.get(), TallSeatEntity.createAttributes().build());
        event.put((EntityType)MEDIUM_SEAT.get(), MediumSeatEntity.createAttributes().build());
    }
}

