/*
 * Decompiled with CFR 0.152.
 */
package com.coriander.justarmour;

import com.coriander.justarmour.HudEditorScreen;
import com.coriander.justarmour.JustArmourConfigData;
import com.coriander.justarmour.TransparentConfigScreen;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Reader;
import net.fabricmc.api.ClientModInitializer;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.fabricmc.fabric.api.client.event.lifecycle.v1.ClientTickEvents;
import net.fabricmc.fabric.api.client.keybinding.v1.KeyBindingHelper;
import net.fabricmc.fabric.api.client.rendering.v1.HudRenderCallback;
import net.minecraft.class_1799;
import net.minecraft.class_2561;
import net.minecraft.class_304;
import net.minecraft.class_310;
import net.minecraft.class_332;
import net.minecraft.class_3675;
import net.minecraft.class_437;
import net.minecraft.class_4587;

@Environment(value=EnvType.CLIENT)
public class JustArmourClient
implements ClientModInitializer {
    public static JustArmourConfigData config;
    private static final Gson gson;
    private static final File configFile;
    private static class_304 toggleHudKeybind;
    private static class_304 openHudEditorKeybind;
    private static class_304 openConfigScreenKeybind;

    public void onInitializeClient() {
        JustArmourClient.loadConfig();
        HudRenderCallback.EVENT.register((context, delta) -> {
            if (JustArmourClient.config.hudEnabled) {
                JustArmourClient.renderArmorHUD(context, JustArmourClient.config.hudX, JustArmourClient.config.hudY);
            }
        });
        this.registerKeybinds();
    }

    private void registerKeybinds() {
        toggleHudKeybind = KeyBindingHelper.registerKeyBinding((class_304)new class_304("justarmourtoggleKey", class_3675.class_307.field_1668, 71, "justarmour"));
        openHudEditorKeybind = KeyBindingHelper.registerKeyBinding((class_304)new class_304("justarmourhudEditorKey", class_3675.class_307.field_1668, 74, "justarmour"));
        openConfigScreenKeybind = KeyBindingHelper.registerKeyBinding((class_304)new class_304("justarmourconfigKey", class_3675.class_307.field_1668, 72, "justarmour"));
        ClientTickEvents.END_CLIENT_TICK.register(client -> {
            while (toggleHudKeybind.method_1436()) {
                JustArmourClient.config.hudEnabled = !JustArmourClient.config.hudEnabled;
                JustArmourClient.saveConfig();
                if (client.field_1724 == null) continue;
                String message = "Armor HUD " + (JustArmourClient.config.hudEnabled ? "on" : "off");
                client.field_1724.method_7353((class_2561)class_2561.method_43470((String)message), false);
            }
            while (openHudEditorKeybind.method_1436()) {
                if (client.field_1724 == null) continue;
                client.method_1507((class_437)new HudEditorScreen());
            }
            while (openConfigScreenKeybind.method_1436()) {
                if (client.field_1724 == null) continue;
                client.method_1507((class_437)new TransparentConfigScreen());
            }
        });
    }

    public static void renderArmorHUD(class_332 context, int baseX, int baseY) {
        class_1799 heldItem;
        class_310 client = class_310.method_1551();
        if (client.field_1724 == null || client.field_1690.field_1842) {
            return;
        }
        class_4587 matrices = context.method_51448();
        matrices.method_22903();
        matrices.method_46416((float)baseX, (float)baseY, 0.0f);
        matrices.method_22905(JustArmourClient.config.scale, JustArmourClient.config.scale, 1.0f);
        matrices.method_46416((float)(-baseX), (float)(-baseY), 0.0f);
        int x = baseX;
        int y = baseY;
        for (int i = 0; i < 4; ++i) {
            class_1799 stack = (class_1799)client.field_1724.method_31548().field_7548.get(i);
            if (!stack.method_7960()) {
                JustArmourClient.renderArmorPiece(context, stack, x, y);
            }
            y -= JustArmourClient.config.spacing;
        }
        if (JustArmourClient.config.showHeldItem && !(heldItem = client.field_1724.method_6047()).method_7960() && heldItem.method_7963()) {
            y = baseY + JustArmourClient.config.spacing;
            JustArmourClient.renderArmorPiece(context, heldItem, x, y);
        }
        matrices.method_22909();
    }

    private static void renderArmorPiece(class_332 context, class_1799 stack, int x, int y) {
        int iconX;
        class_310 client = class_310.method_1551();
        int n = iconX = JustArmourClient.config.durabilityOnRight ? x - 10 : x + 10;
        if (JustArmourClient.config.showDurabilityBar) {
            context.method_51427(stack, iconX, y);
            context.method_51431(client.field_1772, stack, iconX, y);
        } else {
            context.method_51427(stack, iconX, y);
        }
        int durability = stack.method_7936() - stack.method_7919();
        int max = stack.method_7936();
        int color = durability == max ? 0x55FF55 : (durability == max - 1 ? 0xFFFFFF : (durability <= 71 ? 0xFF5555 : (durability <= 149 ? 16753920 : (durability <= 281 ? 0xFFFF55 : 0xFFFFFF))));
        String text = String.valueOf(durability);
        int textWidth = client.field_1772.method_1727(text);
        int textX = JustArmourClient.config.durabilityOnRight ? x + 10 : x - textWidth + 6;
        context.method_51433(client.field_1772, text, textX, y + 4, color, true);
    }

    public static void loadConfig() {
        try {
            if (!configFile.exists()) {
                config = new JustArmourConfigData();
                JustArmourClient.saveConfig();
                return;
            }
            FileReader reader = new FileReader(configFile);
            config = (JustArmourConfigData)gson.fromJson((Reader)reader, JustArmourConfigData.class);
            reader.close();
        }
        catch (IOException e) {
            e.printStackTrace();
            config = new JustArmourConfigData();
        }
    }

    public static void saveConfig() {
        try {
            configFile.getParentFile().mkdirs();
            FileWriter writer = new FileWriter(configFile);
            gson.toJson((Object)config, (Appendable)writer);
            writer.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    static {
        gson = new GsonBuilder().setPrettyPrinting().create();
        configFile = new File(class_310.method_1551().field_1697, "config/justarmour_config.json");
    }
}

