/*
 * Decompiled with CFR 0.152.
 */
package dev.microcontrollers.betterscreens.hook;

import dev.microcontrollers.betterscreens.config.BetterScreensConfig;
import java.util.AbstractMap;
import net.minecraft.class_310;
import net.minecraft.class_3675;

public class ScreenMouseHook {
    private static final BetterScreensConfig config = (BetterScreensConfig)BetterScreensConfig.CONFIG.instance();
    private static AbstractMap.SimpleImmutableEntry<Double, Double> savedPositionedP1 = null;
    private static SavedPosition savedPosition = null;

    public static void saveCursorOriginal(double xPos, double yPos) {
        savedPositionedP1 = new AbstractMap.SimpleImmutableEntry<Double, Double>(xPos, yPos);
    }

    public static void saveCursorMiddle(double middleX, double middleY) {
        if (!ScreenMouseHook.config.dontResetCursor) {
            return;
        }
        if (savedPositionedP1 == null) {
            return;
        }
        AbstractMap.SimpleImmutableEntry<Double, Double> cursorPos = savedPositionedP1;
        savedPosition = new SavedPosition(new AbstractMap.SimpleImmutableEntry<Double, Double>(middleX, middleY), cursorPos);
    }

    public static AbstractMap.SimpleImmutableEntry<Double, Double> loadCursor(double middleX, double middleY) {
        if (!ScreenMouseHook.config.dontResetCursor) {
            return null;
        }
        SavedPosition lastPosition = savedPosition != null && (ScreenMouseHook.config.cursorResetTimer == 0L || ScreenMouseHook.savedPosition.savedAt.passedTimeMillis() < ScreenMouseHook.config.cursorResetTimer) ? savedPosition : null;
        savedPosition = null;
        if (lastPosition != null && Math.abs(lastPosition.middle.getKey() - middleX) < 1.0 && Math.abs(lastPosition.middle.getValue() - middleY) < 1.0) {
            class_3675.method_15984((long)class_310.method_1551().method_22683().method_4490(), (int)212993, (double)lastPosition.cursor.getKey(), (double)lastPosition.cursor.getValue());
            return lastPosition.cursor;
        }
        return null;
    }

    public static class SavedPosition {
        public final AbstractMap.SimpleImmutableEntry<Double, Double> middle;
        public final AbstractMap.SimpleImmutableEntry<Double, Double> cursor;
        public final TimeMark savedAt;

        public SavedPosition(AbstractMap.SimpleImmutableEntry<Double, Double> middle, AbstractMap.SimpleImmutableEntry<Double, Double> cursor) {
            this.middle = middle;
            this.cursor = cursor;
            this.savedAt = TimeMark.now();
        }
    }

    public record TimeMark(long timeMark) {
        public long passedTimeMillis() {
            return this.timeMark == 0L ? Long.MAX_VALUE : System.currentTimeMillis() - this.timeMark;
        }

        public static TimeMark now() {
            return new TimeMark(System.currentTimeMillis());
        }
    }
}

