/*
 * Decompiled with CFR 0.152.
 */
package cc.unilock.arborealascent;

import java.util.HashSet;
import java.util.Iterator;
import net.minecraft.core.BlockPos;
import net.minecraft.tags.BlockTags;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.block.state.BlockState;

public class TreeHelper {
    private static final int maxDepth = 100;
    private static final int minLeaves = 5;
    private static final int minLogs = 2;
    private final BlockGetter level;
    private final HashSet<BlockPos> scanned = new HashSet();
    private int leaves = 0;
    private int logs = 0;

    private TreeHelper(BlockGetter level) {
        this.level = level;
    }

    public static TreeHelper create(BlockGetter level) {
        return new TreeHelper(level);
    }

    public boolean isTreeBranch(BlockPos center) {
        if (!this.level.getBlockState(center).is(BlockTags.LEAVES)) {
            return false;
        }
        return this.isTree(center);
    }

    public boolean isTreeTrunk(BlockPos center) {
        if (!this.level.getBlockState(center).is(BlockTags.LOGS)) {
            return false;
        }
        return this.isTree(center);
    }

    private boolean isTree(BlockPos center) {
        if (!this.level.getBlockState(center).is(BlockTags.LOGS)) {
            return false;
        }
        HashSet<BlockPos> scanning = new HashSet<BlockPos>();
        HashSet<BlockPos> todo = new HashSet<BlockPos>();
        this.add(center, scanning);
        int depth = 0;
        while (!scanning.isEmpty() && depth < 100) {
            ++depth;
            Iterator<BlockPos> it = scanning.iterator();
            while (it.hasNext()) {
                BlockPos scan = it.next();
                this.scanned.add(scan);
                for (int x = -1; x <= 1; ++x) {
                    for (int y = -1; y <= 1; ++y) {
                        for (int z = -1; z <= 1; ++z) {
                            BlockPos pos;
                            if (x == 0 && y == 0 && z == 0 || this.scanned.contains(pos = scan.offset(x, y, z))) continue;
                            this.add(pos, todo);
                        }
                    }
                }
                it.remove();
            }
            if (this.leaves >= 5 && this.logs >= 2) {
                return true;
            }
            scanning.addAll(todo);
            todo.clear();
        }
        return false;
    }

    private void add(BlockPos pos, HashSet<BlockPos> set) {
        BlockState state = this.level.getBlockState(pos);
        if (state.is(BlockTags.LEAVES)) {
            set.add(pos);
            ++this.leaves;
        }
        if (state.is(BlockTags.LOGS)) {
            set.add(pos);
            ++this.logs;
        }
    }
}

