/*
 * Decompiled with CFR 0.152.
 */
package cc.unilock.arborealascent.mixin;

import cc.unilock.arborealascent.TreeHelper;
import com.llamalad7.mixinextras.injector.ModifyReturnValue;
import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.AABB;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;

@Mixin(value={LivingEntity.class})
public abstract class LivingEntityMixin
extends Entity {
    @Shadow
    private Optional<BlockPos> lastClimbablePos;

    public LivingEntityMixin(EntityType<?> type, Level level) {
        super(type, level);
        throw new AssertionError();
    }

    @ModifyReturnValue(method={"onClimbable()Z"}, at={@At(value="RETURN")})
    private boolean onClimbable(boolean original) {
        if (Player.class.isAssignableFrom(((Object)((Object)this)).getClass()) && !this.isSpectator()) {
            AABB bb = this.getBoundingBox();
            for (BlockPos pos : BlockPos.betweenClosed((int)Mth.floor((double)(bb.minX - 0.03125)), (int)Mth.floor((double)bb.minY), (int)Mth.floor((double)(bb.minZ - 0.03125)), (int)Mth.floor((double)bb.maxX), (int)Mth.floor((double)bb.maxY), (int)Mth.floor((double)bb.maxZ))) {
                if (!TreeHelper.create((BlockGetter)this.level()).isTreeTrunk(pos)) continue;
                this.lastClimbablePos = Optional.of(pos);
                return true;
            }
        }
        return original;
    }
}

