/*
 * Decompiled with CFR 0.152.
 */
package hu.bendi.tihr.mixin;

import hu.bendi.tihr.Constants;
import java.io.File;
import java.io.IOException;
import java.util.Map;
import net.minecraft.client.Minecraft;
import net.minecraft.client.OptionInstance;
import net.minecraft.client.Options;
import net.minecraft.client.tutorial.TutorialSteps;
import net.minecraft.sounds.SoundSource;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={Options.class})
public class OptionsMixin {
    @Shadow
    public boolean skipMultiplayerWarning;
    @Shadow
    public TutorialSteps tutorialStep;
    @Shadow
    @Final
    private OptionInstance<Integer> guiScale;
    @Shadow
    @Final
    private Map<SoundSource, OptionInstance<Double>> soundSourceVolumes;
    @Shadow
    @Final
    private OptionInstance<Boolean> narratorHotkey;

    @Inject(method={"<init>"}, at={@At(value="TAIL")})
    public void initOptions(Minecraft pMinecraft, File pGameDirectory, CallbackInfo ci) {
        this.skipMultiplayerWarning = true;
        this.tutorialStep = TutorialSteps.NONE;
        try {
            if (new File(pMinecraft.gameDirectory, "tihr-ran-before").createNewFile()) {
                this.guiScale.set((Object)2);
                this.soundSourceVolumes.get(SoundSource.MUSIC).set((Object)0.0);
                this.narratorHotkey.set((Object)false);
            }
        }
        catch (IOException e) {
            Constants.LOG.error("Failed to create file {}.", (Object)e.getMessage());
        }
    }
}

