/*
 * Decompiled with CFR 0.152.
 */
package PolarMods.polarspleef.mixin;

import PolarMods.polarspleef.CustomBehavior.customExplosionBehavior;
import PolarMods.polarspleef.EffectPlayer;
import PolarMods.polarspleef.Polarspleef;
import com.cobblemon.mod.common.api.pokeball.PokeBalls;
import com.cobblemon.mod.common.entity.pokeball.EmptyPokeBallEntity;
import com.cobblemon.mod.common.pokeball.PokeBall;
import net.minecraft.class_1291;
import net.minecraft.class_1293;
import net.minecraft.class_1294;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_1937;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_239;
import net.minecraft.class_243;
import net.minecraft.class_2596;
import net.minecraft.class_2680;
import net.minecraft.class_2684;
import net.minecraft.class_2743;
import net.minecraft.class_3222;
import net.minecraft.class_3965;
import net.minecraft.class_3966;
import net.minecraft.class_4050;
import net.minecraft.class_5362;
import net.minecraft.class_5819;
import net.minecraft.class_6880;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={EmptyPokeBallEntity.class})
public class SnowballCollisionMixin {
    @Unique
    private static final boolean shouldDropItems = false;

    @Inject(method={"onCollision"}, at={@At(value="HEAD")}, cancellable=true)
    public void onHitBlock(class_239 hitResult, CallbackInfo ci) {
        class_3966 entityHitResult;
        class_1297 entity;
        EmptyPokeBallEntity ball = (EmptyPokeBallEntity)this;
        PokeBall pokeBallType = ball.getPokeBall();
        if (hitResult.method_17783() == class_239.class_240.field_1332) {
            class_3965 blockHitResult = (class_3965)hitResult;
            class_2338 blockPos = blockHitResult.method_17777();
            class_1937 world = ball.method_37908();
            class_2680 blockState = world.method_8320(blockPos);
            class_2248 hitBlock = blockState.method_26204();
            if (hitBlock == class_2246.field_10491) {
                if (pokeBallType == PokeBalls.getPokeBall()) {
                    SnowballCollisionMixin.pokeBallHitEffect(world, blockPos);
                } else if (pokeBallType == PokeBalls.getGreatBall()) {
                    SnowballCollisionMixin.greatBallHitEffect(world, blockPos);
                } else if (pokeBallType == PokeBalls.getUltraBall()) {
                    SnowballCollisionMixin.ultraBallHitEffect(world, blockPos);
                }
                ball.method_31472();
                ci.cancel();
            }
        } else if (hitResult.method_17783() == class_239.class_240.field_1331 && (entity = (entityHitResult = (class_3966)hitResult).method_17782()) instanceof class_1309) {
            class_1309 livingEntity = (class_1309)entity;
            if (pokeBallType == PokeBalls.getHeavyBall()) {
                SnowballCollisionMixin.heavyBallHitEffect(livingEntity);
            } else if (pokeBallType == PokeBalls.getDiveBall()) {
                SnowballCollisionMixin.diveBallHitEffect(livingEntity);
            } else if (pokeBallType == PokeBalls.getAncientJetBall()) {
                class_243 velocity = ball.method_18798();
                SnowballCollisionMixin.ancientJetBallHitEffect(livingEntity, velocity);
            } else if (pokeBallType == PokeBalls.getDuskBall()) {
                SnowballCollisionMixin.duskBallHitEffect(livingEntity);
            } else if (pokeBallType == PokeBalls.getQuickBall()) {
                SnowballCollisionMixin.quickBallHitEffect(livingEntity);
            } else if (pokeBallType == PokeBalls.getAncientWingBall()) {
                SnowballCollisionMixin.wingBallHitEffect(livingEntity);
            }
            ball.method_31472();
            ci.cancel();
        }
    }

    @Unique
    private static void dreamBallHitEffect(class_1309 entity) {
        if (entity instanceof class_3222) {
            class_3222 player = (class_3222)entity;
            class_5819 random = entity.method_59922();
            byte randomYaw = (byte)random.method_39332(-180, 180);
            byte randomPitch = (byte)random.method_39332(-90, 90);
            boolean onGround = player.method_24828();
            player.field_13987.method_14364((class_2596)new class_2684.class_2687(entity.method_5628(), randomYaw, randomPitch, onGround));
        }
    }

    @Unique
    private static void ancientJetBallHitEffect(class_1309 entity, class_243 velocity) {
        if (entity instanceof class_3222) {
            class_3222 player = (class_3222)entity;
            class_243 totalVelocity = entity.method_18798().method_1019(velocity);
            double velocityMultiplier = 1.5;
            entity.method_18799(totalVelocity.method_1021(velocityMultiplier));
            player.field_13987.method_14364((class_2596)new class_2743((class_1297)player));
        }
    }

    @Unique
    private static void wingBallHitEffect(class_1309 entity) {
        int effectAmplifier = 1;
        int effectDuration = 100;
        entity.method_6092(SnowballCollisionMixin.getStatusEffect(effectDuration, effectAmplifier, (class_6880<class_1291>)class_1294.field_5902));
    }

    @Unique
    private static void heavyBallHitEffect(class_1309 entity) {
        int effectAmplifier = 1;
        int effectDuration = 100;
        entity.method_6092(SnowballCollisionMixin.getStatusEffect(effectDuration, effectAmplifier, (class_6880<class_1291>)class_1294.field_5909));
    }

    @Unique
    private static void duskBallHitEffect(class_1309 entity) {
        int effectAmplifier = 1;
        int effectDuration = 100;
        entity.method_6092(SnowballCollisionMixin.getStatusEffect(effectDuration, effectAmplifier, (class_6880<class_1291>)class_1294.field_38092));
    }

    @Unique
    private static void quickBallHitEffect(class_1309 entity) {
        int effectAmplifier = 5;
        int effectDuration = 100;
        entity.method_6092(SnowballCollisionMixin.getStatusEffect(effectDuration, effectAmplifier, (class_6880<class_1291>)class_1294.field_5904));
    }

    @Unique
    private static class_1293 getStatusEffect(int duration, int amplifier, class_6880<class_1291> effect) {
        return new class_1293(effect, duration, amplifier);
    }

    @Unique
    private static void diveBallHitEffect(final class_1309 entity) {
        try {
            if (entity instanceof class_3222) {
                int currentTick = entity.method_37908().method_8503().method_3780();
                int duration = 20;
                EffectPlayer effectPlayer = new EffectPlayer(currentTick, duration, new Runnable(){

                    @Override
                    public void run() {
                        entity.method_18380(class_4050.field_18079);
                    }
                });
                Polarspleef.registerEffectPlayer(effectPlayer);
            }
        }
        catch (Exception e) {
            Polarspleef.LOGGER.error("error getting ticks");
        }
    }

    @Unique
    private static void pokeBallHitEffect(class_1937 world, class_2338 blockPos) {
        world.method_22352(blockPos, false);
    }

    @Unique
    private static void ultraBallHitEffect(class_1937 world, class_2338 blockPos) {
        float explosionPower = 4.0f;
        boolean shouldStartFire = false;
        double blockCenterOffset = 0.5;
        float knockbackModifier = 0.0f;
        class_243 centerPos = new class_243((double)blockPos.method_10263() + blockCenterOffset, (double)blockPos.method_10264() + blockCenterOffset, (double)blockPos.method_10260() + blockCenterOffset);
        world.method_46407(null, null, (class_5362)new customExplosionBehavior(knockbackModifier), centerPos, explosionPower, shouldStartFire, class_1937.class_7867.field_40889);
    }

    @Unique
    private static void greatBallHitEffect(class_1937 world, class_2338 blockPos) {
        float explosionPower = 2.0f;
        boolean shouldStartFire = false;
        double blockCenterOffset = 0.5;
        float knockbackModifier = 4.0f;
        class_243 centerPos = new class_243((double)blockPos.method_10263() + blockCenterOffset, (double)blockPos.method_10264() + blockCenterOffset, (double)blockPos.method_10260() + blockCenterOffset);
        world.method_46407(null, null, (class_5362)new customExplosionBehavior(knockbackModifier), centerPos, explosionPower, shouldStartFire, class_1937.class_7867.field_40889);
        customExplosionBehavior.applyKnockback(world, centerPos, 3.0, 3.5);
    }
}

