/*
 * Decompiled with CFR 0.152.
 */
package net.manuflosoyt.supermod;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ConcurrentLinkedQueue;
import net.manuflosoyt.supermod.init.SupermodModBlockEntities;
import net.manuflosoyt.supermod.init.SupermodModBlocks;
import net.manuflosoyt.supermod.init.SupermodModEntities;
import net.manuflosoyt.supermod.init.SupermodModFeatures;
import net.manuflosoyt.supermod.init.SupermodModFluidTypes;
import net.manuflosoyt.supermod.init.SupermodModFluids;
import net.manuflosoyt.supermod.init.SupermodModItems;
import net.manuflosoyt.supermod.init.SupermodModMenus;
import net.manuflosoyt.supermod.init.SupermodModParticleTypes;
import net.manuflosoyt.supermod.init.SupermodModSounds;
import net.manuflosoyt.supermod.init.SupermodModTabs;
import net.manuflosoyt.supermod.network.SupermodModVariables;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.util.Tuple;
import net.neoforged.bus.api.IEventBus;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.Mod;
import net.neoforged.fml.util.thread.SidedThreadGroups;
import net.neoforged.neoforge.common.NeoForge;
import net.neoforged.neoforge.event.tick.ServerTickEvent;
import net.neoforged.neoforge.network.event.RegisterPayloadHandlersEvent;
import net.neoforged.neoforge.network.handling.IPayloadHandler;
import net.neoforged.neoforge.network.registration.PayloadRegistrar;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@Mod(value="supermod")
public class SupermodMod {
    public static final Logger LOGGER = LogManager.getLogger(SupermodMod.class);
    public static final String MODID = "supermod";
    private static boolean networkingRegistered = false;
    private static final Map<CustomPacketPayload.Type<?>, NetworkMessage<?>> MESSAGES = new HashMap();
    private static final Collection<Tuple<Runnable, Integer>> workQueue = new ConcurrentLinkedQueue<Tuple<Runnable, Integer>>();

    public SupermodMod(IEventBus modEventBus) {
        NeoForge.EVENT_BUS.register((Object)this);
        modEventBus.addListener(this::registerNetworking);
        SupermodModSounds.REGISTRY.register(modEventBus);
        SupermodModBlocks.REGISTRY.register(modEventBus);
        SupermodModBlockEntities.REGISTRY.register(modEventBus);
        SupermodModItems.REGISTRY.register(modEventBus);
        SupermodModEntities.REGISTRY.register(modEventBus);
        SupermodModTabs.REGISTRY.register(modEventBus);
        SupermodModVariables.ATTACHMENT_TYPES.register(modEventBus);
        SupermodModFeatures.REGISTRY.register(modEventBus);
        SupermodModMenus.REGISTRY.register(modEventBus);
        SupermodModParticleTypes.REGISTRY.register(modEventBus);
        SupermodModFluids.REGISTRY.register(modEventBus);
        SupermodModFluidTypes.REGISTRY.register(modEventBus);
    }

    public static <T extends CustomPacketPayload> void addNetworkMessage(CustomPacketPayload.Type<T> id, StreamCodec<? extends FriendlyByteBuf, T> reader, IPayloadHandler<T> handler) {
        if (networkingRegistered) {
            throw new IllegalStateException("Cannot register new network messages after networking has been registered");
        }
        MESSAGES.put(id, new NetworkMessage<T>(reader, handler));
    }

    private void registerNetworking(RegisterPayloadHandlersEvent event) {
        PayloadRegistrar registrar = event.registrar(MODID);
        MESSAGES.forEach((id, networkMessage) -> registrar.playBidirectional(id, networkMessage.reader(), networkMessage.handler()));
        networkingRegistered = true;
    }

    public static void queueServerWork(int tick, Runnable action) {
        if (Thread.currentThread().getThreadGroup() == SidedThreadGroups.SERVER) {
            workQueue.add((Tuple<Runnable, Integer>)new Tuple((Object)action, (Object)tick));
        }
    }

    @SubscribeEvent
    public void tick(ServerTickEvent.Post event) {
        ArrayList actions = new ArrayList();
        workQueue.forEach(work -> {
            work.setB((Object)((Integer)work.getB() - 1));
            if ((Integer)work.getB() == 0) {
                actions.add(work);
            }
        });
        actions.forEach(e -> ((Runnable)e.getA()).run());
        workQueue.removeAll(actions);
    }

    private record NetworkMessage<T extends CustomPacketPayload>(StreamCodec<? extends FriendlyByteBuf, T> reader, IPayloadHandler<T> handler) {
    }
}

