/*
 * Decompiled with CFR 0.152.
 */
package net.manuflosoyt.supermod.block;

import java.util.List;
import net.manuflosoyt.supermod.block.entity.CopperBatteryBlockEntity;
import net.manuflosoyt.supermod.procedures.CopperBatteryBlockAddedProcedure;
import net.manuflosoyt.supermod.procedures.CopperBatteryBlockDestroyedByExplosionProcedure;
import net.manuflosoyt.supermod.procedures.CopperBatteryNeighbourBlockChangesProcedure;
import net.manuflosoyt.supermod.procedures.CopperBatteryUpdateTickProcedure;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.RandomSource;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Explosion;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.EntityBlock;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.IntegerProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.MapColor;
import net.minecraft.world.level.material.PushReaction;
import net.minecraft.world.level.pathfinder.PathType;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;

public class CopperBatteryBlock
extends Block
implements EntityBlock {
    public static final IntegerProperty BLOCKSTATE = IntegerProperty.create((String)"blockstate", (int)0, (int)23);

    public CopperBatteryBlock() {
        super(BlockBehaviour.Properties.of().mapColor(MapColor.TERRACOTTA_LIGHT_GRAY).sound(SoundType.COPPER).strength(2.5f).lightLevel(s -> new Object((BlockState)s){
            final /* synthetic */ BlockState val$s;
            {
                this.val$s = blockState;
            }

            public int getLightLevel() {
                if ((Integer)this.val$s.getValue((Property)BLOCKSTATE) == 1) {
                    return 0;
                }
                if ((Integer)this.val$s.getValue((Property)BLOCKSTATE) == 2) {
                    return 1;
                }
                if ((Integer)this.val$s.getValue((Property)BLOCKSTATE) == 3) {
                    return 1;
                }
                if ((Integer)this.val$s.getValue((Property)BLOCKSTATE) == 4) {
                    return 2;
                }
                if ((Integer)this.val$s.getValue((Property)BLOCKSTATE) == 5) {
                    return 2;
                }
                if ((Integer)this.val$s.getValue((Property)BLOCKSTATE) == 6) {
                    return 3;
                }
                if ((Integer)this.val$s.getValue((Property)BLOCKSTATE) == 7) {
                    return 3;
                }
                if ((Integer)this.val$s.getValue((Property)BLOCKSTATE) == 8) {
                    return 4;
                }
                if ((Integer)this.val$s.getValue((Property)BLOCKSTATE) == 9) {
                    return 4;
                }
                if ((Integer)this.val$s.getValue((Property)BLOCKSTATE) == 10) {
                    return 5;
                }
                if ((Integer)this.val$s.getValue((Property)BLOCKSTATE) == 11) {
                    return 5;
                }
                if ((Integer)this.val$s.getValue((Property)BLOCKSTATE) == 12) {
                    return 6;
                }
                if ((Integer)this.val$s.getValue((Property)BLOCKSTATE) == 13) {
                    return 6;
                }
                if ((Integer)this.val$s.getValue((Property)BLOCKSTATE) == 14) {
                    return 7;
                }
                if ((Integer)this.val$s.getValue((Property)BLOCKSTATE) == 15) {
                    return 7;
                }
                if ((Integer)this.val$s.getValue((Property)BLOCKSTATE) == 16) {
                    return 8;
                }
                if ((Integer)this.val$s.getValue((Property)BLOCKSTATE) == 17) {
                    return 9;
                }
                if ((Integer)this.val$s.getValue((Property)BLOCKSTATE) == 18) {
                    return 10;
                }
                if ((Integer)this.val$s.getValue((Property)BLOCKSTATE) == 19) {
                    return 11;
                }
                if ((Integer)this.val$s.getValue((Property)BLOCKSTATE) == 20) {
                    return 12;
                }
                if ((Integer)this.val$s.getValue((Property)BLOCKSTATE) == 21) {
                    return 13;
                }
                if ((Integer)this.val$s.getValue((Property)BLOCKSTATE) == 22) {
                    return 14;
                }
                if ((Integer)this.val$s.getValue((Property)BLOCKSTATE) == 23) {
                    return 15;
                }
                return 0;
            }
        }.getLightLevel()).requiresCorrectToolForDrops().pushReaction(PushReaction.BLOCK).dynamicShape());
    }

    @OnlyIn(value=Dist.CLIENT)
    public void appendHoverText(ItemStack itemstack, Item.TooltipContext context, List<Component> list, TooltipFlag flag) {
        super.appendHoverText(itemstack, context, list, flag);
        list.add((Component)Component.translatable((String)"block.supermod.copper_battery.description_0"));
        list.add((Component)Component.translatable((String)"block.supermod.copper_battery.description_1"));
    }

    public int getLightBlock(BlockState state, BlockGetter worldIn, BlockPos pos) {
        return 15;
    }

    public VoxelShape getShape(BlockState state, BlockGetter world, BlockPos pos, CollisionContext context) {
        return CopperBatteryBlock.box((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)16.0, (double)16.0);
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        super.createBlockStateDefinition(builder);
        builder.add(new Property[]{BLOCKSTATE});
    }

    public PathType getBlockPathType(BlockState state, BlockGetter world, BlockPos pos, Mob entity) {
        return PathType.BLOCKED;
    }

    public void onPlace(BlockState blockstate, Level world, BlockPos pos, BlockState oldState, boolean moving) {
        super.onPlace(blockstate, world, pos, oldState, moving);
        world.scheduleTick(pos, (Block)this, 1);
        CopperBatteryBlockAddedProcedure.execute((LevelAccessor)world, pos.getX(), pos.getY(), pos.getZ());
    }

    public void neighborChanged(BlockState blockstate, Level world, BlockPos pos, Block neighborBlock, BlockPos fromPos, boolean moving) {
        super.neighborChanged(blockstate, world, pos, neighborBlock, fromPos, moving);
        CopperBatteryNeighbourBlockChangesProcedure.execute((LevelAccessor)world, pos.getX(), pos.getY(), pos.getZ());
    }

    public void tick(BlockState blockstate, ServerLevel world, BlockPos pos, RandomSource random) {
        super.tick(blockstate, world, pos, random);
        CopperBatteryUpdateTickProcedure.execute((LevelAccessor)world, pos.getX(), pos.getY(), pos.getZ());
        world.scheduleTick(pos, (Block)this, 1);
    }

    public void wasExploded(Level world, BlockPos pos, Explosion e) {
        super.wasExploded(world, pos, e);
        CopperBatteryBlockDestroyedByExplosionProcedure.execute((LevelAccessor)world, pos.getX(), pos.getY(), pos.getZ());
    }

    public MenuProvider getMenuProvider(BlockState state, Level worldIn, BlockPos pos) {
        MenuProvider menuProvider;
        BlockEntity tileEntity = worldIn.getBlockEntity(pos);
        return tileEntity instanceof MenuProvider ? (menuProvider = (MenuProvider)tileEntity) : null;
    }

    public BlockEntity newBlockEntity(BlockPos pos, BlockState state) {
        return new CopperBatteryBlockEntity(pos, state);
    }

    public boolean triggerEvent(BlockState state, Level world, BlockPos pos, int eventID, int eventParam) {
        super.triggerEvent(state, world, pos, eventID, eventParam);
        BlockEntity blockEntity = world.getBlockEntity(pos);
        return blockEntity != null && blockEntity.triggerEvent(eventID, eventParam);
    }
}

