/*
 * Decompiled with CFR 0.152.
 */
package net.manuflosoyt.supermod.block;

import io.netty.buffer.Unpooled;
import net.manuflosoyt.supermod.block.entity.WaferMakerBlockEntity;
import net.manuflosoyt.supermod.procedures.WaferMakerBlockAddedProcedure;
import net.manuflosoyt.supermod.procedures.WaferMakerUpdateTickProcedure;
import net.manuflosoyt.supermod.world.inventory.WaferMakerUIMenu;
import net.minecraft.core.BlockPos;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.util.RandomSource;
import net.minecraft.world.Container;
import net.minecraft.world.Containers;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.EntityBlock;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.PushReaction;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;

public class WaferMakerBlock
extends Block
implements EntityBlock {
    public WaferMakerBlock() {
        super(BlockBehaviour.Properties.of().sound(SoundType.METAL).strength(5.0f, 6.0f).noOcclusion().pushReaction(PushReaction.BLOCK).isRedstoneConductor((bs, br, bp) -> false));
    }

    public boolean propagatesSkylightDown(BlockState state, BlockGetter reader, BlockPos pos) {
        return true;
    }

    public int getLightBlock(BlockState state, BlockGetter worldIn, BlockPos pos) {
        return 0;
    }

    public VoxelShape getVisualShape(BlockState state, BlockGetter world, BlockPos pos, CollisionContext context) {
        return Shapes.empty();
    }

    public VoxelShape getShape(BlockState state, BlockGetter world, BlockPos pos, CollisionContext context) {
        return Shapes.or((VoxelShape)WaferMakerBlock.box((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)7.0, (double)16.0), (VoxelShape[])new VoxelShape[]{WaferMakerBlock.box((double)2.0, (double)6.5, (double)2.0, (double)14.0, (double)7.5, (double)14.0), WaferMakerBlock.box((double)0.0, (double)7.0, (double)0.0, (double)2.0, (double)15.0, (double)2.0), WaferMakerBlock.box((double)0.0, (double)7.0, (double)14.0, (double)2.0, (double)15.0, (double)16.0), WaferMakerBlock.box((double)14.0, (double)7.0, (double)0.0, (double)16.0, (double)15.0, (double)2.0), WaferMakerBlock.box((double)14.0, (double)13.0, (double)2.0, (double)16.0, (double)15.0, (double)14.0), WaferMakerBlock.box((double)0.0, (double)13.0, (double)2.0, (double)2.0, (double)15.0, (double)14.0), WaferMakerBlock.box((double)2.0, (double)13.0, (double)0.0, (double)14.0, (double)15.0, (double)2.0), WaferMakerBlock.box((double)2.0, (double)13.0, (double)14.0, (double)14.0, (double)15.0, (double)16.0), WaferMakerBlock.box((double)14.0, (double)7.0, (double)14.0, (double)16.0, (double)15.0, (double)16.0), WaferMakerBlock.box((double)2.0, (double)13.5, (double)7.5, (double)14.0, (double)14.5, (double)8.5), WaferMakerBlock.box((double)7.5, (double)13.5, (double)2.0, (double)8.5, (double)14.5, (double)14.0), WaferMakerBlock.box((double)7.5, (double)8.5, (double)7.5, (double)8.5, (double)15.0, (double)8.5), WaferMakerBlock.box((double)7.75, (double)8.0, (double)7.75, (double)8.25, (double)8.5, (double)8.25), WaferMakerBlock.box((double)7.875, (double)7.75, (double)7.875, (double)8.125, (double)8.25, (double)8.125)});
    }

    public void onPlace(BlockState blockstate, Level world, BlockPos pos, BlockState oldState, boolean moving) {
        super.onPlace(blockstate, world, pos, oldState, moving);
        world.scheduleTick(pos, (Block)this, 20);
        WaferMakerBlockAddedProcedure.execute((LevelAccessor)world, pos.getX(), pos.getY(), pos.getZ());
    }

    public void tick(BlockState blockstate, ServerLevel world, BlockPos pos, RandomSource random) {
        super.tick(blockstate, world, pos, random);
        WaferMakerUpdateTickProcedure.execute((LevelAccessor)world, pos.getX(), pos.getY(), pos.getZ());
        world.scheduleTick(pos, (Block)this, 20);
    }

    public InteractionResult useWithoutItem(BlockState blockstate, Level world, final BlockPos pos, Player entity, BlockHitResult hit) {
        super.useWithoutItem(blockstate, world, pos, entity, hit);
        if (entity instanceof ServerPlayer) {
            ServerPlayer player = (ServerPlayer)entity;
            player.openMenu(new MenuProvider(){

                public Component getDisplayName() {
                    return Component.literal((String)"Wafer Maker");
                }

                public AbstractContainerMenu createMenu(int id, Inventory inventory, Player player) {
                    return new WaferMakerUIMenu(id, inventory, new FriendlyByteBuf(Unpooled.buffer()).writeBlockPos(pos));
                }
            }, pos);
        }
        return InteractionResult.SUCCESS;
    }

    public MenuProvider getMenuProvider(BlockState state, Level worldIn, BlockPos pos) {
        MenuProvider menuProvider;
        BlockEntity tileEntity = worldIn.getBlockEntity(pos);
        return tileEntity instanceof MenuProvider ? (menuProvider = (MenuProvider)tileEntity) : null;
    }

    public BlockEntity newBlockEntity(BlockPos pos, BlockState state) {
        return new WaferMakerBlockEntity(pos, state);
    }

    public boolean triggerEvent(BlockState state, Level world, BlockPos pos, int eventID, int eventParam) {
        super.triggerEvent(state, world, pos, eventID, eventParam);
        BlockEntity blockEntity = world.getBlockEntity(pos);
        return blockEntity != null && blockEntity.triggerEvent(eventID, eventParam);
    }

    public void onRemove(BlockState state, Level world, BlockPos pos, BlockState newState, boolean isMoving) {
        if (state.getBlock() != newState.getBlock()) {
            BlockEntity blockEntity = world.getBlockEntity(pos);
            if (blockEntity instanceof WaferMakerBlockEntity) {
                WaferMakerBlockEntity be = (WaferMakerBlockEntity)blockEntity;
                Containers.dropContents((Level)world, (BlockPos)pos, (Container)be);
                world.updateNeighbourForOutputSignal(pos, (Block)this);
            }
            super.onRemove(state, world, pos, newState, isMoving);
        }
    }

    public boolean hasAnalogOutputSignal(BlockState state) {
        return true;
    }

    public int getAnalogOutputSignal(BlockState blockState, Level world, BlockPos pos) {
        BlockEntity tileentity = world.getBlockEntity(pos);
        if (tileentity instanceof WaferMakerBlockEntity) {
            WaferMakerBlockEntity be = (WaferMakerBlockEntity)tileentity;
            return AbstractContainerMenu.getRedstoneSignalFromContainer((Container)be);
        }
        return 0;
    }
}

