/*
 * Decompiled with CFR 0.152.
 */
package net.manuflosoyt.supermod.client.gui;

import com.mojang.blaze3d.systems.RenderSystem;
import net.manuflosoyt.supermod.init.SupermodModScreens;
import net.manuflosoyt.supermod.network.BankguiButtonMessage;
import net.manuflosoyt.supermod.procedures.CheckMoneyReturnProcedure;
import net.manuflosoyt.supermod.world.inventory.BankguiMenu;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.level.Level;
import net.neoforged.neoforge.network.PacketDistributor;

public class BankguiScreen
extends AbstractContainerScreen<BankguiMenu>
implements SupermodModScreens.ScreenAccessor {
    private final Level world;
    private final int x;
    private final int y;
    private final int z;
    private final Player entity;
    private boolean menuStateUpdateActive = false;
    private Button button_withdraw_money;
    private Button button_deposit_money;
    private static final ResourceLocation texture = ResourceLocation.parse((String)"supermod:textures/screens/bankgui.png");

    public BankguiScreen(BankguiMenu container, Inventory inventory, Component text) {
        super((AbstractContainerMenu)container, inventory, text);
        this.world = container.world;
        this.x = container.x;
        this.y = container.y;
        this.z = container.z;
        this.entity = container.entity;
        this.imageWidth = 176;
        this.imageHeight = 166;
    }

    @Override
    public void updateMenuState(int elementType, String name, Object elementState) {
        this.menuStateUpdateActive = true;
        this.menuStateUpdateActive = false;
    }

    public void render(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTicks) {
        super.render(guiGraphics, mouseX, mouseY, partialTicks);
        this.renderTooltip(guiGraphics, mouseX, mouseY);
    }

    protected void renderBg(GuiGraphics guiGraphics, float partialTicks, int mouseX, int mouseY) {
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        RenderSystem.enableBlend();
        RenderSystem.defaultBlendFunc();
        guiGraphics.blit(texture, this.leftPos, this.topPos, 0.0f, 0.0f, this.imageWidth, this.imageHeight, this.imageWidth, this.imageHeight);
        RenderSystem.disableBlend();
    }

    public boolean keyPressed(int key, int b, int c) {
        if (key == 256) {
            this.minecraft.player.closeContainer();
            return true;
        }
        return super.keyPressed(key, b, c);
    }

    protected void renderLabels(GuiGraphics guiGraphics, int mouseX, int mouseY) {
        guiGraphics.drawString(this.font, CheckMoneyReturnProcedure.execute((Entity)this.entity), 6, 7, -16777216, false);
    }

    public void init() {
        super.init();
        this.button_withdraw_money = Button.builder((Component)Component.translatable((String)"gui.supermod.bankgui.button_withdraw_money"), e -> {
            int x = this.x;
            int y = this.y;
            PacketDistributor.sendToServer((CustomPacketPayload)new BankguiButtonMessage(0, x, y, this.z), (CustomPacketPayload[])new CustomPacketPayload[0]);
            BankguiButtonMessage.handleButtonAction(this.entity, 0, x, y, this.z);
        }).bounds(this.leftPos + 40, this.topPos + 28, 98, 20).build();
        this.addRenderableWidget((GuiEventListener)this.button_withdraw_money);
        this.button_deposit_money = Button.builder((Component)Component.translatable((String)"gui.supermod.bankgui.button_deposit_money"), e -> {
            int x = this.x;
            int y = this.y;
            PacketDistributor.sendToServer((CustomPacketPayload)new BankguiButtonMessage(1, x, y, this.z), (CustomPacketPayload[])new CustomPacketPayload[0]);
            BankguiButtonMessage.handleButtonAction(this.entity, 1, x, y, this.z);
        }).bounds(this.leftPos + 43, this.topPos + 52, 93, 20).build();
        this.addRenderableWidget((GuiEventListener)this.button_deposit_money);
    }
}

