/*
 * Decompiled with CFR 0.152.
 */
package net.manuflosoyt.supermod.client.gui;

import com.mojang.blaze3d.systems.RenderSystem;
import net.manuflosoyt.supermod.init.SupermodModScreens;
import net.manuflosoyt.supermod.network.QuarryUIButtonMessage;
import net.manuflosoyt.supermod.procedures.GetQuarryYLayerProcedure;
import net.manuflosoyt.supermod.world.inventory.QuarryUIMenu;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.EditBox;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.neoforged.neoforge.network.PacketDistributor;

public class QuarryUIScreen
extends AbstractContainerScreen<QuarryUIMenu>
implements SupermodModScreens.ScreenAccessor {
    private final Level world;
    private final int x;
    private final int y;
    private final int z;
    private final Player entity;
    private boolean menuStateUpdateActive = false;
    private EditBox YLayerInput;
    private Button button_ok;
    private static final ResourceLocation texture = ResourceLocation.parse((String)"supermod:textures/screens/quarry_ui.png");

    public QuarryUIScreen(QuarryUIMenu container, Inventory inventory, Component text) {
        super((AbstractContainerMenu)container, inventory, text);
        this.world = container.world;
        this.x = container.x;
        this.y = container.y;
        this.z = container.z;
        this.entity = container.entity;
        this.imageWidth = 176;
        this.imageHeight = 53;
    }

    @Override
    public void updateMenuState(int elementType, String name, Object elementState) {
        this.menuStateUpdateActive = true;
        if (elementType == 0 && elementState instanceof String) {
            String stringState = (String)elementState;
            if (name.equals("YLayerInput")) {
                this.YLayerInput.setValue(stringState);
            }
        }
        this.menuStateUpdateActive = false;
    }

    public void render(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTicks) {
        super.render(guiGraphics, mouseX, mouseY, partialTicks);
        this.YLayerInput.render(guiGraphics, mouseX, mouseY, partialTicks);
        this.renderTooltip(guiGraphics, mouseX, mouseY);
    }

    protected void renderBg(GuiGraphics guiGraphics, float partialTicks, int mouseX, int mouseY) {
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        RenderSystem.enableBlend();
        RenderSystem.defaultBlendFunc();
        guiGraphics.blit(texture, this.leftPos, this.topPos, 0.0f, 0.0f, this.imageWidth, this.imageHeight, this.imageWidth, this.imageHeight);
        RenderSystem.disableBlend();
    }

    public boolean keyPressed(int key, int b, int c) {
        if (key == 256) {
            this.minecraft.player.closeContainer();
            return true;
        }
        if (this.YLayerInput.isFocused()) {
            return this.YLayerInput.keyPressed(key, b, c);
        }
        return super.keyPressed(key, b, c);
    }

    public void resize(Minecraft minecraft, int width, int height) {
        String YLayerInputValue = this.YLayerInput.getValue();
        super.resize(minecraft, width, height);
        this.YLayerInput.setValue(YLayerInputValue);
    }

    protected void renderLabels(GuiGraphics guiGraphics, int mouseX, int mouseY) {
        guiGraphics.drawString(this.font, GetQuarryYLayerProcedure.execute((LevelAccessor)this.world, this.x, this.y, this.z), 87, 4, -12829636, false);
        guiGraphics.drawString(this.font, (Component)Component.translatable((String)"gui.supermod.quarry_ui.label_current_layer"), 6, 4, -12829636, false);
    }

    public void init() {
        super.init();
        this.YLayerInput = new EditBox(this.font, this.leftPos + 7, this.topPos + 23, 118, 18, (Component)Component.translatable((String)"gui.supermod.quarry_ui.YLayerInput"));
        this.YLayerInput.setMaxLength(8192);
        this.YLayerInput.setResponder(content -> {
            if (!this.menuStateUpdateActive) {
                ((QuarryUIMenu)this.menu).sendMenuStateUpdate(this.entity, 0, "YLayerInput", content, false);
            }
        });
        this.YLayerInput.setHint((Component)Component.translatable((String)"gui.supermod.quarry_ui.YLayerInput"));
        this.addWidget((GuiEventListener)this.YLayerInput);
        this.button_ok = Button.builder((Component)Component.translatable((String)"gui.supermod.quarry_ui.button_ok"), e -> {
            int x = this.x;
            int y = this.y;
            PacketDistributor.sendToServer((CustomPacketPayload)new QuarryUIButtonMessage(0, x, y, this.z), (CustomPacketPayload[])new CustomPacketPayload[0]);
            QuarryUIButtonMessage.handleButtonAction(this.entity, 0, x, y, this.z);
        }).bounds(this.leftPos + 132, this.topPos + 22, 35, 20).build();
        this.addRenderableWidget((GuiEventListener)this.button_ok);
    }
}

