/*
 * Decompiled with CFR 0.152.
 */
package net.manuflosoyt.supermod.client.gui;

import com.mojang.blaze3d.systems.RenderSystem;
import net.manuflosoyt.supermod.init.SupermodModScreens;
import net.manuflosoyt.supermod.network.SacarButtonMessage;
import net.manuflosoyt.supermod.procedures.CheckMoneyReturnProcedure;
import net.manuflosoyt.supermod.world.inventory.SacarMenu;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.EditBox;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.level.Level;
import net.neoforged.neoforge.network.PacketDistributor;

public class SacarScreen
extends AbstractContainerScreen<SacarMenu>
implements SupermodModScreens.ScreenAccessor {
    private final Level world;
    private final int x;
    private final int y;
    private final int z;
    private final Player entity;
    private boolean menuStateUpdateActive = false;
    private EditBox cantidad;
    private Button button_withdraw;
    private Button button_volver;
    private static final ResourceLocation texture = ResourceLocation.parse((String)"supermod:textures/screens/sacar.png");

    public SacarScreen(SacarMenu container, Inventory inventory, Component text) {
        super((AbstractContainerMenu)container, inventory, text);
        this.world = container.world;
        this.x = container.x;
        this.y = container.y;
        this.z = container.z;
        this.entity = container.entity;
        this.imageWidth = 176;
        this.imageHeight = 166;
    }

    @Override
    public void updateMenuState(int elementType, String name, Object elementState) {
        this.menuStateUpdateActive = true;
        if (elementType == 0 && elementState instanceof String) {
            String stringState = (String)elementState;
            if (name.equals("cantidad")) {
                this.cantidad.setValue(stringState);
            }
        }
        this.menuStateUpdateActive = false;
    }

    public void render(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTicks) {
        super.render(guiGraphics, mouseX, mouseY, partialTicks);
        this.cantidad.render(guiGraphics, mouseX, mouseY, partialTicks);
        this.renderTooltip(guiGraphics, mouseX, mouseY);
    }

    protected void renderBg(GuiGraphics guiGraphics, float partialTicks, int mouseX, int mouseY) {
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        RenderSystem.enableBlend();
        RenderSystem.defaultBlendFunc();
        guiGraphics.blit(texture, this.leftPos, this.topPos, 0.0f, 0.0f, this.imageWidth, this.imageHeight, this.imageWidth, this.imageHeight);
        RenderSystem.disableBlend();
    }

    public boolean keyPressed(int key, int b, int c) {
        if (key == 256) {
            this.minecraft.player.closeContainer();
            return true;
        }
        if (this.cantidad.isFocused()) {
            return this.cantidad.keyPressed(key, b, c);
        }
        return super.keyPressed(key, b, c);
    }

    public void resize(Minecraft minecraft, int width, int height) {
        String cantidadValue = this.cantidad.getValue();
        super.resize(minecraft, width, height);
        this.cantidad.setValue(cantidadValue);
    }

    protected void renderLabels(GuiGraphics guiGraphics, int mouseX, int mouseY) {
        guiGraphics.drawString(this.font, CheckMoneyReturnProcedure.execute((Entity)this.entity), 6, 7, -16777216, false);
    }

    public void init() {
        super.init();
        this.cantidad = new EditBox(this.font, this.leftPos + 7, this.topPos + 62, 118, 18, (Component)Component.translatable((String)"gui.supermod.sacar.cantidad"));
        this.cantidad.setMaxLength(8192);
        this.cantidad.setResponder(content -> {
            if (!this.menuStateUpdateActive) {
                ((SacarMenu)this.menu).sendMenuStateUpdate(this.entity, 0, "cantidad", content, false);
            }
        });
        this.cantidad.setHint((Component)Component.translatable((String)"gui.supermod.sacar.cantidad"));
        this.addWidget((GuiEventListener)this.cantidad);
        this.button_withdraw = Button.builder((Component)Component.translatable((String)"gui.supermod.sacar.button_withdraw"), e -> {
            int x = this.x;
            int y = this.y;
            PacketDistributor.sendToServer((CustomPacketPayload)new SacarButtonMessage(0, x, y, this.z), (CustomPacketPayload[])new CustomPacketPayload[0]);
            SacarButtonMessage.handleButtonAction(this.entity, 0, x, y, this.z);
        }).bounds(this.leftPos + 6, this.topPos + 34, 67, 20).build();
        this.addRenderableWidget((GuiEventListener)this.button_withdraw);
        this.button_volver = Button.builder((Component)Component.translatable((String)"gui.supermod.sacar.button_volver"), e -> {
            int x = this.x;
            int y = this.y;
            PacketDistributor.sendToServer((CustomPacketPayload)new SacarButtonMessage(1, x, y, this.z), (CustomPacketPayload[])new CustomPacketPayload[0]);
            SacarButtonMessage.handleButtonAction(this.entity, 1, x, y, this.z);
        }).bounds(this.leftPos + 114, this.topPos + 34, 56, 20).build();
        this.addRenderableWidget((GuiEventListener)this.button_volver);
    }
}

