/*
 * Decompiled with CFR 0.152.
 */
package net.manuflosoyt.supermod.fluid;

import net.manuflosoyt.supermod.init.SupermodModBlocks;
import net.manuflosoyt.supermod.init.SupermodModFluidTypes;
import net.manuflosoyt.supermod.init.SupermodModFluids;
import net.manuflosoyt.supermod.init.SupermodModItems;
import net.manuflosoyt.supermod.init.SupermodModParticleTypes;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.SimpleParticleType;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.block.LiquidBlock;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidState;
import net.neoforged.neoforge.fluids.BaseFlowingFluid;
import net.neoforged.neoforge.fluids.FluidType;

public abstract class EndWaterFluid
extends BaseFlowingFluid {
    public static final BaseFlowingFluid.Properties PROPERTIES = new BaseFlowingFluid.Properties(() -> (FluidType)SupermodModFluidTypes.END_WATER_TYPE.get(), () -> (Fluid)SupermodModFluids.END_WATER.get(), () -> (Fluid)SupermodModFluids.FLOWING_END_WATER.get()).explosionResistance(100.0f).bucket(() -> (Item)SupermodModItems.END_WATER_BUCKET.get()).block(() -> (LiquidBlock)SupermodModBlocks.END_WATER.get());

    private EndWaterFluid() {
        super(PROPERTIES);
    }

    public ParticleOptions getDripParticle() {
        return (SimpleParticleType)SupermodModParticleTypes.ENDERWATERDROP.get();
    }

    public static class Flowing
    extends EndWaterFluid {
        protected void createFluidStateDefinition(StateDefinition.Builder<Fluid, FluidState> builder) {
            super.createFluidStateDefinition(builder);
            builder.add(new Property[]{LEVEL});
        }

        public int getAmount(FluidState state) {
            return (Integer)state.getValue((Property)LEVEL);
        }

        public boolean isSource(FluidState state) {
            return false;
        }
    }

    public static class Source
    extends EndWaterFluid {
        public int getAmount(FluidState state) {
            return 8;
        }

        public boolean isSource(FluidState state) {
            return true;
        }
    }
}

